/*
 * Decompiled with CFR 0.152.
 */
package artifacts.registry;

import artifacts.loot.ConfigurableRandomChance;
import artifacts.loot.EverlastingBeefChance;
import artifacts.registry.RegistrySupplier;
import dev.architectury.registry.registries.DeferredRegister;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class ModLootConditions {
    public static final DeferredRegister<LootItemConditionType> LOOT_CONDITIONS = DeferredRegister.create((String)"artifacts", (ResourceKey)Registries.f_256976_);
    public static final RegistrySupplier<LootItemConditionType> CONFIGURABLE_ARTIFACT_CHANCE = ModLootConditions.register("configurable_random_chance", ConfigurableRandomChance.Serializer::new);
    public static final RegistrySupplier<LootItemConditionType> EVERLASTING_BEEF_CHANCE = ModLootConditions.register("everlasting_beef_chance", EverlastingBeefChance.Serializer::new);

    private static RegistrySupplier<LootItemConditionType> register(String name, Supplier<Serializer<? extends LootItemCondition>> serializer) {
        return RegistrySupplier.of(LOOT_CONDITIONS.register(name, () -> new LootItemConditionType((Serializer)serializer.get())));
    }
}

