/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts;

import de.mennomax.astikorcarts.AstikorCarts;
import de.mennomax.astikorcarts.Initializer;
import de.mennomax.astikorcarts.config.AstikorCartsConfig;
import de.mennomax.astikorcarts.entity.PostilionEntity;
import de.mennomax.astikorcarts.entity.ai.goal.PullCartGoal;
import de.mennomax.astikorcarts.entity.ai.goal.RideCartGoal;
import de.mennomax.astikorcarts.util.GoalAdder;
import de.mennomax.astikorcarts.world.AstikorWorld;
import de.mennomax.astikorcarts.world.SimpleAstikorWorld;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolderRegistry;

public class CommonInitializer
implements Initializer {
    @Override
    public void init(Initializer.Context mod) {
        final ModContainer container = mod.context().getActiveContainer();
        ObjectHolderRegistry.addHandler((Consumer)new Consumer<Predicate<ResourceLocation>>(){
            boolean run = true;

            @Override
            public void accept(Predicate<ResourceLocation> filter) {
                if (this.run && filter.test(ForgeRegistries.ENTITIES.getRegistryName())) {
                    container.addConfig(new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)AstikorCartsConfig.spec(), container));
                    this.run = false;
                    ((BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(EffectiveSide.get())).execute(() -> ObjectHolderRegistry.removeHandler((Consumer)this));
                }
            }
        });
        mod.modBus().addListener(e -> e.put((EntityType)AstikorCarts.EntityTypes.POSTILION.get(), LivingEntity.m_21183_().m_22265_()));
        mod.bus().addGenericListener(Level.class, e -> e.addCapability(new ResourceLocation("astikorcarts", "astikor"), AstikorWorld.createProvider((NonNullSupplier<AstikorWorld>)((NonNullSupplier)SimpleAstikorWorld::new))));
        GoalAdder.mobGoal(Mob.class).add(1, PullCartGoal::new).add(1, RideCartGoal::new).build().register(mod.bus());
        mod.bus().addListener(e -> {
            Entity rider = e.getTarget().m_6688_();
            if (rider instanceof PostilionEntity) {
                rider.m_8127_();
            }
        });
        mod.bus().addListener(e -> {
            if (e.phase == TickEvent.Phase.END) {
                AstikorWorld.get(e.world).ifPresent(AstikorWorld::tick);
            }
        });
    }
}

