/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.client.oregon;

import cpw.mods.modlauncher.api.INameMappingService;
import de.mennomax.astikorcarts.AstikorCarts;
import de.mennomax.astikorcarts.oregon.BasicProgram;
import de.mennomax.astikorcarts.oregon.Oregon;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.stats.Stat;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class OregonSubscriber {
    private static final Logger LOGGER = LogManager.getLogger();
    private State state = new IdleState();

    public void register(IEventBus bus) {
        bus.addListener(this::onScreenKeyPressed);
    }

    private void onScreenKeyPressed(ScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        block4: {
            Screen screen;
            block5: {
                Minecraft mc = Minecraft.m_91087_();
                screen = event.getScreen();
                if (screen instanceof StatsScreen && (event.getKeyCode() == 257 || event.getKeyCode() == 335) && mc.f_91074_ != null) {
                    this.getSelectedStat((StatsScreen)screen).ifPresent(stat -> {
                        if (AstikorCarts.Stats.CART_ONE_CM.get().equals(stat.m_12867_())) {
                            PlayerIO io = new PlayerIO();
                            Oregon oregon = new Oregon(io, new Random());
                            this.setState(new ActiveState(new Thread(() -> {
                                try {
                                    oregon.run();
                                }
                                finally {
                                    mc.execute(() -> this.setState(new IdleState()));
                                }
                            }, "Oregon Trail 1978"), io));
                        }
                    });
                }
                if (!(screen instanceof ChatScreen)) break block4;
                if (event.getKeyCode() == 257) break block5;
                if (event.getKeyCode() != 335) break block4;
            }
            screen.m_6702_().stream().filter(EditBox.class::isInstance).map(EditBox.class::cast).findFirst().ifPresent(field -> {
                if (this.state.onChat((EditBox)field)) {
                    event.setCanceled(true);
                }
            });
        }
    }

    private Optional<Stat<?>> getSelectedStat(StatsScreen screen) {
        Stat stat;
        Class<?> classCustomStatsList$Entry;
        ObjectSelectionList list = screen.m_96983_();
        if (list == null) {
            return Optional.empty();
        }
        try {
            classCustomStatsList$Entry = Class.forName("net.minecraft.client.gui.screens.achievement.StatsScreen$GeneralStatisticsList$Entry");
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Unable to lookup custom stat entry class", (Throwable)e);
            return Optional.empty();
        }
        ObjectSelectionList.Entry entry = (ObjectSelectionList.Entry)list.m_93511_();
        if (!classCustomStatsList$Entry.isInstance(entry)) {
            return Optional.empty();
        }
        String statFieldName = ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)"f_97001_");
        try {
            Field fieldStat = classCustomStatsList$Entry.getDeclaredField(statFieldName);
            fieldStat.setAccessible(true);
            stat = (Stat)fieldStat.get(entry);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Unable to retrieve stat from entry; fields: {}", Arrays.asList(StatsScreen.class.getDeclaredFields()), (Object)e);
            return Optional.empty();
        }
        return Optional.of(stat);
    }

    private void setState(State newState) {
        this.state.stop();
        this.state = newState;
        this.state.start();
    }

    static class IdleState
    extends State {
        IdleState() {
        }

        @Override
        void start() {
        }

        @Override
        void stop() {
        }

        @Override
        public boolean onChat(EditBox field) {
            return false;
        }
    }

    static abstract class State {
        State() {
        }

        abstract void start();

        abstract void stop();

        abstract boolean onChat(EditBox var1);
    }

    static class PlayerIO
    implements BasicProgram.IO {
        final BlockingDeque<String> in = new LinkedBlockingDeque<String>();

        PlayerIO() {
        }

        void add(String s) {
            this.in.addLast(s);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                player.m_6352_((Component)new TextComponent(s).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.WHITE}), Util.f_137441_);
            }
        }

        @Override
        public int prompt(int lower, int upper) throws InterruptedException {
            try {
                return Integer.parseInt(this.in.takeFirst());
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }

        @Override
        public String prompt(String ... options) throws InterruptedException {
            return this.in.takeFirst();
        }

        @Override
        public void print(String s) {
            Minecraft mc = Minecraft.m_91087_();
            mc.execute(() -> {
                LocalPlayer player = mc.f_91074_;
                if (player != null) {
                    player.m_6352_((Component)new TextComponent(s).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}), Util.f_137441_);
                }
            });
        }
    }

    static class ActiveState
    extends State {
        final Thread thread;
        final PlayerIO io;

        ActiveState(Thread thread, PlayerIO io) {
            this.thread = thread;
            this.io = io;
        }

        @Override
        void start() {
            this.thread.setDaemon(true);
            this.thread.start();
            Minecraft.m_91087_().m_91152_((Screen)new ChatScreen("? "));
        }

        @Override
        void stop() {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91080_ instanceof ChatScreen) {
                mc.m_91152_(null);
            }
        }

        @Override
        public boolean onChat(EditBox field) {
            String text = field.m_94155_();
            if (text.startsWith("?")) {
                this.io.add(text.substring(1).trim());
                field.m_94144_("? ");
                return true;
            }
            return false;
        }
    }
}

