/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import de.mennomax.astikorcarts.AstikorCarts;
import de.mennomax.astikorcarts.client.renderer.AstikorCartsModelLayers;
import de.mennomax.astikorcarts.client.renderer.entity.DrawnRenderer;
import de.mennomax.astikorcarts.client.renderer.entity.model.SupplyCartModel;
import de.mennomax.astikorcarts.entity.SupplyCartEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.PaintingTextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.registries.ForgeRegistries;

public final class SupplyCartRenderer
extends DrawnRenderer<SupplyCartEntity, SupplyCartModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("astikorcarts", "textures/entity/supply_cart.png");
    private static final HumanoidArmorLayer<LivingEntity, HumanoidModel<LivingEntity>, HumanoidModel<LivingEntity>> DUMMY = new HumanoidArmorLayer(null, null, null);
    private final HumanoidModel<LivingEntity> leggings;
    private final HumanoidModel<LivingEntity> armor;

    public SupplyCartRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new SupplyCartModel(renderManager.m_174023_(AstikorCartsModelLayers.SUPPLY_CART)));
        this.leggings = new HumanoidModel(renderManager.m_174023_(ModelLayers.f_171164_));
        this.armor = new HumanoidModel(renderManager.m_174023_(ModelLayers.f_171165_));
        this.f_114477_ = 1.0f;
    }

    @Override
    protected void renderContents(SupplyCartEntity entity, float delta, PoseStack stack, MultiBufferSource source, int packedLight) {
        ItemStack s;
        super.renderContents(entity, delta, stack, source, packedLight);
        NonNullList<ItemStack> cargo = entity.getCargo();
        Contents contents = Contents.SUPPLIES;
        Iterator it = cargo.iterator();
        block0: while (it.hasNext()) {
            s = (ItemStack)it.next();
            if (s.m_41619_()) continue;
            for (Contents c : Contents.values()) {
                if (!c.predicate.test((ItemStack)s)) continue;
                contents = c;
                break block0;
            }
        }
        while (contents != Contents.SUPPLIES && it.hasNext()) {
            s = (ItemStack)it.next();
            if (s.m_41619_() || contents.predicate.test((ItemStack)s)) continue;
            contents = Contents.SUPPLIES;
        }
        stack.m_85836_();
        ((SupplyCartModel)this.model).getBody().m_104299_(stack);
        contents.renderer.render(this, entity, stack, source, packedLight, cargo);
        List<Pair<BannerPattern, DyeColor>> list = entity.getBannerPattern();
        if (!list.isEmpty()) {
            stack.m_85837_(0.0, -0.6, 1.5);
            this.renderBanner(stack, source, packedLight, list);
        }
        stack.m_85849_();
    }

    private void renderFlowers(SupplyCartEntity entity, PoseStack stack, MultiBufferSource source, int packedLight, NonNullList<ItemStack> cargo) {
        ((SupplyCartModel)this.model).getFlowerBasket().m_104301_(stack, source.m_6299_(((SupplyCartModel)this.model).m_103119_(this.getTextureLocation(entity))), packedLight, OverlayTexture.f_118083_);
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        ModelBlockRenderer renderer = dispatcher.m_110937_();
        for (int i = 0; i < cargo.size(); ++i) {
            ItemStack itemStack = (ItemStack)cargo.get(i);
            if (!(itemStack.m_41720_() instanceof BlockItem)) continue;
            int ix = i % 2;
            int iz = i / 2;
            BlockState defaultState = ((BlockItem)itemStack.m_41720_()).m_40614_().m_49966_();
            BlockState state = defaultState.m_61138_((Property)BlockStateProperties.f_61401_) ? (BlockState)defaultState.m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER) : defaultState;
            BakedModel model = dispatcher.m_110910_(state);
            int rgb = Minecraft.m_91087_().m_91298_().m_92577_(state, null, null, 0);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            stack.m_85836_();
            stack.m_85837_(0.0, -0.7, -0.1875);
            stack.m_85841_(0.65f, 0.65f, 0.65f);
            stack.m_85837_((double)ix, 0.5, (double)iz - 1.0);
            stack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            renderer.renderModel(stack.m_85850_(), source.m_6299_(RenderType.m_110463_()), state, model, r, g, b, packedLight, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
            stack.m_85849_();
        }
    }

    private void renderWheel(SupplyCartEntity entity, PoseStack stack, MultiBufferSource source, int packedLight, NonNullList<ItemStack> cargo) {
        stack.m_85836_();
        stack.m_85837_(1.18, 0.1, -0.15);
        ModelPart wheel = ((SupplyCartModel)this.model).getWheel();
        wheel.f_104203_ = 0.9f;
        wheel.f_104205_ = 0.9424779f;
        wheel.m_104301_(stack, source.m_6299_(((SupplyCartModel)this.model).m_103119_(this.getTextureLocation(entity))), packedLight, OverlayTexture.f_118083_);
        stack.m_85849_();
    }

    private void renderPaintings(SupplyCartEntity entity, PoseStack stack, MultiBufferSource source, int packedLight, NonNullList<ItemStack> cargo) {
        VertexConsumer buf = source.m_6299_(RenderType.m_110446_((ResourceLocation)Minecraft.m_91087_().m_91305_().m_118806_().m_118414_().m_118330_()));
        ObjectList types = (ObjectList)StreamSupport.stream(ForgeRegistries.PAINTING_TYPES.spliterator(), false).filter(t -> t.m_31896_() == 16 && t.m_31901_() == 16).collect(Collectors.toCollection(ObjectArrayList::new));
        Random rng = new Random(entity.m_142081_().getMostSignificantBits() ^ entity.m_142081_().getLeastSignificantBits());
        ObjectLists.shuffle((ObjectList)types, (Random)rng);
        int count = 0;
        for (ItemStack itemStack : cargo) {
            if (itemStack.m_41619_()) continue;
            ++count;
        }
        stack.m_85836_();
        stack.m_85837_(0.0, -0.15625, 0.0);
        stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
        int n = 0;
        for (int i = 0; i < cargo.size(); ++i) {
            ItemStack itemStack = (ItemStack)cargo.get(i);
            if (itemStack.m_41619_()) continue;
            Motive t2 = (Motive)types.get(i % types.size());
            stack.m_85836_();
            stack.m_85837_(0.0, ((double)n++ - (double)(count - 1) * 0.5) / (double)count, -0.0625 * (double)i);
            stack.m_85845_(Vector3f.f_122227_.m_122270_(rng.nextFloat() * (float)Math.PI));
            this.renderPainting(t2, stack, buf, packedLight);
            stack.m_85849_();
        }
        stack.m_85849_();
    }

    private void renderSupplies(SupplyCartEntity entity, PoseStack stack, MultiBufferSource source, int packedLight, NonNullList<ItemStack> cargo) {
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        Random rng = new Random();
        for (int i = 0; i < cargo.size(); ++i) {
            ItemStack itemStack = (ItemStack)cargo.get(i);
            if (itemStack.m_41619_()) continue;
            int ix = i % 2;
            int iz = i / 2;
            if (i < cargo.size() - 2 && ((ItemStack)cargo.get(i + 2)).m_204117_(ItemTags.f_13146_) || i >= 2 && ((ItemStack)cargo.get(i - 2)).m_204117_(ItemTags.f_13146_)) continue;
            double x = ((double)ix - 0.5) * 11.0 / 16.0;
            double z = ((double)iz * 11.0 - 9.0) / 16.0;
            BakedModel model = renderer.m_174264_(itemStack, entity.f_19853_, null, i);
            stack.m_85836_();
            if (model.m_7539_() && itemStack.m_41720_() != Items.f_42713_) {
                stack.m_85837_(x, -0.46, z);
                stack.m_85841_(0.65f, 0.65f, 0.65f);
                stack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                if (itemStack.m_41720_() == Items.f_42740_) {
                    stack.m_85841_(1.2f, 1.2f, 1.2f);
                    stack.m_85845_(Vector3f.f_122225_.m_122240_(ix == 0 ? -90.0f : 90.0f));
                    stack.m_85837_(0.5, 0.8, -0.05);
                    stack.m_85845_(Vector3f.f_122223_.m_122240_(-22.5f));
                } else if (iz < 1 && itemStack.m_204117_(ItemTags.f_13146_)) {
                    stack.m_85837_(0.0, 0.0, 1.0);
                } else if (!model.m_7521_()) {
                    stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                }
                renderer.m_115143_(itemStack, ItemTransforms.TransformType.NONE, false, stack, source, packedLight, OverlayTexture.f_118083_, model);
            } else {
                rng.setSeed(32L * (long)i + (long)Objects.hashCode(itemStack.m_41720_().getRegistryName()));
                stack.m_85837_(x, -0.15 + ((ix + iz) % 2 == 0 ? 0.0 : 1.0E-4), z);
                if (ArmorItem.class.equals(itemStack.m_41720_().getClass()) || DyeableArmorItem.class.equals(itemStack.m_41720_().getClass())) {
                    this.renderArmor(entity, stack, source, packedLight, itemStack, ix);
                } else {
                    stack.m_85841_(0.7f, 0.7f, 0.7f);
                    stack.m_85845_(Vector3f.f_122225_.m_122270_(rng.nextFloat() * (float)Math.PI));
                    stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                    int copies = Math.min(itemStack.m_41613_(), (itemStack.m_41613_() - 1) / 16 + 2);
                    renderer.m_115143_(itemStack, ItemTransforms.TransformType.FIXED, false, stack, source, packedLight, OverlayTexture.f_118083_, model);
                    for (int n = 1; n < copies; ++n) {
                        stack.m_85836_();
                        stack.m_85845_(Vector3f.f_122227_.m_122270_(rng.nextFloat() * (float)Math.PI));
                        stack.m_85837_((double)((rng.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)((rng.nextFloat() * 2.0f - 1.0f) * 0.05f), -0.1 * (double)n);
                        renderer.m_115143_(itemStack, ItemTransforms.TransformType.FIXED, false, stack, source, packedLight, OverlayTexture.f_118083_, model);
                        stack.m_85849_();
                    }
                }
            }
            stack.m_85849_();
        }
    }

    private void renderArmor(SupplyCartEntity entity, PoseStack stack, MultiBufferSource source, int packedLight, ItemStack itemStack, int ix) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return;
        }
        ArmorItem armor = (ArmorItem)item;
        EquipmentSlot slot = LivingEntity.m_147233_((ItemStack)itemStack);
        HumanoidModel<LivingEntity> m = slot == EquipmentSlot.LEGS ? this.leggings : this.armor;
        stack.m_85845_(Vector3f.f_122225_.m_122270_(ix == 0 ? 1.5707964f : -1.5707964f));
        m.m_8009_(false);
        m.f_102815_ = HumanoidModel.ArmPose.EMPTY;
        m.f_102816_ = HumanoidModel.ArmPose.EMPTY;
        m.f_102817_ = false;
        m.f_102818_ = 0.0f;
        m.f_102610_ = false;
        switch (slot) {
            case HEAD: {
                stack.m_85837_(0.0, 0.1, 0.0);
                m.f_102808_.f_104203_ = 0.2f;
                m.f_102809_.m_104315_(m.f_102808_);
                m.f_102808_.f_104207_ = true;
                m.f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                stack.m_85837_(0.0, -0.4, -0.15);
                m.f_102812_.f_104203_ = -0.15f;
                m.f_102811_.f_104203_ = -0.15f;
                m.f_102810_.f_104203_ = 0.9f;
                m.f_102810_.f_104207_ = true;
                m.f_102811_.f_104207_ = true;
                m.f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                stack.m_85837_(0.0, -0.7, -0.15);
                m.f_102810_.f_104203_ = 0.0f;
                m.f_102813_.f_104203_ = 1.2f;
                m.f_102814_.f_104203_ = 1.2f;
                m.f_102813_.f_104204_ = -0.3f;
                m.f_102814_.f_104204_ = 0.3f;
                m.f_102810_.f_104207_ = true;
                m.f_102813_.f_104207_ = true;
                m.f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                stack.m_85837_(0.0, -1.15, -0.1);
                m.f_102813_.f_104203_ = 0.0f;
                m.f_102814_.f_104203_ = 0.0f;
                m.f_102813_.f_104204_ = -0.1f;
                m.f_102814_.f_104204_ = 0.0f;
                m.f_102813_.f_104207_ = true;
                m.f_102814_.f_104207_ = true;
            }
        }
        stack.m_85841_(0.75f, 0.75f, 0.75f);
        VertexConsumer armorBuf = ItemRenderer.m_115184_((MultiBufferSource)source, (RenderType)RenderType.m_110431_((ResourceLocation)DUMMY.getArmorResource((Entity)entity, itemStack, slot, null)), (boolean)false, (boolean)itemStack.m_41790_());
        if (armor instanceof DyeableArmorItem) {
            int rgb = ((DyeableArmorItem)armor).m_41121_(itemStack);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            m.m_7695_(stack, armorBuf, packedLight, OverlayTexture.f_118083_, r, g, b, 1.0f);
            VertexConsumer overlayBuf = ItemRenderer.m_115184_((MultiBufferSource)source, (RenderType)RenderType.m_110431_((ResourceLocation)DUMMY.getArmorResource((Entity)entity, itemStack, slot, "overlay")), (boolean)false, (boolean)itemStack.m_41790_());
            m.m_7695_(stack, overlayBuf, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            m.m_7695_(stack, armorBuf, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private void renderPainting(Motive painting, PoseStack stack, VertexConsumer buf, int packedLight) {
        PaintingTextureManager uploader = Minecraft.m_91087_().m_91305_();
        int width = painting.m_31896_();
        int height = painting.m_31901_();
        TextureAtlasSprite art = uploader.m_118804_(painting);
        TextureAtlasSprite back = uploader.m_118806_();
        Matrix4f model = stack.m_85850_().m_85861_();
        Matrix3f normal = stack.m_85850_().m_85864_();
        int blockWidth = width / 16;
        int blockHeight = height / 16;
        float offsetX = (float)(-blockWidth) / 2.0f;
        float offsetY = (float)(-blockHeight) / 2.0f;
        float depth = 0.03125f;
        float bu0 = back.m_118409_();
        float bu1 = back.m_118410_();
        float bv0 = back.m_118411_();
        float bv1 = back.m_118412_();
        float bup = back.m_118367_(1.0);
        float bvp = back.m_118393_(1.0);
        double uvX = 16.0 / (double)blockWidth;
        double uvY = 16.0 / (double)blockHeight;
        for (int x = 0; x < blockWidth; ++x) {
            for (int y = 0; y < blockHeight; ++y) {
                float x1 = offsetX + (float)(x + 1);
                float x0 = offsetX + (float)x;
                float y1 = offsetY + (float)(y + 1);
                float y0 = offsetY + (float)y;
                float u0 = art.m_118367_(uvX * (double)(blockWidth - x));
                float u1 = art.m_118367_(uvX * (double)(blockWidth - x - 1));
                float v0 = art.m_118393_(uvY * (double)(blockHeight - y));
                float v1 = art.m_118393_(uvY * (double)(blockHeight - y - 1));
                this.vert(model, normal, buf, x1, y0, u1, v0, -0.03125f, 0, 0, -1, packedLight);
                this.vert(model, normal, buf, x0, y0, u0, v0, -0.03125f, 0, 0, -1, packedLight);
                this.vert(model, normal, buf, x0, y1, u0, v1, -0.03125f, 0, 0, -1, packedLight);
                this.vert(model, normal, buf, x1, y1, u1, v1, -0.03125f, 0, 0, -1, packedLight);
                this.vert(model, normal, buf, x1, y1, bu0, bv0, 0.03125f, 0, 0, 1, packedLight);
                this.vert(model, normal, buf, x0, y1, bu1, bv0, 0.03125f, 0, 0, 1, packedLight);
                this.vert(model, normal, buf, x0, y0, bu1, bv1, 0.03125f, 0, 0, 1, packedLight);
                this.vert(model, normal, buf, x1, y0, bu0, bv1, 0.03125f, 0, 0, 1, packedLight);
                this.vert(model, normal, buf, x1, y1, bu0, bv0, -0.03125f, 0, 1, 0, packedLight);
                this.vert(model, normal, buf, x0, y1, bu1, bv0, -0.03125f, 0, 1, 0, packedLight);
                this.vert(model, normal, buf, x0, y1, bu1, bvp, 0.03125f, 0, 1, 0, packedLight);
                this.vert(model, normal, buf, x1, y1, bu0, bvp, 0.03125f, 0, 1, 0, packedLight);
                this.vert(model, normal, buf, x1, y0, bu0, bv0, 0.03125f, 0, -1, 0, packedLight);
                this.vert(model, normal, buf, x0, y0, bu1, bv0, 0.03125f, 0, -1, 0, packedLight);
                this.vert(model, normal, buf, x0, y0, bu1, bvp, -0.03125f, 0, -1, 0, packedLight);
                this.vert(model, normal, buf, x1, y0, bu0, bvp, -0.03125f, 0, -1, 0, packedLight);
                this.vert(model, normal, buf, x1, y1, bup, bv0, 0.03125f, -1, 0, 0, packedLight);
                this.vert(model, normal, buf, x1, y0, bup, bv1, 0.03125f, -1, 0, 0, packedLight);
                this.vert(model, normal, buf, x1, y0, bu0, bv1, -0.03125f, -1, 0, 0, packedLight);
                this.vert(model, normal, buf, x1, y1, bu0, bv0, -0.03125f, -1, 0, 0, packedLight);
                this.vert(model, normal, buf, x0, y1, bup, bv0, -0.03125f, 1, 0, 0, packedLight);
                this.vert(model, normal, buf, x0, y0, bup, bv1, -0.03125f, 1, 0, 0, packedLight);
                this.vert(model, normal, buf, x0, y0, bu0, bv1, 0.03125f, 1, 0, 0, packedLight);
                this.vert(model, normal, buf, x0, y1, bu0, bv0, 0.03125f, 1, 0, 0, packedLight);
            }
        }
    }

    private void vert(Matrix4f stack, Matrix3f normal, VertexConsumer buf, float x, float y, float u, float v, float z, int nx, int ny, int nz, int packedLight) {
        buf.m_85982_(stack, x, y, z).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(normal, (float)nx, (float)ny, (float)nz).m_5752_();
    }

    public ResourceLocation getTextureLocation(SupplyCartEntity entity) {
        return TEXTURE;
    }

    private static enum Contents {
        FLOWERS(s -> s.m_41720_() instanceof BlockItem && s.m_204117_(ItemTags.f_13149_), SupplyCartRenderer::renderFlowers),
        PAINTINGS(s -> s.m_41720_() == Items.f_42487_, SupplyCartRenderer::renderPaintings),
        WHEEL(s -> AstikorCarts.Items.WHEEL.filter(s.m_41720_()::equals).isPresent(), SupplyCartRenderer::renderWheel),
        SUPPLIES(s -> true, SupplyCartRenderer::renderSupplies);

        private final Predicate<? super ItemStack> predicate;
        private final ContentsRenderer renderer;

        private Contents(Predicate<? super ItemStack> predicate, ContentsRenderer renderer) {
            this.predicate = predicate;
            this.renderer = renderer;
        }
    }

    @FunctionalInterface
    private static interface ContentsRenderer {
        public void render(SupplyCartRenderer var1, SupplyCartEntity var2, PoseStack var3, MultiBufferSource var4, int var5, NonNullList<ItemStack> var6);
    }
}

