/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.util;

import de.mennomax.astikorcarts.util.RegObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class DefRegister {
    private final String namespace;

    public DefRegister(String namespace) {
        this.namespace = namespace;
    }

    public <T extends IForgeRegistryEntry<T>> Forge<T> of(IForgeRegistry<T> registry) {
        return new Forge<T>(this.namespace, registry);
    }

    public <T, X extends IForgeRegistryEntry<X>> Vanilla<T, Void> of(Class<X> type, Registry<T> registry) {
        return new Vanilla<Object, Void>(this.namespace, type, registry, (t, v) -> {}, rl -> null);
    }

    public <T, N, X extends IForgeRegistryEntry<X>> Vanilla<T, N> of(Class<X> type, Registry<T> registry, BiConsumer<T, N> callback, Function<ResourceLocation, N> defaultData) {
        return new Vanilla<T, N>(this.namespace, type, registry, callback, defaultData);
    }

    public void registerAll(IEventBus bus, Register ... registers) {
        for (Register register : registers) {
            register.register(bus);
        }
    }

    public static final class Forge<T extends IForgeRegistryEntry<T>>
    implements Register {
        final IForgeRegistry<T> registry;
        final String namespace;
        final List<Supplier<? extends T>> entries = new ArrayList<Supplier<? extends T>>();

        private Forge(String namespace, IForgeRegistry<T> registry) {
            this.namespace = namespace;
            this.registry = registry;
        }

        public <U extends T> RegObject<T, U> make(String name, Supplier<U> supplier) {
            return this.make(name, (ResourceLocation rl) -> (IForgeRegistryEntry)supplier.get());
        }

        public <U extends T> RegObject<T, U> make(String name, Function<ResourceLocation, U> supplier) {
            ResourceLocation key = new ResourceLocation(this.namespace, name);
            this.entries.add(() -> (IForgeRegistryEntry)((IForgeRegistryEntry)supplier.apply(key)).setRegistryName(key));
            return RegObject.of(key, this.registry);
        }

        @Override
        public void register(IEventBus bus) {
            bus.addGenericListener(this.registry.getRegistrySuperType(), this::onRegister);
        }

        private void onRegister(RegistryEvent.Register<T> event) {
            this.entries.forEach(sup -> this.registry.register((IForgeRegistryEntry)sup.get()));
        }
    }

    public static final class Vanilla<T, N>
    implements Register {
        final String namespace;
        final Class<? extends IForgeRegistryEntry<?>> type;
        final Registry<T> registry;
        final BiConsumer<T, N> callback;
        final Function<ResourceLocation, N> defaultData;
        final List<Runnable> entries = new ArrayList<Runnable>();

        private Vanilla(String namespace, Class<? extends IForgeRegistryEntry<?>> type, Registry<T> registry, BiConsumer<T, N> callback, Function<ResourceLocation, N> defaultData) {
            this.namespace = namespace;
            this.type = type;
            this.registry = registry;
            this.callback = callback;
            this.defaultData = defaultData;
        }

        public <U extends T> Supplier<U> make(String name, Function<ResourceLocation, U> object) {
            return this.make(name, object, this.defaultData);
        }

        public <U extends T> Supplier<U> make(String name, Function<ResourceLocation, U> object, Function<ResourceLocation, N> data) {
            ResourceLocation key = new ResourceLocation(this.namespace, name);
            this.entries.add(() -> {
                Object u = Registry.m_122965_(this.registry, (ResourceLocation)key, object.apply(key));
                this.callback.accept(u, data.apply(key));
            });
            return () -> {
                Object t = this.registry.m_7745_(key);
                if (t == null) {
                    throw new IllegalStateException();
                }
                return t;
            };
        }

        @Override
        public void register(IEventBus bus) {
            bus.addGenericListener(this.type, e -> this.entries.forEach(Runnable::run));
        }
    }

    public static interface Register {
        public void register(IEventBus var1);
    }
}

