/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.util;

import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolderRegistry;

public final class RegObject<T extends IForgeRegistryEntry<T>, U extends T>
implements Predicate<T> {
    private final ResourceLocation name;
    @Nullable
    private U value;

    public RegObject(ResourceLocation name) {
        this.name = name;
    }

    public U get() {
        if (this.value == null) {
            throw new NoSuchElementException("Registry object not present: " + this.name);
        }
        return this.value;
    }

    @Override
    public boolean test(T other) {
        return this.value != null && this.value == other;
    }

    public Stream<T> stream() {
        return this.value == null ? Stream.empty() : Stream.of(this.value);
    }

    public static <T extends IForgeRegistryEntry<T>, U extends T> RegObject<T, U> of(ResourceLocation name, IForgeRegistry<T> registry) {
        RegObject<T, U> obj = new RegObject<T, U>(name);
        ObjectHolderRegistry.addHandler(n -> {
            if (n.test(registry.getRegistryName())) {
                obj.value = registry.containsKey(name) ? registry.getValue(name) : null;
            }
        });
        return obj;
    }
}

