/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.entity;

import com.mojang.datafixers.util.Pair;
import de.mennomax.astikorcarts.AstikorCarts;
import de.mennomax.astikorcarts.config.AstikorCartsConfig;
import de.mennomax.astikorcarts.network.clientbound.UpdateDrawnMessage;
import de.mennomax.astikorcarts.util.CartWheel;
import de.mennomax.astikorcarts.world.AstikorWorld;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public abstract class AbstractDrawnEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Integer> TIME_SINCE_HIT = SynchedEntityData.m_135353_(AbstractDrawnEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FORWARD_DIRECTION = SynchedEntityData.m_135353_(AbstractDrawnEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE_TAKEN = SynchedEntityData.m_135353_(AbstractDrawnEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<ItemStack> BANNER = SynchedEntityData.m_135353_(AbstractDrawnEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final UUID PULL_SLOWLY_MODIFIER_UUID = UUID.fromString("49B0E52E-48F2-4D89-BED7-4F5DF26F1263");
    private static final UUID PULL_MODIFIER_UUID = UUID.fromString("BA594616-5BE3-46C6-8B40-7D0230C64B77");
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    protected List<CartWheel> wheels;
    private int pullingId = -1;
    private UUID pullingUUID = null;
    protected double spacing = 1.7;
    public Entity pulling;
    protected AbstractDrawnEntity drawn;

    public AbstractDrawnEntity(EntityType<? extends Entity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.f_19793_ = 1.2f;
        this.f_19850_ = true;
        this.initWheels();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB m_6921_() {
        return this.m_20191_().m_82377_(3.0, 3.0, 3.0);
    }

    public void m_8119_() {
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (!this.m_20068_()) {
            this.m_20334_(0.0, this.m_20184_().f_82480_ - 0.08, 0.0);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        super.m_8119_();
        this.tickLerp();
        if (this.pulling == null) {
            this.m_146926_(25.0f);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.attemptReattach();
        }
        for (Entity entity : this.f_19853_.m_6249_((Entity)this, this.m_20191_(), EntitySelector.m_20421_((Entity)this))) {
            this.m_7334_(entity);
        }
    }

    public void pulledTick() {
        if (this.pulling == null) {
            return;
        }
        Vec3 targetVec = this.getRelativeTargetVec(1.0f);
        this.handleRotation(targetVec);
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
        if (this.pulling.m_20096_()) {
            targetVec = new Vec3(targetVec.f_82479_, 0.0, targetVec.f_82481_);
        }
        double targetVecLength = targetVec.m_82553_();
        double r = 0.2;
        double relativeSpacing = Math.max(this.spacing + 0.5 * (double)this.pulling.m_20205_(), 1.0);
        double diff = targetVecLength - relativeSpacing;
        Vec3 move = Math.abs(diff) < 0.2 ? this.m_20184_() : this.m_20184_().m_82549_(targetVec.m_82546_(targetVec.m_82541_().m_82490_(relativeSpacing + 0.2 * Math.signum(diff))));
        this.f_19861_ = true;
        double startX = this.m_20185_();
        double startY = this.m_20186_();
        double startZ = this.m_20189_();
        this.m_6478_(MoverType.SELF, move);
        if (!this.m_6084_()) {
            return;
        }
        this.addStats(this.m_20185_() - startX, this.m_20186_() - startY, this.m_20189_() - startZ);
        if (this.f_19853_.f_46443_) {
            for (CartWheel wheel : this.wheels) {
                wheel.tick();
            }
        } else {
            targetVec = this.getRelativeTargetVec(1.0f);
            if (targetVec.m_82553_() > relativeSpacing + 1.0) {
                this.setPulling(null);
            }
        }
        this.updatePassengers();
        if (this.drawn != null) {
            this.drawn.pulledTick();
        }
    }

    private void addStats(double x, double y, double z) {
        int cm;
        if (!this.f_19853_.f_46443_ && (cm = Math.round(Mth.m_14116_((float)((float)(x * x + y * y + z * z))) * 100.0f)) > 0) {
            for (Entity passenger : this.m_20197_()) {
                if (!(passenger instanceof Player)) continue;
                Player player = (Player)passenger;
                player.m_36222_(AstikorCarts.Stats.CART_ONE_CM, cm);
            }
        }
    }

    public void initWheels() {
        this.wheels = Arrays.asList(new CartWheel(this, 0.9f), new CartWheel(this, -0.9f));
    }

    public boolean shouldRemovePulling() {
        if (this.f_19862_) {
            Vec3 end;
            Vec3 start = new Vec3(this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_());
            BlockHitResult result = this.f_19853_.m_45547_(new ClipContext(start, end = new Vec3(this.pulling.m_20185_(), this.pulling.m_20186_() + (double)(this.pulling.m_20206_() / 2.0f), this.pulling.m_20189_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            return result.m_6662_() == HitResult.Type.BLOCK;
        }
        return false;
    }

    public void updatePassengers() {
        for (Entity passenger : this.m_20197_()) {
            this.m_7332_(passenger);
        }
    }

    @Nullable
    public Entity getPulling() {
        return this.pulling;
    }

    public void setPulling(Entity entityIn) {
        if (!this.f_19853_.f_46443_) {
            if (this.canBePulledBy(entityIn)) {
                if (entityIn == null) {
                    if (this.pulling instanceof LivingEntity) {
                        AttributeInstance attr = ((LivingEntity)this.pulling).m_21051_(Attributes.f_22279_);
                        if (attr != null) {
                            attr.m_22120_(PULL_SLOWLY_MODIFIER_UUID);
                            attr.m_22120_(PULL_MODIFIER_UUID);
                        }
                    } else if (this.pulling instanceof AbstractDrawnEntity) {
                        ((AbstractDrawnEntity)this.pulling).drawn = null;
                    }
                    AstikorCarts.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new UpdateDrawnMessage(-1, this.m_19879_()));
                    this.pullingUUID = null;
                    if (this.f_19797_ > 20) {
                        this.playDetachSound();
                    }
                } else {
                    AttributeInstance attr;
                    if (entityIn instanceof LivingEntity && (Double)this.getConfig().pullSpeed.get() != 0.0 && (attr = ((LivingEntity)entityIn).m_21051_(Attributes.f_22279_)) != null && attr.m_22111_(PULL_MODIFIER_UUID) == null) {
                        attr.m_22118_(new AttributeModifier(PULL_MODIFIER_UUID, "Pull modifier", ((Double)this.getConfig().pullSpeed.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
                    }
                    if (entityIn instanceof PathfinderMob) {
                        PathfinderMob pathfinder = (PathfinderMob)entityIn;
                        pathfinder.m_21573_().m_26573_();
                    }
                    AstikorCarts.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new UpdateDrawnMessage(entityIn.m_19879_(), this.m_19879_()));
                    this.pullingUUID = entityIn.m_20148_();
                    if (this.f_19797_ > 20) {
                        this.playAttachSound();
                    }
                }
                if (entityIn instanceof AbstractDrawnEntity) {
                    ((AbstractDrawnEntity)entityIn).drawn = this;
                }
                this.pulling = entityIn;
                AstikorWorld.get(this.f_19853_).ifPresent(w -> w.addPulling(this));
            }
        } else {
            if (entityIn == null) {
                this.pullingId = -1;
                for (CartWheel wheel : this.wheels) {
                    wheel.clearIncrement();
                }
                if (this.pulling instanceof AbstractDrawnEntity) {
                    ((AbstractDrawnEntity)this.pulling).drawn = null;
                }
            } else {
                this.pullingId = entityIn.m_19879_();
                if (entityIn instanceof AbstractDrawnEntity) {
                    ((AbstractDrawnEntity)entityIn).drawn = this;
                }
            }
            this.pulling = entityIn;
            AstikorWorld.get(this.f_19853_).ifPresent(w -> w.addPulling(this));
        }
    }

    private void playAttachSound() {
        this.m_5496_((SoundEvent)AstikorCarts.SoundEvents.CART_ATTACHED.get(), 0.2f, 1.0f);
    }

    private void playDetachSound() {
        this.m_5496_((SoundEvent)AstikorCarts.SoundEvents.CART_DETACHED.get(), 0.2f, 1.0f);
    }

    private void attemptReattach() {
        Entity entity;
        if (this.f_19853_.f_46443_) {
            Entity entity2;
            if (this.pullingId != -1 && (entity2 = this.f_19853_.m_6815_(this.pullingId)) != null && entity2.m_6084_()) {
                this.setPulling(entity2);
            }
        } else if (this.pullingUUID != null && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.pullingUUID)) != null && entity.m_6084_()) {
            this.setPulling(entity);
        }
    }

    public boolean shouldStopPulledTick() {
        if (!this.m_6084_() || this.getPulling() == null || !this.getPulling().m_6084_() || this.getPulling().m_20159_()) {
            if (this.pulling != null && this.pulling instanceof Player) {
                this.setPulling(null);
            } else {
                this.pulling = null;
            }
            return true;
        }
        if (!this.f_19853_.f_46443_ && this.shouldRemovePulling()) {
            this.setPulling(null);
            return true;
        }
        return false;
    }

    public Vec3 getRelativeTargetVec(float delta) {
        double z;
        double y;
        double x;
        if (delta == 1.0f) {
            x = this.pulling.m_20185_() - this.m_20185_();
            y = this.pulling.m_20186_() - this.m_20186_();
            z = this.pulling.m_20189_() - this.m_20189_();
        } else {
            x = Mth.m_14139_((double)delta, (double)this.pulling.f_19790_, (double)this.pulling.m_20185_()) - Mth.m_14139_((double)delta, (double)this.f_19790_, (double)this.m_20185_());
            y = Mth.m_14139_((double)delta, (double)this.pulling.f_19791_, (double)this.pulling.m_20186_()) - Mth.m_14139_((double)delta, (double)this.f_19791_, (double)this.m_20186_());
            z = Mth.m_14139_((double)delta, (double)this.pulling.f_19792_, (double)this.pulling.m_20189_()) - Mth.m_14139_((double)delta, (double)this.f_19792_, (double)this.m_20189_());
        }
        float yaw = (float)Math.toRadians(this.pulling.m_146908_());
        float nx = -Mth.m_14031_((float)yaw);
        float nz = Mth.m_14089_((float)yaw);
        double r = 0.2;
        return new Vec3(x + (double)nx * 0.2, y, z + (double)nz * 0.2);
    }

    public void handleRotation(Vec3 target) {
        this.m_146922_(AbstractDrawnEntity.getYaw(target));
        this.m_146926_(AbstractDrawnEntity.getPitch(target));
    }

    public static float getYaw(Vec3 vec) {
        return Mth.m_14177_((float)((float)Math.toDegrees(-Mth.m_14136_((double)vec.f_82479_, (double)vec.f_82481_))));
    }

    public static float getPitch(Vec3 vec) {
        return Mth.m_14177_((float)((float)Math.toDegrees(-Mth.m_14136_((double)vec.f_82480_, (double)Mth.m_14116_((float)((float)(vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_)))))));
    }

    public double getWheelRotation(int wheel) {
        return this.wheels.get(wheel).getRotation();
    }

    public double getWheelRotationIncrement(int wheel) {
        return this.wheels.get(wheel).getRotationIncrement();
    }

    public abstract Item getCartItem();

    protected boolean canBePulledBy(Entity entityIn) {
        if (this.f_19853_.f_46443_) {
            return true;
        }
        if (entityIn == null) {
            return true;
        }
        return (this.pulling == null || !this.pulling.m_6084_()) && !this.m_20363_(entityIn) && this.canPull(entityIn);
    }

    private boolean canPull(Entity entity) {
        if (entity instanceof Saddleable && !((Saddleable)entity).m_6741_()) {
            return false;
        }
        if (entity instanceof TamableAnimal && !((TamableAnimal)entity).m_21824_()) {
            return false;
        }
        ArrayList allowed = (ArrayList)this.getConfig().pullAnimals.get();
        if (allowed.isEmpty()) {
            return entity instanceof Player || entity instanceof Saddleable && !(entity instanceof ItemSteerable);
        }
        return allowed.contains(EntityType.m_20613_((EntityType)entity.m_6095_()).toString());
    }

    protected abstract AstikorCartsConfig.CartConfig getConfig();

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            boolean flag;
            if (source == DamageSource.f_19314_) {
                return false;
            }
            if (source instanceof IndirectEntityDamageSource && source.m_7639_() != null && this.m_20363_(source.m_7639_())) {
                return false;
            }
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            boolean bl = flag = source.m_7639_() instanceof Player && ((Player)source.m_7639_()).m_150110_().f_35937_;
            if (flag || this.getDamageTaken() > 40.0f) {
                this.onDestroyed(source, flag);
                this.setPulling(null);
                this.m_146870_();
            }
            return true;
        }
        return false;
    }

    protected InteractionResult useBanner(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(ItemTags.f_13191_)) {
            ItemStack oldBanner = this.getBanner();
            if (!this.f_19853_.f_46443_) {
                ItemStack banner = stack.m_41620_(1);
                if (!oldBanner.m_41619_()) {
                    if (stack.m_41619_()) {
                        player.m_21008_(hand, oldBanner);
                    } else if (!player.m_150109_().m_36054_(oldBanner)) {
                        player.m_36176_(oldBanner, false);
                    }
                }
                this.m_5496_(SoundEvents.f_12635_, 1.0f, 0.8f);
                this.setBanner(banner);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void onDestroyed(DamageSource source, boolean byCreativePlayer) {
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            if (!byCreativePlayer) {
                this.m_19998_((ItemLike)this.getCartItem());
                this.m_19983_(this.getBanner());
            }
            this.onDestroyedAndDoDrops(source);
        }
    }

    public void onDestroyedAndDoDrops(DamageSource source) {
    }

    private void tickLerp() {
        if (this.lerpSteps > 0) {
            double dx = (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double dy = (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double dz = (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            this.m_146922_((float)((double)this.m_146908_() + Mth.m_14175_((double)(this.lerpYaw - (double)this.m_146908_())) / (double)this.lerpSteps));
            this.m_146926_((float)((double)this.m_146909_() + (this.lerpPitch - (double)this.m_146909_()) / (double)this.lerpSteps));
            --this.lerpSteps;
            this.f_19861_ = true;
            this.m_6478_(MoverType.SELF, new Vec3(dx, dy, dz));
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = posRotationIncrements;
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (this.m_6109_() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.m_7678_(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYaw, (float)this.lerpPitch);
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        List passengers = this.m_20197_();
        if (passengers.isEmpty()) {
            return null;
        }
        Entity first = (Entity)passengers.get(0);
        if (first instanceof Animal || !(first instanceof LivingEntity)) {
            return null;
        }
        return (LivingEntity)first;
    }

    public boolean m_6109_() {
        return false;
    }

    public Vec3 m_7688_(LivingEntity rider) {
        float[] fArray;
        if (rider.m_5737_() == HumanoidArm.RIGHT) {
            float[] fArray2 = new float[2];
            fArray2[0] = 90.0f;
            fArray = fArray2;
            fArray2[1] = -90.0f;
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = -90.0f;
            fArray = fArray3;
            fArray3[1] = 90.0f;
        }
        for (float angle : fArray) {
            Vec3 pos = this.dismount(AbstractDrawnEntity.m_19903_((double)this.m_20205_(), (double)rider.m_20205_(), (float)(this.m_146908_() + angle)), rider);
            if (pos == null) continue;
            return pos;
        }
        return this.m_20182_();
    }

    private Vec3 dismount(Vec3 dir, LivingEntity rider) {
        double x = this.m_20185_() + dir.f_82479_;
        double y = this.m_20191_().f_82289_;
        double z = this.m_20189_() + dir.f_82481_;
        double limit = this.m_20191_().f_82292_ + 0.75;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : rider.m_7431_()) {
            blockPos.m_122169_(x, y, z);
            while ((double)blockPos.m_123342_() < limit) {
                double ground = this.f_19853_.m_45573_((BlockPos)blockPos);
                if ((double)blockPos.m_123342_() + ground > limit) continue block0;
                if (DismountHelper.m_38439_((double)ground)) {
                    Vec3 pos = new Vec3(x, (double)blockPos.m_123342_() + ground, z);
                    if (DismountHelper.m_38456_((CollisionGetter)this.f_19853_, (LivingEntity)rider, (AABB)rider.m_21270_(pose).m_82383_(pos))) {
                        rider.m_20124_(pose);
                        return pos;
                    }
                }
                blockPos.m_122173_(Direction.UP);
            }
        }
        return null;
    }

    public void setDamageTaken(float damageTaken) {
        this.f_19804_.m_135381_(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE_TAKEN)).floatValue();
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.f_19804_.m_135381_(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.f_19804_.m_135370_(TIME_SINCE_HIT);
    }

    public void setForwardDirection(int forwardDirection) {
        this.f_19804_.m_135381_(FORWARD_DIRECTION, (Object)forwardDirection);
    }

    public int getForwardDirection() {
        return (Integer)this.f_19804_.m_135370_(FORWARD_DIRECTION);
    }

    public void setBanner(ItemStack banner) {
        this.f_19804_.m_135381_(BANNER, (Object)banner);
    }

    public ItemStack getBanner() {
        return (ItemStack)this.f_19804_.m_135370_(BANNER);
    }

    public List<Pair<Holder<BannerPattern>, DyeColor>> getBannerPattern() {
        ItemStack banner = this.getBanner();
        Item item = banner.m_41720_();
        if (item instanceof BannerItem) {
            BannerItem item2 = (BannerItem)item;
            return BannerBlockEntity.m_58484_((DyeColor)item2.m_40545_(), (ListTag)BannerBlockEntity.m_58487_((ItemStack)banner));
        }
        return List.of();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)this.getCartItem());
    }

    public boolean m_6087_() {
        return true;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.pulling != null ? this.pulling.m_19879_() : -1);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.pullingId = additionalData.readInt();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TIME_SINCE_HIT, (Object)0);
        this.f_19804_.m_135372_(FORWARD_DIRECTION, (Object)1);
        this.f_19804_.m_135372_(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BANNER, (Object)ItemStack.f_41583_);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("PullingUUID")) {
            this.pullingUUID = compound.m_128342_("PullingUUID");
        }
        if (compound.m_128441_("BannerItem")) {
            this.setBanner(ItemStack.m_41712_((CompoundTag)compound.m_128469_("BannerItem")));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        ItemStack banner;
        if (this.pulling != null) {
            compound.m_128362_("PullingUUID", this.pullingUUID);
        }
        if (!(banner = this.getBanner()).m_41619_()) {
            compound.m_128365_("BannerItem", (Tag)banner.m_41739_(new CompoundTag()));
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public RenderInfo getInfo(float delta) {
        return new RenderInfo(delta);
    }

    public void toggleSlow() {
        Entity pulling = this.pulling;
        if (!(pulling instanceof LivingEntity)) {
            return;
        }
        AttributeInstance speed = ((LivingEntity)pulling).m_21051_(Attributes.f_22279_);
        if (speed == null) {
            return;
        }
        AttributeModifier modifier = speed.m_22111_(PULL_SLOWLY_MODIFIER_UUID);
        if (modifier == null) {
            speed.m_22118_(new AttributeModifier(PULL_SLOWLY_MODIFIER_UUID, "Pull slowly modifier", ((Double)this.getConfig().slowSpeed.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        } else {
            speed.m_22130_(modifier);
        }
    }

    public class RenderInfo {
        final float delta;
        Vec3 target;
        float yaw = Float.NaN;
        float pitch = Float.NaN;

        public RenderInfo(float delta) {
            this.delta = delta;
        }

        public Vec3 getTarget() {
            if (this.target == null) {
                this.target = AbstractDrawnEntity.this.pulling == null ? AbstractDrawnEntity.this.m_20252_(this.delta) : AbstractDrawnEntity.this.getRelativeTargetVec(this.delta);
            }
            return this.target;
        }

        public float getYaw() {
            if (Float.isNaN(this.yaw)) {
                this.yaw = AbstractDrawnEntity.this.pulling == null ? Mth.m_14179_((float)this.delta, (float)AbstractDrawnEntity.this.f_19859_, (float)AbstractDrawnEntity.this.m_146908_()) : AbstractDrawnEntity.getYaw(this.getTarget());
            }
            return this.yaw;
        }

        public float getPitch() {
            if (Float.isNaN(this.pitch)) {
                this.pitch = AbstractDrawnEntity.this.pulling == null ? Mth.m_14179_((float)this.delta, (float)AbstractDrawnEntity.this.f_19860_, (float)AbstractDrawnEntity.this.m_146909_()) : AbstractDrawnEntity.getPitch(this.target);
            }
            return this.pitch;
        }
    }
}

