/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.entity;

import de.mennomax.astikorcarts.entity.AbstractDrawnEntity;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class AbstractDrawnInventoryEntity
extends AbstractDrawnEntity {
    private static final Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IItemHandler>(){});
    public ItemStackHandler inventory = this.initInventory();
    private LazyOptional<ItemStackHandler> itemHandler = LazyOptional.of(() -> this.inventory);

    public AbstractDrawnInventoryEntity(EntityType<? extends Entity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected abstract ItemStackHandler initInventory();

    public SlotAccess m_141942_(final int slot) {
        final ItemStackHandler inventory = this.inventory;
        if (slot >= 0 && slot < inventory.getSlots()) {
            return new SlotAccess(){

                public ItemStack m_142196_() {
                    return inventory.getStackInSlot(slot);
                }

                public boolean m_142104_(ItemStack stack) {
                    inventory.setStackInSlot(slot, stack);
                    return true;
                }
            };
        }
        return super.m_141942_(slot);
    }

    @Override
    public void onDestroyedAndDoDrops(DamageSource source) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.inventory.getStackInSlot(i));
            itementity.m_32060_();
            this.f_19853_.m_7967_((Entity)itementity);
        }
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Items"));
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("Items", (Tag)this.inventory.serializeNBT());
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
            this.itemHandler = null;
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }
}

