/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.mennomax.astikorcarts.client.renderer.entity.DrawnRenderer;
import de.mennomax.astikorcarts.client.renderer.entity.model.AnimalCartModel;
import de.mennomax.astikorcarts.entity.AnimalCartEntity;
import de.mennomax.astikorcarts.util.Mat4f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.model.HorseModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class AnimalCartRenderer
extends DrawnRenderer<AnimalCartEntity, AnimalCartModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("astikorcarts", "textures/entity/animal_cart.png");

    public AnimalCartRenderer(EntityRendererManager renderManager) {
        super(renderManager, new AnimalCartModel());
        this.field_76989_e = 1.0f;
    }

    @Override
    public void render(AnimalCartEntity entity, float yaw, float delta, MatrixStack stack, IRenderTypeBuffer source, int packedLight) {
        super.render(entity, yaw, delta, stack, source, packedLight);
    }

    private void horseTransform(Mat4f m, HorseEntity entity, float delta) {
        HorseModel horseModel = (HorseModel)((HorseRenderer)this.field_76990_c.func_78713_a((Entity)entity)).func_217764_d();
        float strength = 0.0f;
        float swing = 0.0f;
        if (!entity.func_184218_aH() && entity.func_70089_S()) {
            strength = MathHelper.func_219799_g((float)delta, (float)entity.field_184618_aE, (float)entity.field_70721_aZ);
            swing = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - delta);
            if (entity.func_70631_g_()) {
                swing *= 3.0f;
            }
            if (strength > 1.0f) {
                strength = 1.0f;
            }
        }
        horseModel.func_212843_a_((AbstractHorseEntity)entity, swing, strength, delta);
        ModelRenderer head = (ModelRenderer)ObfuscationReflectionHelper.getPrivateValue(HorseModel.class, (Object)horseModel, (String)"field_217128_b");
        Mat4f tmp = new Mat4f();
        m.mul(tmp.makeScale(-1.0f, -1.0f, 1.0f));
        m.mul(tmp.makeScale(1.1f, 1.1f, 1.1f));
        m.mul(tmp.makeTranslation(0.0f, -1.501f, 0.0f));
        this.transform(m, head);
    }

    private void transform(Mat4f m, ModelRenderer bone) {
        Mat4f tmp = new Mat4f();
        m.mul(tmp.makeTranslation(bone.field_78800_c / 16.0f, bone.field_78797_d / 16.0f, bone.field_78798_e / 16.0f));
        if (bone.field_78808_h != 0.0f) {
            m.mul(tmp.makeRotation(bone.field_78808_h, 0.0f, 0.0f, 1.0f));
        }
        if (bone.field_78796_g != 0.0f) {
            m.mul(tmp.makeRotation(bone.field_78796_g, 0.0f, 1.0f, 0.0f));
        }
        if (bone.field_78795_f != 0.0f) {
            m.mul(tmp.makeRotation(bone.field_78795_f, 1.0f, 0.0f, 0.0f));
        }
    }

    private Mat4f modelView(Entity entity, float delta) {
        float yaw;
        float prevYaw;
        Mat4f m = new Mat4f();
        m.makeTranslation((float)MathHelper.func_219803_d((double)delta, (double)entity.field_70142_S, (double)entity.func_226277_ct_()), (float)MathHelper.func_219803_d((double)delta, (double)entity.field_70137_T, (double)entity.func_226278_cu_()), (float)MathHelper.func_219803_d((double)delta, (double)entity.field_70136_U, (double)entity.func_226281_cx_()));
        Mat4f r = new Mat4f();
        if (entity instanceof LivingEntity) {
            prevYaw = ((LivingEntity)entity).field_70760_ar;
            yaw = ((LivingEntity)entity).field_70761_aq;
        } else {
            prevYaw = entity.field_70126_B;
            yaw = entity.field_70177_z;
        }
        r.makeRotation((float)Math.toRadians(180.0f - MathHelper.func_219805_h((float)delta, (float)prevYaw, (float)yaw)), 0.0f, 1.0f, 0.0f);
        m.mul(r);
        return m;
    }

    private void renderCurve(double x0, double y0, double z0, double x1, double y1, double z1) {
        if (y0 > y1) {
            this.renderLead(x1, y1, z1, x0 - x1, y0 - y1, z0 - z1, 1);
        } else {
            this.renderLead(x0, y0, z0, x1 - x0, y1 - y0, z1 - z0, 0);
        }
    }

    private void renderLead(double x, double y, double z, double dx, double dy, double dz, int offset) {
        float t;
        float b;
        float g;
        float r;
        int i;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        RenderSystem.disableTexture();
        RenderSystem.disableLighting();
        RenderSystem.disableCull();
        int n = 24;
        double w = 0.05;
        double m = Math.sqrt(dx * dx + dz * dz);
        double nx = dx / m;
        double nz = dz / m;
        float r0 = 0.38039216f;
        float g0 = 0.22745098f;
        float b0 = 0.11372549f;
        buf.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= 24; ++i) {
            r = 0.38039216f;
            g = 0.22745098f;
            b = 0.11372549f;
            if ((i + offset) % 2 == 0) {
                r *= 0.7f;
                g *= 0.7f;
                b *= 0.7f;
            }
            t = (float)i / 24.0f;
            buf.func_225582_a_(x + dx * (double)t, y + dy * (double)(t * t + t) * 0.5 - 0.05, z + dz * (double)t).func_227885_a_(r, g, b, 1.0f).func_181675_d();
            buf.func_225582_a_(x + dx * (double)t, y + dy * (double)(t * t + t) * 0.5 + 0.05, z + dz * (double)t).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        }
        tes.func_78381_a();
        buf.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        for (i = 0; i <= 24; ++i) {
            r = 0.38039216f;
            g = 0.22745098f;
            b = 0.11372549f;
            if ((i + offset) % 2 == 0) {
                r *= 0.7f;
                g *= 0.7f;
                b *= 0.7f;
            }
            t = (float)i / 24.0f;
            buf.func_225582_a_(x + dx * (double)t + 0.05 * -nz, y + dy * (double)(t * t + t) * 0.5, z + dz * (double)t + 0.05 * nx).func_227885_a_(r, g, b, 1.0f).func_181675_d();
            buf.func_225582_a_(x + dx * (double)t + 0.05 * nz, y + dy * (double)(t * t + t) * 0.5, z + dz * (double)t + 0.05 * -nx).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        }
        tes.func_78381_a();
        RenderSystem.enableLighting();
        RenderSystem.enableTexture();
        RenderSystem.enableCull();
    }

    public ResourceLocation getEntityTexture(AnimalCartEntity entity) {
        return TEXTURE;
    }
}

