/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.entity;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonParseException;
import de.mennomax.astikorcarts.AstikorCarts;
import de.mennomax.astikorcarts.client.sound.CartingJukeboxSound;
import de.mennomax.astikorcarts.config.AstikorCartsConfig;
import de.mennomax.astikorcarts.entity.AbstractDrawnInventoryEntity;
import de.mennomax.astikorcarts.inventory.container.SupplyCartContainer;
import de.mennomax.astikorcarts.util.CartItemStackHandler;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SEntityMetadataPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public final class SupplyCartEntity
extends AbstractDrawnInventoryEntity {
    private static final ImmutableList<DataParameter<ItemStack>> CARGO = ImmutableList.of((Object)EntityDataManager.func_187226_a(SupplyCartEntity.class, (IDataSerializer)DataSerializers.field_187196_f), (Object)EntityDataManager.func_187226_a(SupplyCartEntity.class, (IDataSerializer)DataSerializers.field_187196_f), (Object)EntityDataManager.func_187226_a(SupplyCartEntity.class, (IDataSerializer)DataSerializers.field_187196_f), (Object)EntityDataManager.func_187226_a(SupplyCartEntity.class, (IDataSerializer)DataSerializers.field_187196_f));

    public SupplyCartEntity(EntityType<? extends Entity> type, World world) {
        super(type, world);
    }

    @Override
    protected AstikorCartsConfig.CartConfig getConfig() {
        return AstikorCartsConfig.COMMON.supplyCart;
    }

    @Override
    protected ItemStackHandler initInventory() {
        return new CartItemStackHandler<SupplyCartEntity>(54, this){

            protected void onLoad() {
                super.onLoad();
                this.onContentsChanged(0);
            }

            protected void onContentsChanged(int slot) {
                Object2IntLinkedOpenHashMap totals = new Object2IntLinkedOpenHashMap();
                Object2ObjectOpenHashMap stacks = new Object2ObjectOpenHashMap();
                for (int i = 0; i < this.getSlots(); ++i) {
                    ItemStack stack = this.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    totals.mergeInt((Object)stack.func_77973_b(), 1, Integer::sum);
                    stacks.putIfAbsent((Object)stack.func_77973_b(), (Object)stack);
                }
                Iterator topTotals = totals.object2IntEntrySet().stream().sorted(Comparator.comparingInt(e -> e.getKey() instanceof BlockItem ? 0 : 1).thenComparingInt(e -> -e.getIntValue())).limit(CARGO.size()).iterator();
                Object[] items = new ItemStack[CARGO.size()];
                Arrays.fill(items, ItemStack.field_190927_a);
                int forth = this.getSlots() / CARGO.size();
                int pos = 0;
                while (topTotals.hasNext() && pos < CARGO.size()) {
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)topTotals.next();
                    int count = Math.max(1, (entry.getIntValue() + forth / 2) / forth);
                    for (int n = 1; n <= count && pos < CARGO.size(); ++n) {
                        ItemStack stack = ((ItemStack)stacks.getOrDefault(entry.getKey(), (Object)ItemStack.field_190927_a)).func_77946_l();
                        stack.func_190920_e(Math.min(stack.func_77976_d(), entry.getIntValue() / n));
                        items[pos++] = stack;
                    }
                }
                for (int i = 0; i < CARGO.size(); ++i) {
                    ((SupplyCartEntity)this.cart).func_184212_Q().func_187227_b((DataParameter)CARGO.get(i), items[i]);
                }
            }
        };
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (player.func_226563_dT_()) {
            this.openContainer(player);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        ItemStack held = player.func_184586_b(hand);
        if (this.hasJukebox()) {
            if (this.field_70170_p.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            if (held.func_77973_b() instanceof MusicDiscItem && this.insertDisc(player, held) || this.ejectDisc(player)) {
                return ActionResultType.CONSUME;
            }
            return ActionResultType.FAIL;
        }
        if (this.func_184207_aI()) {
            return ActionResultType.PASS;
        }
        if (!this.field_70170_p.field_72995_K) {
            return player.func_184220_m((Entity)this) ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }

    private boolean insertDisc(PlayerEntity player, ItemStack held) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (!DiscTag.insert(stack, held)) continue;
            this.inventory.setStackInSlot(i, stack);
            ((ServerWorld)this.field_70170_p).func_72863_F().func_217218_b((Entity)this, (IPacket)new SEntityMetadataPacket(this.func_145782_y(), this.field_70180_af, false));
            this.field_70170_p.func_72960_a((Entity)this, (byte)5);
            if (!player.field_71075_bZ.field_75098_d) {
                held.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    private boolean ejectDisc(PlayerEntity player) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            DiscTag record = DiscTag.get(stack);
            if (!record.eject(player)) continue;
            this.inventory.setStackInSlot(i, stack);
            return true;
        }
        return false;
    }

    public boolean hasJukebox() {
        for (DataParameter slot : CARGO) {
            ItemStack cargo = (ItemStack)this.field_70180_af.func_187225_a(slot);
            if (cargo.func_77973_b() != Items.field_221778_cy) continue;
            return true;
        }
        return false;
    }

    public ItemStack getDisc() {
        for (DataParameter slot : CARGO) {
            ItemStack disc = DiscTag.get((ItemStack)((ItemStack)this.field_70180_af.func_187225_a((DataParameter)slot))).disc;
            if (disc.func_190926_b()) continue;
            return disc;
        }
        return ItemStack.field_190927_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 5) {
            for (DataParameter slot : CARGO) {
                ItemStack disc = DiscTag.get((ItemStack)((ItemStack)this.field_70180_af.func_187225_a((DataParameter)slot))).disc;
                if (disc.func_190926_b()) continue;
                CartingJukeboxSound.play(this, disc);
                break;
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public double func_70042_X() {
        return 0.6875;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            Vector3d forward = this.func_70040_Z();
            Vector3d origin = new Vector3d(0.0, this.func_70042_X(), 0.0625);
            Vector3d pos = origin.func_178787_e(forward.func_186678_a(-0.68));
            passenger.func_70107_b(this.func_226277_ct_() + pos.field_72450_a, this.func_226278_cu_() + pos.field_72448_b - 0.1 + passenger.func_70033_W(), this.func_226281_cx_() + pos.field_72449_c);
            passenger.func_181013_g(this.field_70177_z + 180.0f);
            float f2 = MathHelper.func_76142_g((float)(passenger.field_70177_z - this.field_70177_z + 180.0f));
            float f1 = MathHelper.func_76131_a((float)f2, (float)-105.0f, (float)105.0f);
            passenger.field_70126_B += f1 - f2;
            passenger.field_70177_z += f1 - f2;
            passenger.func_70034_d(passenger.field_70177_z);
        }
    }

    public NonNullList<ItemStack> getCargo() {
        NonNullList cargo = NonNullList.func_191197_a((int)CARGO.size(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < CARGO.size(); ++i) {
            cargo.set(i, this.field_70180_af.func_187225_a((DataParameter)CARGO.get(i)));
        }
        return cargo;
    }

    @Override
    public Item getCartItem() {
        return AstikorCarts.Items.SUPPLY_CART.get();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        for (DataParameter parameter : CARGO) {
            this.field_70180_af.func_187214_a(parameter, (Object)ItemStack.field_190927_a);
        }
    }

    public void openContainer(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K) {
            player.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((id, inv, plyr) -> new SupplyCartContainer(id, inv, (AbstractDrawnInventoryEntity)this), this.func_145748_c_()));
        }
    }

    static class DiscTag {
        static final DiscTag EMPTY = new DiscTag(ItemStack.field_190927_a, new CompoundNBT(), new CompoundNBT(), ItemStack.field_190927_a);
        final ItemStack stack;
        final CompoundNBT nbt;
        final CompoundNBT tag;
        final ItemStack disc;

        DiscTag(ItemStack stack, CompoundNBT nbt, CompoundNBT tag, ItemStack disc) {
            this.stack = stack;
            this.nbt = nbt;
            this.tag = tag;
            this.disc = disc;
        }

        boolean isEmpty() {
            return this.stack.func_190926_b();
        }

        boolean eject(PlayerEntity player) {
            CompoundNBT display;
            if (this.isEmpty()) {
                return false;
            }
            this.tag.func_82580_o("RecordItem");
            if (this.tag.isEmpty()) {
                this.nbt.func_82580_o("BlockEntityTag");
            }
            if (this.nbt.func_150297_b("display", 10) && (display = this.nbt.func_74775_l("display")).func_150297_b("Lore", 9)) {
                ListNBT lore = display.func_150295_c("Lore", 8);
                String descKey = this.disc.func_77977_a() + ".desc";
                int i = lore.size();
                while (i-- > 0) {
                    IFormattableTextComponent component;
                    String s = lore.func_150307_f(i);
                    try {
                        component = ITextComponent.Serializer.func_240643_a_((String)s);
                    }
                    catch (JsonParseException ignored) {
                        continue;
                    }
                    if (!(component instanceof TranslationTextComponent) || !descKey.equals(((TranslationTextComponent)component).func_150268_i())) continue;
                    lore.remove(i);
                }
            }
            if (this.nbt.isEmpty()) {
                this.stack.func_77982_d(null);
            }
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)this.disc, (int)player.field_71071_by.field_70461_c);
            return true;
        }

        static DiscTag get(ItemStack stack) {
            if (stack.func_77973_b() != Items.field_221778_cy) {
                return EMPTY;
            }
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt == null || !nbt.func_150297_b("BlockEntityTag", 10)) {
                return EMPTY;
            }
            CompoundNBT tag = nbt.func_74775_l("BlockEntityTag");
            if (!tag.func_150297_b("RecordItem", 10)) {
                return EMPTY;
            }
            return new DiscTag(stack, nbt, tag, ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("RecordItem")));
        }

        static boolean insert(ItemStack stack, ItemStack disc) {
            if (stack.func_77973_b() != Items.field_221778_cy) {
                return false;
            }
            CompoundNBT tag = stack.func_190925_c("BlockEntityTag");
            if (tag.func_150297_b("RecordItem", 10)) {
                return false;
            }
            tag.func_218657_a("RecordItem", (INBT)disc.func_77955_b(new CompoundNBT()));
            CompoundNBT display = stack.func_190925_c("display");
            ListNBT lore = display.func_150295_c("Lore", 8);
            lore.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)new TranslationTextComponent(disc.func_77977_a() + ".desc"))));
            display.func_218657_a("Lore", (INBT)lore);
            return true;
        }
    }
}

