/*
 * Decompiled with CFR 0.152.
 */
package baguchan.bettergolem.entity.goal;

import baguchan.bettergolem.api.ISwingAttack;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;

public class SwingAttackGoal<T extends MobEntity>
extends Goal {
    private static final Predicate<Entity> iMobTarget = p_213685_0_ -> p_213685_0_.func_70089_S() && !(p_213685_0_ instanceof IronGolemEntity);
    private final T mobEntity;
    private int attackingTimer;
    private int cooldownTimer;

    public SwingAttackGoal(T mobEntity) {
        this.mobEntity = mobEntity;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity livingEntity;
        if (this.cooldownTimer > 0) {
            --this.cooldownTimer;
        }
        if ((livingEntity = this.mobEntity.func_70638_az()) != null && livingEntity.func_70089_S() && this.cooldownTimer <= 0) {
            this.cooldownTimer = 40 + this.mobEntity.func_70681_au().nextInt(100);
            return this.mobEntity.func_70068_e((Entity)livingEntity) < 32.0 && livingEntity.func_233570_aj_() && this.mobEntity.func_70681_au().nextInt(3) == 0;
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.attackingTimer < 40;
    }

    public void func_75249_e() {
        super.func_75249_e();
        ((ISwingAttack)this.mobEntity).setSwingAttack(true);
        this.attackingTimer = 0;
    }

    public void func_75251_c() {
        super.func_75251_c();
        ((ISwingAttack)this.mobEntity).setSwingAttack(false);
    }

    public void func_75246_d() {
        super.func_75246_d();
        ++this.attackingTimer;
        if (this.attackingTimer == 6) {
            this.groundAttack();
        }
    }

    private void groundAttack() {
        LivingEntity livingEntity = this.mobEntity.func_70638_az();
        if (this.mobEntity.func_70089_S()) {
            this.mobEntity.func_184185_a(SoundEvents.field_187539_bB, 1.4f, 1.4f);
            this.mobEntity.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
            for (Entity entity : ((MobEntity)this.mobEntity).field_70170_p.func_175647_a(LivingEntity.class, this.mobEntity.func_174813_aQ().func_186662_g(8.0), iMobTarget)) {
                if (!(entity instanceof IMob) && (livingEntity == null || livingEntity != entity) || !entity.func_233570_aj_()) continue;
                boolean flag = entity.func_70097_a(DamageSource.func_76358_a(this.mobEntity), (float)this.mobEntity.func_233637_b_(Attributes.field_233823_f_) * 0.75f);
                if (flag) {
                    entity.func_213317_d(entity.func_213322_ci().func_72441_c(0.0, (double)0.4f, 0.0));
                    this.mobEntity.func_174815_a(this.mobEntity, entity);
                }
                this.launch(entity);
            }
        }
    }

    private void launch(Entity launchEntity) {
        double d0 = launchEntity.func_226277_ct_() - this.mobEntity.func_226277_ct_();
        double d1 = launchEntity.func_226281_cx_() - this.mobEntity.func_226281_cx_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        launchEntity.func_70024_g(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
    }
}

