/*
 * Decompiled with CFR 0.152.
 */
package baguchan.bettergolem.mixin;

import baguchan.bettergolem.api.ISwingAttack;
import baguchan.bettergolem.entity.goal.SwingAttackGoal;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={IronGolemEntity.class})
public abstract class MixinIronGolemEntity
extends GolemEntity
implements ISwingAttack {
    private static final DataParameter<Boolean> SWING_ATTACK = EntityDataManager.func_187226_a(IronGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private float swingAttackAnimationProgress;
    private float lastSwingAttackAnimationProgress;

    public MixinIronGolemEntity(EntityType<? extends GolemEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"registerData"}, at={@At(value="TAIL")})
    protected void registerData(CallbackInfo callbackInfo) {
        this.field_70180_af.func_187214_a(SWING_ATTACK, (Object)false);
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    protected void registerGoals(CallbackInfo callbackInfo) {
        this.field_70714_bg.func_75776_a(0, new SwingAttackGoal<MixinIronGolemEntity>(this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70089_S()) {
            this.lastSwingAttackAnimationProgress = this.swingAttackAnimationProgress;
            this.swingAttackAnimationProgress = this.isSwingAttack() ? MathHelper.func_76131_a((float)(this.swingAttackAnimationProgress + 0.2f), (float)0.0f, (float)1.0f) : MathHelper.func_76131_a((float)(this.swingAttackAnimationProgress - 0.05f), (float)0.0f, (float)1.0f);
        }
    }

    @Override
    public void setSwingAttack(boolean attack) {
        this.field_70180_af.func_187227_b(SWING_ATTACK, (Object)attack);
    }

    @Override
    public boolean isSwingAttack() {
        return (Boolean)this.field_70180_af.func_187225_a(SWING_ATTACK);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getSwingAttackAnimationScale(float ageInTicks) {
        return this.lastSwingAttackAnimationProgress + (this.swingAttackAnimationProgress - this.lastSwingAttackAnimationProgress) * ageInTicks;
    }
}

