/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.bgcore.common.world.biome;

import com.blackgear.bgcore.common.world.biome.BiomeEffects;
import com.blackgear.bgcore.common.world.biome.ParticleBiomeEffect;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;

public abstract class AbstractBiome
extends Biome {
    private final Supplier<ConfiguredSurfaceBuilder<?>> surfaceBuilderSupplier;
    private final BiomeEffects biomeEffects;

    public AbstractBiome(Biome.Builder biomeBuilder, Supplier<ConfiguredSurfaceBuilder<?>> surfaceBuilderSupplier) {
        this(biomeBuilder, surfaceBuilderSupplier, new EffectBuilder().getEffects(new BiomeEffects.Builder().build()));
    }

    public AbstractBiome(Biome.Builder biomeBuilder, Supplier<ConfiguredSurfaceBuilder<?>> surfaceBuilderSupplier, EffectBuilder effectBuilder) {
        super(biomeBuilder);
        this.surfaceBuilderSupplier = surfaceBuilderSupplier;
        this.biomeEffects = effectBuilder.biomeEffects;
    }

    public void func_206854_a(Random random, IChunk chunkIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed) {
        this.surfaceBuilderSupplier.get().func_215451_a(seed);
        this.surfaceBuilderSupplier.get().func_215450_a(random, chunkIn, (Biome)this, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed);
    }

    public ConfiguredSurfaceBuilder<?> func_205401_q() {
        return this.surfaceBuilderSupplier.get();
    }

    public ISurfaceBuilderConfig func_203944_q() {
        return this.surfaceBuilderSupplier.get().func_215452_a();
    }

    public BiomeEffects getBiomeEffects() {
        return this.biomeEffects;
    }

    public Optional<ParticleBiomeEffect> getParticles() {
        return this.biomeEffects.getParticles();
    }

    public static class EffectBuilder {
        private BiomeEffects biomeEffects;

        public EffectBuilder getEffects(BiomeEffects effects) {
            this.biomeEffects = effects;
            return this;
        }
    }
}

