/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.bgcore.core;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RegistryHelper {
    private final String modId;
    private final DeferredRegister<Item> itemDeferredRegister;
    private final DeferredRegister<Block> blockDeferredRegister;
    private final DeferredRegister<TileEntityType<?>> tileEntityTypeDeferredRegister;
    private final DeferredRegister<EntityType<?>> entityTypeDeferredRegister;
    private final DeferredRegister<SoundEvent> soundEventDeferredRegister;
    private final DeferredRegister<Biome> biomeDeferredRegister;
    private final DeferredRegister<Feature<?>> featureDeferredRegister;
    private final DeferredRegister<SurfaceBuilder<?>> surfaceBuilderDeferredRegister;
    private final DeferredRegister<WorldCarver<?>> worldCarverDeferredRegister;
    private final DeferredRegister<ParticleType<?>> particleTypeDeferredRegister;
    private final DeferredRegister<Item> vanillaItemDeferredRegister;
    private final DeferredRegister<Block> vanillaBlockDeferredRegister;

    public RegistryHelper(String modId) {
        this.modId = modId;
        this.itemDeferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modId);
        this.blockDeferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)modId);
        this.tileEntityTypeDeferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)modId);
        this.entityTypeDeferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)modId);
        this.soundEventDeferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)modId);
        this.biomeDeferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)modId);
        this.featureDeferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)modId);
        this.surfaceBuilderDeferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SURFACE_BUILDERS, (String)modId);
        this.worldCarverDeferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.WORLD_CARVERS, (String)modId);
        this.particleTypeDeferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)modId);
        this.vanillaItemDeferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"minecraft");
        this.vanillaBlockDeferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"minecraft");
    }

    public String getModId() {
        return this.modId;
    }

    public DeferredRegister<Item> getItemDeferredRegister() {
        return this.itemDeferredRegister;
    }

    public DeferredRegister<Block> getBlockDeferredRegister() {
        return this.blockDeferredRegister;
    }

    public DeferredRegister<TileEntityType<?>> getTileEntityTypeDeferredRegister() {
        return this.tileEntityTypeDeferredRegister;
    }

    public DeferredRegister<EntityType<?>> getEntityTypeDeferredRegister() {
        return this.entityTypeDeferredRegister;
    }

    public DeferredRegister<SoundEvent> getSoundEventDeferredRegister() {
        return this.soundEventDeferredRegister;
    }

    public DeferredRegister<Biome> getBiomeDeferredRegister() {
        return this.biomeDeferredRegister;
    }

    public DeferredRegister<Feature<?>> getFeatureDeferredRegister() {
        return this.featureDeferredRegister;
    }

    public DeferredRegister<SurfaceBuilder<?>> getSurfaceBuilderDeferredRegister() {
        return this.surfaceBuilderDeferredRegister;
    }

    public DeferredRegister<WorldCarver<?>> getWorldCarverDeferredRegister() {
        return this.worldCarverDeferredRegister;
    }

    public DeferredRegister<ParticleType<?>> getParticleTypeDeferredRegister() {
        return this.particleTypeDeferredRegister;
    }

    public DeferredRegister<Item> getVanillaItemDeferredRegister() {
        return this.vanillaItemDeferredRegister;
    }

    public DeferredRegister<Block> getVanillaBlockDeferredRegister() {
        return this.vanillaBlockDeferredRegister;
    }

    public ResourceLocation getResourceLocation(String key) {
        return new ResourceLocation(this.modId, key);
    }

    public <I extends Item> RegistryObject<I> registerItem(String key, Supplier<? extends I> itemSupplier) {
        RegistryObject item = this.itemDeferredRegister.register(key, itemSupplier);
        return item;
    }

    public RegistryObject<Item> registerBasicItem(String key, ItemGroup group) {
        RegistryObject item = this.itemDeferredRegister.register(key, () -> new Item(new Item.Properties().func_200916_a(group)));
        return item;
    }

    public <B extends Block> RegistryObject<B> registerBlock(String key, Supplier<? extends B> blockSupplier, ItemGroup group) {
        RegistryObject block = this.blockDeferredRegister.register(key, blockSupplier);
        this.itemDeferredRegister.register(key, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group)));
        return block;
    }

    public <B extends Block> RegistryObject<B> registerSingleBlock(String key, Supplier<? extends B> blockSupplier) {
        RegistryObject block = this.blockDeferredRegister.register(key, blockSupplier);
        return block;
    }

    public <T extends TileEntity> RegistryObject<TileEntityType<T>> registerTileEntity(String key, Supplier<? extends T> tileEntitySupplier, Supplier<Block[]> blockSupplier) {
        RegistryObject tileEntity = this.tileEntityTypeDeferredRegister.register(key, () -> new TileEntityType(tileEntitySupplier, (Set)Sets.newHashSet((Object[])((Object[])blockSupplier.get())), null));
        return tileEntity;
    }

    public <E extends Entity> RegistryObject<EntityType<E>> registerEntity(String key, EntityType.Builder<E> entityBuilder) {
        RegistryObject entity = this.entityTypeDeferredRegister.register(key, () -> entityBuilder.func_206830_a(this.getResourceLocation(key).toString()));
        return entity;
    }

    public RegistryObject<SoundEvent> registerSoundEvent(String key) {
        RegistryObject soundEvent = this.soundEventDeferredRegister.register(key, () -> new SoundEvent(this.getResourceLocation(key)));
        return soundEvent;
    }

    public <B extends Biome> RegistryObject<B> registerBiome(String key, Supplier<? extends B> biomeSupplier) {
        RegistryObject biome = this.biomeDeferredRegister.register(key, biomeSupplier);
        return biome;
    }

    public <F extends Feature<?>> RegistryObject<F> registerFeature(String key, Supplier<? extends F> featureSupplier) {
        RegistryObject feature = this.featureDeferredRegister.register(key, featureSupplier);
        return feature;
    }

    public <S extends SurfaceBuilder<?>> RegistryObject<S> registerSurfaceBuilder(String key, Supplier<? extends S> surfaceBuilderSupplier) {
        RegistryObject surfaceBuilder = this.surfaceBuilderDeferredRegister.register(key, surfaceBuilderSupplier);
        return surfaceBuilder;
    }

    public <W extends WorldCarver<?>> RegistryObject<W> registerWorldCarver(String key, Supplier<? extends W> worldCarverSupplier) {
        RegistryObject worldCarver = this.worldCarverDeferredRegister.register(key, worldCarverSupplier);
        return worldCarver;
    }

    public <P extends ParticleType<?>> RegistryObject<P> registerParticle(String key, Supplier<? extends P> particleSupplier) {
        RegistryObject particleType = this.particleTypeDeferredRegister.register(key, particleSupplier);
        return particleType;
    }

    public RegistryObject<BasicParticleType> registerBasicParticle(String key, boolean shouldAlwaysShow) {
        RegistryObject particleType = this.particleTypeDeferredRegister.register(key, () -> new BasicParticleType(shouldAlwaysShow));
        return particleType;
    }

    public <I extends Item> RegistryObject<I> registerVanillaItem(String key, Supplier<? extends I> itemSupplier) {
        RegistryObject item = this.vanillaItemDeferredRegister.register(key, itemSupplier);
        return item;
    }

    public <B extends Block> RegistryObject<B> registerVanillaBlock(String key, Supplier<? extends B> blockSupplier, ItemGroup group) {
        RegistryObject block = this.vanillaBlockDeferredRegister.register(key, blockSupplier);
        this.vanillaItemDeferredRegister.register(key, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group)));
        return block;
    }

    public <B extends Block> RegistryObject<B> registerVanillaSingleBlock(String key, Supplier<? extends B> blockSupplier) {
        RegistryObject block = this.vanillaBlockDeferredRegister.register(key, blockSupplier);
        return block;
    }

    public <B extends Block> RegistryObject<B> registerVanillaNonStackableBlock(String key, Supplier<? extends B> blockSupplier, ItemGroup group) {
        RegistryObject block = this.vanillaBlockDeferredRegister.register(key, blockSupplier);
        this.vanillaItemDeferredRegister.register(key, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200917_a(1).func_200916_a(group)));
        return block;
    }
}

