/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod;

import com.bluepowermod.BluePowerAPI;
import com.bluepowermod.ClientProxy;
import com.bluepowermod.CommonProxy;
import com.bluepowermod.api.BPApi;
import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.api.wire.redstone.CapabilityRedstoneDevice;
import com.bluepowermod.compat.CompatibilityUtils;
import com.bluepowermod.event.BPEventHandler;
import com.bluepowermod.event.BPRecyclingReloadListener;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPConfig;
import com.bluepowermod.init.BPEnchantments;
import com.bluepowermod.init.OreDictionarySetup;
import com.bluepowermod.init.Recipes;
import com.bluepowermod.network.BPNetworkHandler;
import com.bluepowermod.world.BPWorldGen;
import com.bluepowermod.world.WorldGenFlowers;
import com.bluepowermod.world.WorldGenOres;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="bluepower")
public class BluePower {
    public static BluePower instance;
    public static CommonProxy proxy;
    public static Logger log;

    public BluePower() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, BPConfig.spec);
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::complete);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(BPEnchantments.class);
        BPEventHandler eventHandler = new BPEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        BPApi.init(new BluePowerAPI());
        BPEnchantments.init();
        BPBlocks.init();
        proxy.preInitRenderers();
        BPWorldGen.init();
        MinecraftForge.EVENT_BUS.register((Object)new BPWorldGen());
        WorldGenOres.initOres();
        MinecraftForge.EVENT_BUS.register((Object)new WorldGenOres());
        WorldGenFlowers.initFlowers();
        MinecraftForge.EVENT_BUS.register((Object)new WorldGenFlowers());
    }

    public void setup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(BPNetworkHandler::init);
        OreDictionarySetup.init();
        CapabilityBlutricity.register();
        CapabilityRedstoneDevice.register();
        proxy.setup(event);
        CompatibilityUtils.init(event);
    }

    public void complete(FMLLoadCompleteEvent event) {
        proxy.initRenderers();
        CompatibilityUtils.postInit(event);
        Recipes.init();
    }

    @SubscribeEvent
    public void onResourceReload(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new BPRecyclingReloadListener(event.getDataPackRegistries()));
    }

    @SubscribeEvent
    public void onLootLoad(LootTableLoadEvent event) {
        ResourceLocation grass = new ResourceLocation("minecraft", "blocks/tall_grass");
        if (event.getName().equals((Object)grass)) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("bluepower", "blocks/tall_grass"))).name("bluepower:tall_grass").func_216044_b());
        }
    }

    @SubscribeEvent
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        BPRecyclingReloadListener.server = event.getServer();
        if (((Boolean)BPConfig.CONFIG.alloyFurnaceDatapackGenerator.get()).booleanValue()) {
            BPRecyclingReloadListener.onResourceManagerReload(event.getServer().func_199529_aN());
            ResourcePackList resourcepacklist = event.getServer().func_195561_aH();
            resourcepacklist.func_198983_a();
            ArrayList list = Lists.newArrayList((Iterable)resourcepacklist.func_198980_d());
            ResourcePackInfo bluepowerDatapack = resourcepacklist.func_198981_a("file/bluepower");
            if (!list.contains(bluepowerDatapack)) {
                list.add(2, bluepowerDatapack);
            }
            ResourcePackInfo vanillaDatapack = resourcepacklist.func_198981_a("vanilla");
            if (list.get(0) != vanillaDatapack) {
                list.remove(vanillaDatapack);
                list.add(0, vanillaDatapack);
            }
            event.getServer().func_240780_a_((Collection)list.stream().map(ResourcePackInfo::func_195790_f).collect(Collectors.toList())).exceptionally(ex -> null);
        }
    }

    static {
        proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        log = LogManager.getLogger((String)"bluepower");
    }
}

