/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block;

import com.bluepowermod.block.BlockContainerBase;
import com.bluepowermod.tile.TileBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockContainerHorizontalFacingBase
extends BlockContainerBase {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");

    public BlockContainerHorizontalFacingBase(Material material, Class<? extends TileBase> tileEntityClass) {
        super(material, tileEntityClass);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, ACTIVE});
    }

    public static void setState(boolean active, World worldIn, BlockPos pos) {
        BlockState iblockstate = worldIn.func_180495_p(pos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        worldIn.func_180501_a(pos, (BlockState)iblockstate.func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public static void setState(Direction facing, World worldIn, BlockPos pos) {
        BlockState iblockstate = worldIn.func_180495_p(pos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        worldIn.func_180501_a(pos, (BlockState)iblockstate.func_206870_a((Property)FACING, (Comparable)facing), 3);
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack iStack) {
        super.func_180633_a(world, pos, state, placer, iStack);
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)FACING, (Comparable)(this.canRotateVertical() ? Direction.func_196054_a((Entity)placer)[0] : placer.func_174811_aO().func_176734_d())), 2);
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        if (direction == Rotation.CLOCKWISE_90) {
            switch ((Direction)state.func_177229_b((Property)FACING)) {
                case NORTH: {
                    state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.EAST);
                    break;
                }
                case EAST: {
                    state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.SOUTH);
                    break;
                }
                case SOUTH: {
                    state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.WEST);
                    break;
                }
                case WEST: {
                    state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.NORTH);
                }
            }
        } else if (direction == Rotation.COUNTERCLOCKWISE_90) {
            switch ((Direction)state.func_177229_b((Property)FACING)) {
                case NORTH: {
                    state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.WEST);
                    break;
                }
                case WEST: {
                    state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.SOUTH);
                    break;
                }
                case SOUTH: {
                    state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.EAST);
                    break;
                }
                case EAST: {
                    state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.NORTH);
                }
            }
        } else if (direction == Rotation.CLOCKWISE_180) {
            state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)((Direction)state.func_177229_b((Property)FACING)).func_176734_d());
        }
        world.func_180501_a(pos, state, 2);
        return state;
    }
}

