/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.lighting;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.block.BlockBase;
import com.bluepowermod.block.lighting.BlockLampRGB;
import com.bluepowermod.client.render.IBPColoredBlock;
import com.bluepowermod.tile.tier1.TileLamp;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockLamp
extends BlockBase
implements IBPColoredBlock {
    public static final IntegerProperty POWER = IntegerProperty.func_177719_a((String)"power", (int)0, (int)15);
    private final boolean isInverted;
    private final MinecraftColor color;
    private final String name;
    private int tick = 0;

    public BlockLamp(String name, boolean isInverted, MinecraftColor color) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151591_t).func_200947_a(SoundType.field_185851_d).func_200943_b(1.0f));
        this.isInverted = isInverted;
        this.color = color;
        this.name = name;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)POWER, (Comparable)Integer.valueOf(isInverted ? 15 : 0)));
        this.setRegistryName(name + (isInverted ? "inverted" : "") + "_" + (color == MinecraftColor.NONE ? "rgb" : color.name().toLowerCase()));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileLamp();
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Integer)state.func_177229_b((Property)POWER);
    }

    @Override
    public int getColor(BlockState state, IBlockReader w, BlockPos pos, int tint) {
        return this.color.getHex();
    }

    @Override
    public int getColor(ItemStack stack, int tint) {
        return this.color.getHex();
    }

    public boolean isInverted() {
        return this.isInverted;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return !(world.func_180495_p(pos).func_177230_c() instanceof BlockLampRGB) && super.canConnectRedstone(state, world, pos, side);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWER});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        int redstoneValue = context.func_195991_k().func_175687_A(context.func_195995_a());
        if (this.isInverted) {
            redstoneValue = 15 - redstoneValue;
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)POWER, (Comparable)Integer.valueOf(redstoneValue));
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        drops.add(new ItemStack((IItemProvider)this));
        return drops;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (this.tick <= 1) {
            int redstoneValue = world.func_175687_A(pos);
            if (this.isInverted) {
                redstoneValue = 15 - redstoneValue;
            }
            world.func_180501_a(pos, (BlockState)this.func_176223_P().func_206870_a((Property)POWER, (Comparable)Integer.valueOf(redstoneValue)), 2);
        }
        ++this.tick;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean bool) {
        super.func_220069_a(state, world, pos, blockIn, fromPos, bool);
        int redstoneValue = world.func_175687_A(pos);
        if (this.isInverted) {
            redstoneValue = 15 - redstoneValue;
        }
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(redstoneValue)), 2);
    }
}

