/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.machine;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.CapabilityRedstoneDevice;
import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.block.BlockBPCableBase;
import com.bluepowermod.client.render.IBPColoredBlock;
import com.bluepowermod.tile.tier1.TileWire;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class BlockAlloyWire
extends BlockBPCableBase
implements IBPColoredBlock {
    public static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");
    final String type;

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileWire();
    }

    @Override
    protected Capability<?> getCapability() {
        return CapabilityRedstoneDevice.UNINSULATED_CAPABILITY;
    }

    public BlockAlloyWire(String type) {
        super(1.0f, 2.0f);
        this.type = type;
        this.func_180632_j((BlockState)super.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName("bluepower:" + type + "_wire");
    }

    public BlockAlloyWire(String type, float width, float height) {
        super(width, height);
        this.type = type;
        this.func_180632_j((BlockState)super.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean canConnect(World world, BlockPos pos, BlockState state, TileEntity tileEntity, Direction direction) {
        if (state.canConnectRedstone((IBlockReader)world, pos, direction)) {
            return true;
        }
        return super.canConnect(world, pos, state, tileEntity, direction);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, POWERED, CONNECTED_FRONT, CONNECTED_BACK, CONNECTED_LEFT, CONNECTED_RIGHT, JOIN_FRONT, JOIN_BACK, JOIN_LEFT, JOIN_RIGHT, WATERLOGGED});
    }

    @Override
    public int getColor(BlockState state, IBlockReader w, BlockPos pos, int tint) {
        return RedwireType.RED_ALLOY.getName().equals(this.type) ? MinecraftColor.RED.getHex() : MinecraftColor.BLUE.getHex();
    }

    @Override
    public int getColor(ItemStack stack, int tint) {
        return RedwireType.RED_ALLOY.getName().equals(this.type) ? MinecraftColor.RED.getHex() : MinecraftColor.BLUE.getHex();
    }
}

