/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.machine;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.CapabilityRedstoneDevice;
import com.bluepowermod.api.wire.redstone.IInsulatedRedstoneDevice;
import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.block.machine.BlockAlloyWire;
import com.bluepowermod.tile.TileBPMultipart;
import com.bluepowermod.tile.tier1.TileInsulatedWire;
import com.bluepowermod.tile.tier1.TileWire;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class BlockInsulatedAlloyWire
extends BlockAlloyWire {
    public BlockInsulatedAlloyWire(String type) {
        super(type, 2.0f, 2.0f);
        this.setRegistryName("bluepower:insulatedwire." + type);
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileInsulatedWire();
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (tileentity instanceof TileBPMultipart) {
            tileentity = ((TileBPMultipart)tileentity).getTileForState(state);
        }
        if (tileentity instanceof TileInsulatedWire) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("color", ((TileInsulatedWire)tileentity).getColor().name());
            ItemStack stack = new ItemStack((IItemProvider)this, 1, nbt);
            itemStacks.add(stack);
        }
        return itemStacks;
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        TileEntity tileentity = world.func_175625_s(pos);
        ItemStack stack = ItemStack.field_190927_a;
        if (tileentity instanceof TileBPMultipart) {
            tileentity = ((TileBPMultipart)tileentity).getTileForState(state);
        }
        if (tileentity instanceof TileInsulatedWire) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("color", ((TileInsulatedWire)tileentity).getColor().name());
            stack = new ItemStack((IItemProvider)this, 1, nbt);
        }
        return stack;
    }

    @Override
    public int getColor(BlockState state, IBlockReader world, BlockPos pos, int tintIndex) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBPMultipart) {
            tile = ((TileBPMultipart)tile).getTileForState(state);
        }
        if (tile instanceof TileWire && tintIndex == 1) {
            return ((IInsulatedRedstoneDevice)tile.getCapability(CapabilityRedstoneDevice.INSULATED_CAPABILITY).orElse(null)).getInsulationColor(null).getHex();
        }
        return RedwireType.RED_ALLOY.getName().equals(this.type) ? MinecraftColor.RED.getHex() : MinecraftColor.BLUE.getHex();
    }

    @Override
    public int getColor(ItemStack stack, int tintIndex) {
        MinecraftColor color = MinecraftColor.BLUE;
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("color")) {
            color = MinecraftColor.valueOf(stack.func_77978_p().func_74779_i("color"));
        }
        return tintIndex == 1 ? color.getHex() : (tintIndex == 2 ? (RedwireType.RED_ALLOY.getName().equals(this.type) ? MinecraftColor.RED.getHex() : MinecraftColor.BLUE.getHex()) : -1);
    }
}

