/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.power;

import com.bluepowermod.block.BlockContainerBase;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.tile.tier3.TileEngine;
import com.bluepowermod.util.AABBUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockEngine
extends BlockContainerBase
implements IWaterLoggable {
    public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");
    public static final BooleanProperty GEAR = BooleanProperty.func_177716_a((String)"gear");
    public static final BooleanProperty GLIDER = BooleanProperty.func_177716_a((String)"glider");
    public static final EnumProperty<Direction> FACING = EnumProperty.func_177709_a((String)"facing", Direction.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public BlockEngine() {
        super(Material.field_151573_f, TileEngine.class);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)GEAR, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)GLIDER, (Comparable)Boolean.valueOf(false))).func_206870_a(FACING, (Comparable)Direction.DOWN)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName("bluepower", "engine");
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ACTIVE, GEAR, GLIDER, FACING, WATERLOGGED});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return AABBUtils.rotate(Block.func_208617_a((double)0.01, (double)0.0, (double)0.01, (double)15.99f, (double)10.0, (double)15.99f), ((Direction)blockState.func_177229_b(FACING)).func_176734_d());
    }

    @Override
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity player, ItemStack iStack) {
        if (world.func_175625_s(pos) instanceof TileEngine) {
            Direction facing = player.field_70125_A > 45.0f ? Direction.DOWN : (player.field_70125_A < -45.0f ? Direction.UP : player.func_174811_aO().func_176734_d());
            TileEngine tile = (TileEngine)world.func_175625_s(pos);
            if (tile != null) {
                tile.setOrientation(facing);
            }
            world.func_180501_a(pos, (BlockState)state.func_206870_a(FACING, (Comparable)facing), 2);
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        Item item;
        if (!player.field_71071_by.func_70448_g().func_190926_b() && (item = player.field_71071_by.func_70448_g().func_77973_b()) == BPItems.screwdriver) {
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(blockState, world, pos, player, hand, rayTraceResult);
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return true;
    }
}

