/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.worldgen;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.init.BPBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockStoneOre
extends Block {
    private final boolean witherproof;

    public BlockStoneOre(String name, boolean witherproof) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(5.0f, witherproof ? 2000.0f : 2.0f).func_200947_a(SoundType.field_185851_d));
        this.setRegistryName("bluepower", name);
        BPBlocks.blockList.add(this);
        this.witherproof = witherproof;
    }

    public BlockStoneOre(String name) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200943_b(5.0f).func_200947_a(SoundType.field_185851_d));
        this.setRegistryName("bluepower", name);
        BPBlocks.blockList.add(this);
        this.witherproof = false;
    }

    public BlockStoneOre(String name, AbstractBlock.Properties properties) {
        super(properties);
        this.setRegistryName("bluepower", name);
        BPBlocks.blockList.add(this);
        this.witherproof = false;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (this.witherproof) {
            tooltip.add((ITextComponent)new StringTextComponent(MinecraftColor.RED.getChatColor() + "Witherproof"));
        }
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        if (this.witherproof) {
            return !(entity instanceof WitherEntity) && !(entity instanceof WitherSkullEntity) && super.canEntityDestroy(state, world, pos, entity);
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (!this.witherproof) {
            super.func_180652_a(worldIn, pos, explosionIn);
        }
    }

    public boolean func_149659_a(Explosion explosion) {
        return !this.witherproof && super.func_149659_a(explosion);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        drops.add(new ItemStack((IItemProvider)this));
        return drops;
    }
}

