/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.gui;

import com.bluepowermod.client.gui.widget.BaseWidget;
import com.bluepowermod.client.gui.widget.GuiAnimatedStat;
import com.bluepowermod.client.gui.widget.IGuiAnimatedStat;
import com.bluepowermod.client.gui.widget.IGuiWidget;
import com.bluepowermod.client.gui.widget.IWidgetListener;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.opengl.GL11;

public class GuiContainerBase<T extends Container>
extends ContainerScreen<T>
implements IWidgetListener {
    protected static final int COLOR_TEXT = 0x404040;
    protected final List<IGuiWidget> widgets = new ArrayList<IGuiWidget>();
    protected IInventory inventory;
    protected final Container field_147002_h;
    protected final ITextComponent field_230704_d_;
    protected final ResourceLocation resLoc;
    protected IGuiAnimatedStat lastLeftStat;
    protected IGuiAnimatedStat lastRightStat;

    public GuiContainerBase(T container, PlayerInventory playerInventory, ITextComponent title, ResourceLocation resLoc) {
        super(container, playerInventory, title);
        this.field_147002_h = container;
        this.field_230704_d_ = title;
        this.resLoc = resLoc;
    }

    protected boolean isInfoStatLeftSided() {
        return true;
    }

    protected GuiAnimatedStat addAnimatedStat(String title, ItemStack icon, int color, boolean leftSided) {
        GuiAnimatedStat stat = new GuiAnimatedStat((Screen)this, title, icon, this.field_147003_i + (leftSided ? 0 : this.field_146999_f), leftSided && this.lastLeftStat != null || !leftSided && this.lastRightStat != null ? 3 : this.field_147009_r + 5, color, leftSided ? this.lastLeftStat : this.lastRightStat, leftSided);
        this.addWidget(stat);
        if (leftSided) {
            this.lastLeftStat = stat;
        } else {
            this.lastRightStat = stat;
        }
        return stat;
    }

    protected GuiAnimatedStat addAnimatedStat(String title, String icon, int color, boolean leftSided) {
        GuiAnimatedStat stat = new GuiAnimatedStat((Screen)this, title, icon, this.field_147003_i + (leftSided ? 0 : this.field_146999_f), leftSided && this.lastLeftStat != null || !leftSided && this.lastRightStat != null ? 3 : this.field_147009_r + 5, color, leftSided ? this.lastLeftStat : this.lastRightStat, leftSided);
        this.addWidget(stat);
        if (leftSided) {
            this.lastLeftStat = stat;
        } else {
            this.lastRightStat = stat;
        }
        return stat;
    }

    protected void addWidget(IGuiWidget widget) {
        this.widgets.add(widget);
        widget.setListener(this);
    }

    public void drawHorizontalAlignedString(MatrixStack matrixStack, int xOffset, int yOffset, int w, String text, boolean useShadow) {
        int stringWidth = this.field_230712_o_.func_78256_a(text);
        int newX = xOffset;
        if (stringWidth < w) {
            newX = w / 2 - stringWidth / 2 + xOffset;
        }
        this.field_230712_o_.func_238421_b_(matrixStack, text, (float)newX, (float)yOffset, 0x404040);
    }

    public void drawString(MatrixStack matrixStack, int xOffset, int yOffset, String text, boolean useShadow) {
        this.field_230712_o_.func_238421_b_(matrixStack, text, (float)xOffset, (float)yOffset, 0x404040);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrixStack, I18n.func_135052_a((String)("block.bluepower." + this.field_230704_d_.func_150261_e()), (Object[])new Object[0]), (float)(this.field_146999_f / 2 - this.field_230712_o_.func_78256_a(I18n.func_135052_a((String)("block.bluepower." + this.field_230704_d_.func_150261_e()), (Object[])new Object[0])) / 2), 6.0f, 0x404040);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.resLoc);
        int x = (this.field_230708_k_ - this.field_146999_f) / 2;
        int y = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        for (IGuiWidget widget : this.widgets) {
            widget.render(matrixStack, i, j, f);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float partialTick) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, x, y, partialTick);
        this.func_230459_a_(matrixStack, x, y);
    }

    public boolean func_231044_a_(double x, double y, int button) {
        for (IGuiWidget widget : this.widgets) {
            if (!widget.getBounds().contains(x, y) || widget instanceof BaseWidget && !((BaseWidget)widget).enabled) continue;
            widget.onMouseClicked((int)x, (int)y, button);
        }
        return super.func_231044_a_(x, y, button);
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        if (widget instanceof GuiAnimatedStat && ((GuiAnimatedStat)widget).isClicked()) {
            for (IGuiWidget w : this.widgets) {
                if (w == widget || !(w instanceof GuiAnimatedStat) || ((GuiAnimatedStat)w).isLeftSided() != ((GuiAnimatedStat)widget).isLeftSided()) continue;
                ((GuiAnimatedStat)w).closeWindow();
            }
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        for (IGuiWidget widget : this.widgets) {
            widget.update();
        }
    }

    public void func_231152_a_(Minecraft minecraft, int x, int y) {
        super.func_231152_a_(minecraft, x, y);
        this.redraw();
    }

    public void redraw() {
        this.field_230710_m_.clear();
        this.widgets.clear();
        this.func_231160_c_();
    }
}

