/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.render;

import com.bluepowermod.tile.TileBPMultipart;
import com.bluepowermod.tile.tier1.TileWire;
import com.bluepowermod.util.MultipartUtils;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.VertexTransformer;

public class BPMultipartModel
implements IBakedModel {
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        Map stateInfo = (Map)extraData.getData(TileBPMultipart.STATE_INFO);
        if (stateInfo != null) {
            return stateInfo.keySet().stream().flatMap(i -> brd.func_184389_a(i).getQuads(i, side, rand, (IModelData)stateInfo.get(i)).stream().map(q -> ((IModelData)stateInfo.get(i)).hasProperty(TileWire.COLOR_INFO) ? BPMultipartModel.transform(q, (Pair<Integer, Integer>)((Pair)((IModelData)stateInfo.get(i)).getData(TileWire.COLOR_INFO)), ((IModelData)stateInfo.get(i)).hasProperty(TileWire.LIGHT_INFO) ? (Boolean)((IModelData)stateInfo.get(i)).getData(TileWire.LIGHT_INFO) : Boolean.valueOf(false)) : q)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return Collections.emptyList();
    }

    private static BakedQuad transform(final BakedQuad quad, final Pair<Integer, Integer> colorPair, Boolean fullBright) {
        BakedQuadBuilder builder = new BakedQuadBuilder();
        VertexTransformer consumer = new VertexTransformer((IVertexConsumer)builder){

            public void put(int element, float ... data) {
                VertexFormatElement e = (VertexFormatElement)this.getVertexFormat().func_227894_c_().get(element);
                if (e.func_177375_c() == VertexFormatElement.Usage.COLOR) {
                    int color = quad.func_178211_c() == 2 ? ((Integer)colorPair.getSecond()).intValue() : ((Integer)colorPair.getFirst()).intValue();
                    int redMask = 0xFF0000;
                    int greenMask = 65280;
                    int blueMask = 255;
                    int r = (color & redMask) >> 16;
                    int g = (color & greenMask) >> 8;
                    int b = color & blueMask;
                    this.parent.put(element, new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f});
                } else {
                    this.parent.put(element, data);
                }
            }
        };
        LightUtil.putBakedQuad((IVertexConsumer)consumer, (BakedQuad)quad);
        BakedQuad finalQuad = builder.build();
        if (fullBright.booleanValue()) {
            LightUtil.setLightData((BakedQuad)finalQuad, (int)240);
        }
        return finalQuad;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        BlockState state;
        RayTraceResult rayTraceResult = Minecraft.func_71410_x().field_71476_x;
        if (Minecraft.func_71410_x().field_71439_g != null && rayTraceResult instanceof BlockRayTraceResult && (state = MultipartUtils.getClosestState((Entity)Minecraft.func_71410_x().field_71439_g, ((BlockRayTraceResult)rayTraceResult).func_216350_a())) != null) {
            return Minecraft.func_71410_x().func_175602_ab().func_184389_a(state).func_177554_e();
        }
        return Minecraft.func_71410_x().func_209506_al().func_174953_a(new ModelResourceLocation("minecraft:stone", "")).func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

