/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.render;

import com.bluepowermod.block.power.BlockEngine;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.tile.tier3.TileEngine;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class RenderEngine
extends TileEntityRenderer<TileEngine> {
    float rotateAmount = 0.0f;

    RenderEngine(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TileEngine engine, float f, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int i, int i1) {
        World world = engine.func_145831_w();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        BlockPos pos = engine.func_174877_v();
        BlockState state = (BlockState)BPBlocks.engine.func_176223_P().func_206870_a(BlockEngine.FACING, (Comparable)engine.getOrientation());
        Direction facing = engine.getOrientation();
        matrixStack.func_227860_a_();
        float rotationX = 90.0f;
        float rotation = 0.0f;
        if (facing == Direction.NORTH) {
            matrixStack.func_227861_a_(0.0, 1.0, 0.0);
            rotation = 0.0f;
        } else if (facing == Direction.SOUTH) {
            matrixStack.func_227861_a_(1.0, 1.0, 1.0);
            rotation = 180.0f;
        } else if (facing == Direction.EAST) {
            matrixStack.func_227861_a_(1.0, 1.0, 0.0);
            rotation = 90.0f;
        } else if (facing == Direction.WEST) {
            matrixStack.func_227861_a_(0.0, 1.0, 1.0);
            rotation = -90.0f;
        } else if (facing == Direction.UP) {
            matrixStack.func_227861_a_(0.0, 1.0, 1.0);
            rotationX = 180.0f;
        } else if (facing == Direction.DOWN) {
            rotationX = 0.0f;
        }
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rotationX));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rotation));
        matrixStack.func_227860_a_();
        float f2 = 0.0f;
        if (engine.isActive) {
            f += (float)engine.pumpTick;
            if (engine.pumpSpeed > 0) {
                f /= (float)engine.pumpSpeed;
            }
            f2 = (float)(0.5 - 0.5 * Math.cos(Math.PI * (double)f)) / 4.0f;
        }
        matrixStack.func_227861_a_(0.0, (double)f2, 0.0);
        IBakedModel glider = dispatcher.func_184389_a((BlockState)state.func_206870_a((Property)BlockEngine.GLIDER, (Comparable)Boolean.valueOf(true)));
        IVertexBuilder builder = iRenderTypeBuffer.getBuffer(RenderType.func_228643_e_());
        dispatcher.func_175019_b().renderModel((IBlockDisplayReader)world, glider, (BlockState)state.func_206870_a((Property)BlockEngine.GLIDER, (Comparable)Boolean.valueOf(true)), pos, matrixStack, builder, false, new Random(), 0L, 0, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.0, 0.5);
        long angle = engine.isActive ? System.currentTimeMillis() / 10L % 360L : 0L;
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)angle));
        matrixStack.func_227861_a_(-0.5, 0.0, -0.5);
        IBakedModel gear = dispatcher.func_184389_a((BlockState)state.func_206870_a((Property)BlockEngine.GEAR, (Comparable)Boolean.valueOf(true)));
        dispatcher.func_175019_b().renderModel((IBlockDisplayReader)world, gear, (BlockState)state.func_206870_a((Property)BlockEngine.GEAR, (Comparable)Boolean.valueOf(true)), pos, matrixStack, iRenderTypeBuffer.getBuffer(RenderType.func_228643_e_()), false, new Random(), 0L, 0, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
    }
}

