/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.render;

import com.bluepowermod.block.lighting.BlockLamp;
import com.bluepowermod.client.render.BPRenderTypes;
import com.bluepowermod.client.render.RenderHelper;
import com.bluepowermod.tile.tier1.TileLamp;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderLamp
extends TileEntityRenderer<TileLamp> {
    RenderLamp(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TileLamp te, float v, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int partialTicks, int destroyStage) {
        if (!(te.func_195044_w().func_177230_c() instanceof BlockLamp)) {
            return;
        }
        BlockState stateLamp = te.func_195044_w();
        BlockLamp bLamp = (BlockLamp)stateLamp.func_177230_c();
        if (te.func_145831_w() == null) {
            return;
        }
        int power = (Integer)stateLamp.func_177229_b((Property)BlockLamp.POWER);
        int color = bLamp.getColor(stateLamp, (IBlockReader)te.func_145831_w(), te.func_174877_v(), 0);
        int redMask = 0xFF0000;
        int greenMask = 65280;
        int blueMask = 255;
        int r = (color & redMask) >> 16;
        int g = (color & greenMask) >> 8;
        int b = color & blueMask;
        AxisAlignedBB box = stateLamp.func_196954_c((IBlockReader)te.func_145831_w(), te.func_174877_v()).func_197752_a();
        box = box.equals((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)) ? box.func_186662_g(0.05) : box.func_186662_g(0.03125);
        boolean[] renderFaces = new boolean[]{true, true, true, true, true, true};
        if (stateLamp.func_196954_c((IBlockReader)te.func_145831_w(), te.func_174877_v()).func_197752_a().equals((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0))) {
            for (Direction face : Direction.values()) {
                BlockState state = te.func_145831_w().func_180495_p(te.func_174877_v().func_177972_a(face.func_176734_d()));
                if (!(state.func_177230_c() instanceof BlockLamp) || !state.func_196954_c((IBlockReader)te.func_145831_w(), te.func_174877_v()).func_197752_a().equals((Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)) || (Integer)state.func_177229_b((Property)BlockLamp.POWER) <= 0) continue;
                renderFaces[face.func_176745_a()] = false;
                double offsetx = (double)face.func_82601_c() * 0.05 > 0.0 ? (double)face.func_82601_c() * 0.05 : 0.0;
                double offsety = (double)face.func_96559_d() * 0.05 > 0.0 ? (double)face.func_96559_d() * 0.05 : 0.0;
                double offsetz = (double)face.func_82599_e() * 0.05 > 0.0 ? (double)face.func_82599_e() * 0.05 : 0.0;
                double toffsetx = (double)face.func_82601_c() * 0.05 < 0.0 ? (double)face.func_82601_c() * 0.05 : 0.0;
                double toffsety = (double)face.func_96559_d() * 0.05 < 0.0 ? (double)face.func_96559_d() * 0.05 : 0.0;
                double toffsetz = (double)face.func_82599_e() * 0.05 < 0.0 ? (double)face.func_82599_e() * 0.05 : 0.0;
                box = new AxisAlignedBB(box.field_72340_a + offsetx, box.field_72338_b + offsety, box.field_72339_c + offsetz, box.field_72336_d + toffsetx, box.field_72337_e + toffsety, box.field_72334_f + toffsetz);
            }
        }
        matrixStack.func_227860_a_();
        double powerDivision = (double)power / 18.0;
        RenderHelper.drawColoredCube(box, iRenderTypeBuffer.getBuffer(BPRenderTypes.LAMP_GLOW), matrixStack, r, g, b, (int)(powerDivision * 200.0), 200, renderFaces);
        matrixStack.func_227865_b_();
    }
}

