/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.compat.jei;

import com.bluepowermod.client.gui.GuiAlloyFurnace;
import com.bluepowermod.client.gui.GuiBlulectricAlloyFurnace;
import com.bluepowermod.client.gui.GuiBlulectricFurnace;
import com.bluepowermod.compat.jei.AlloyFurnaceHandler;
import com.bluepowermod.container.ContainerAlloyFurnace;
import com.bluepowermod.container.ContainerBlulectricAlloyFurnace;
import com.bluepowermod.container.ContainerBlulectricFurnace;
import com.bluepowermod.container.ContainerProjectTable;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.recipe.AlloyFurnaceRegistry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;
    Map<Class, IRecipeCategory> categories = new LinkedHashMap<Class, IRecipeCategory>();

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("bluepower", "jeiplugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        this.categories.put(AlloyFurnaceRegistry.StandardAlloyFurnaceRecipe.class, new AlloyFurnaceHandler(guiHelper));
        registry.addRecipeCategories(this.categories.values().toArray(new IRecipeCategory[this.categories.size()]));
    }

    public void registerRecipes(IRecipeRegistration registryIn) {
        registryIn.addRecipes(JEIPlugin.getRecipes(AlloyFurnaceRegistry.ALLOYFURNACE_RECIPE), new ResourceLocation("bluepower", "alloyfurnace"));
        registryIn.addRecipes(JEIPlugin.getMicroblockRecipes(), VanillaRecipeCategoryUid.CRAFTING);
    }

    private static List<IRecipe<?>> getRecipes(IRecipeType<?> recipeType) {
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(recipe -> recipe.func_222127_g() == recipeType).collect(Collectors.toList());
    }

    private static List<IRecipe<?>> getMicroblockRecipes() {
        ArrayList recipes = new ArrayList();
        for (Block block : ForgeRegistries.BLOCKS) {
            VoxelShape shape = null;
            try {
                shape = block.func_176223_P().func_196954_c(null, null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (block.getRegistryName() == null || shape != VoxelShapes.func_197868_b()) continue;
            ItemStack output = ItemStack.field_190927_a;
            for (Block mb : BPBlocks.microblocks) {
                NonNullList input = NonNullList.func_191196_a();
                input.add((Object)Ingredient.func_199805_a((ITag)ItemTags.createOptional((ResourceLocation)new ResourceLocation("bluepower:saw"))));
                if (mb == BPBlocks.half_block) {
                    input.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)block)}));
                } else {
                    input.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{output}));
                }
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74778_a("block", block.getRegistryName().toString());
                ItemStack stack = new ItemStack((IItemProvider)mb);
                stack.func_77982_d(nbt);
                stack.func_200302_a((ITextComponent)new TranslationTextComponent(block.func_149739_a()).func_230529_a_((ITextComponent)new StringTextComponent(" ")).func_230529_a_((ITextComponent)new TranslationTextComponent(mb.func_149739_a())));
                output = stack;
                recipes.add((IRecipe<?>)new ShapelessRecipe(new ResourceLocation("bluepower:" + mb.func_149739_a() + block.func_149739_a()), "", output, input));
            }
        }
        return recipes;
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(GuiAlloyFurnace.class, 100, 32, 28, 23, new ResourceLocation[]{new ResourceLocation("bluepower", "alloyfurnace")});
        registration.addRecipeClickArea(GuiBlulectricAlloyFurnace.class, 102, 32, 28, 23, new ResourceLocation[]{new ResourceLocation("bluepower", "alloyfurnace")});
        registration.addRecipeClickArea(GuiBlulectricFurnace.class, 89, 32, 28, 23, new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BPBlocks.alloyfurnace), new ResourceLocation[]{new ResourceLocation("bluepower", "alloyfurnace")});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BPBlocks.blulectric_alloyfurnace), new ResourceLocation[]{new ResourceLocation("bluepower", "alloyfurnace")});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BPBlocks.project_table), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BPBlocks.blulectric_furnace), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(ContainerAlloyFurnace.class, new ResourceLocation("bluepower", "alloyfurnace"), 2, 9, 11, 36);
        registration.addRecipeTransferHandler(ContainerBlulectricAlloyFurnace.class, new ResourceLocation("bluepower", "alloyfurnace"), 1, 9, 10, 36);
        registration.addRecipeTransferHandler(ContainerProjectTable.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 54);
        registration.addRecipeTransferHandler(ContainerBlulectricFurnace.class, VanillaRecipeCategoryUid.FURNACE, 0, 1, 2, 36);
    }
}

