/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.event;

import com.bluepowermod.ClientProxy;
import com.bluepowermod.block.BlockBPMultipart;
import com.bluepowermod.client.gui.GuiCircuitDatabaseSharing;
import com.bluepowermod.container.ContainerSeedBag;
import com.bluepowermod.init.BPEnchantments;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.item.ItemSeedBag;
import com.bluepowermod.item.ItemSickle;
import com.bluepowermod.util.MultipartUtils;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.GrassBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.ItemStackHandler;

public class BPEventHandler {
    private boolean isAttacking = false;

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.world.func_82737_E() % 200L == 0L) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onAnvilEvent(AnvilUpdateEvent event) {
        if (!event.getLeft().func_190926_b() && event.getLeft().func_77973_b() == BPItems.screwdriver && !event.getRight().func_190926_b() && event.getRight().func_77973_b() == Items.field_151134_bR && EnchantmentHelper.func_82781_a((ItemStack)event.getRight()).get(Enchantments.field_185306_r) != null) {
            event.setOutput(new ItemStack((IItemProvider)BPItems.silky_screwdriver, 1));
            event.setCost(20);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack heldItem;
        if (event.getPlayer().func_184812_l_() && !(heldItem = event.getPlayer().func_184586_b(event.getHand())).func_190926_b() && heldItem.func_77973_b() instanceof ItemSickle) {
            heldItem.func_77973_b().func_179218_a(heldItem, event.getWorld(), event.getWorld().func_180495_p(event.getPos()), event.getPos(), (LivingEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void itemPickUp(EntityItemPickupEvent event) {
        PlayerEntity player = event.getPlayer();
        ItemStack pickUp = event.getItem().func_92059_d();
        if (!(player.field_71070_bA instanceof ContainerSeedBag)) {
            for (ItemStack is : player.field_71071_by.field_70462_a) {
                ItemStack seedType;
                if (is.func_190926_b() || !(is.func_77973_b() instanceof ItemSeedBag) || (seedType = ItemSeedBag.getSeedType(is)).func_190926_b() || !seedType.func_77969_a(pickUp)) continue;
                ItemStackHandler seedBagInvHandler = new ItemStackHandler(9);
                if (is.func_77942_o()) {
                    seedBagInvHandler.deserializeNBT(is.func_77978_p().func_74775_l("inv"));
                }
                for (int j = 0; j < 9 && !pickUp.func_190926_b(); ++j) {
                    pickUp = seedBagInvHandler.insertItem(j, pickUp, false);
                }
                if (!is.func_77942_o()) {
                    is.func_77982_d(new CompoundNBT());
                }
                if (is.func_77978_p() != null) {
                    is.func_77978_p().func_218657_a("inv", (INBT)seedBagInvHandler.serializeNBT());
                }
                if (pickUp.func_190926_b()) {
                    event.setResult(Event.Result.ALLOW);
                    event.getItem().func_70106_y();
                    return;
                }
                event.getItem().func_92058_a(pickUp);
            }
        }
    }

    @SubscribeEvent
    public void onEntityAttack(LivingAttackEvent event) {
        EntityDamageSource entitySource;
        if (!this.isAttacking && event.getSource() instanceof EntityDamageSource && (entitySource = (EntityDamageSource)event.getSource()).func_76346_g() instanceof PlayerEntity) {
            PlayerEntity killer = (PlayerEntity)entitySource.func_76346_g();
            if (!killer.field_71071_by.func_70448_g().func_190926_b() && EnchantmentHelper.func_82781_a((ItemStack)killer.field_71071_by.func_70448_g()).containsKey(BPEnchantments.disjunction) && (event.getEntityLiving() instanceof EndermanEntity || event.getEntityLiving() instanceof EnderDragonEntity)) {
                int level = EnchantmentHelper.func_77506_a((Enchantment)BPEnchantments.disjunction, (ItemStack)killer.field_71071_by.func_70448_g());
                this.isAttacking = true;
                event.getEntityLiving().func_70097_a(event.getSource(), event.getAmount() * ((float)level * 0.5f + 1.0f));
                this.isAttacking = false;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        EntityDamageSource entitySource;
        if (event.getSource() instanceof EntityDamageSource && (entitySource = (EntityDamageSource)event.getSource()).func_76346_g() instanceof PlayerEntity) {
            PlayerEntity killer = (PlayerEntity)entitySource.func_76346_g();
            if (!killer.field_71071_by.func_70448_g().func_190926_b() && EnchantmentHelper.func_82781_a((ItemStack)killer.field_71071_by.func_70448_g()).containsKey(BPEnchantments.vorpal)) {
                int level = EnchantmentHelper.func_77506_a((Enchantment)BPEnchantments.vorpal, (ItemStack)killer.field_71071_by.func_70448_g());
                if (level == 1) {
                    if (killer.field_70170_p.field_73012_v.nextInt(6) == 1) {
                        this.dropHeads(event);
                    }
                } else if (level == 2 && killer.field_70170_p.field_73012_v.nextInt(3) == 1) {
                    this.dropHeads(event);
                }
            }
        }
    }

    private void dropHeads(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof CreeperEntity) {
            event.getEntityLiving().func_70099_a(new ItemStack((IItemProvider)Items.field_196185_dy, 1), 0.0f);
        }
        if (event.getEntityLiving() instanceof PlayerEntity) {
            ItemStack drop = new ItemStack((IItemProvider)Items.field_196184_dx, 1);
            drop.func_77982_d(new CompoundNBT());
            drop.func_77978_p().func_74778_a("SkullOwner", event.getEntityLiving().func_145748_c_().getString());
            event.getEntityLiving().func_70099_a(drop, 0.0f);
        }
        if (event.getEntityLiving() instanceof AbstractSkeletonEntity) {
            AbstractSkeletonEntity sk = (AbstractSkeletonEntity)event.getEntityLiving();
            if (sk instanceof SkeletonEntity) {
                event.getEntityLiving().func_70099_a(new ItemStack((IItemProvider)Items.field_196182_dv, 1), 0.0f);
            } else {
                event.getEntityLiving().func_70099_a(new ItemStack((IItemProvider)Items.field_196183_dw, 1), 0.0f);
            }
        }
        if (event.getEntityLiving() instanceof ZombieEntity) {
            event.getEntityLiving().func_70099_a(new ItemStack((IItemProvider)Items.field_196186_dz, 1), 0.0f);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().func_77942_o() && event.getItemStack().func_77978_p().func_74764_b("tileData") && !event.getItemStack().func_77978_p().func_74767_n("hideSilkyTooltip")) {
            event.getToolTip().add(new StringTextComponent("gui.tooltip.hasSilkyData"));
        }
        if (ClientProxy.getOpenedGui() instanceof GuiCircuitDatabaseSharing) {
            ItemStack deletingStack = ((GuiCircuitDatabaseSharing)ClientProxy.getOpenedGui()).getCurrentDeletingTemplate();
            if (!deletingStack.func_190926_b() && deletingStack == event.getItemStack()) {
                event.getToolTip().add(new StringTextComponent("gui.circuitDatabase.info.sneakClickToConfirmDeleting"));
            } else {
                event.getToolTip().add(new StringTextComponent("gui.circuitDatabase.info.sneakClickToDelete"));
            }
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.getCrafting().func_77973_b();
        if (item == Item.func_150898_a((Block)Blocks.field_150350_a)) {
            return;
        }
    }

    @SubscribeEvent
    public void onBonemealEvent(BonemealEvent event) {
        if (!event.getWorld().field_72995_K && event.getBlock().func_177230_c() instanceof GrassBlock) {
            for (int x = event.getPos().func_177958_n() - 2; x < event.getPos().func_177958_n() + 3; ++x) {
                for (int z = event.getPos().func_177952_p() - 2; z < event.getPos().func_177952_p() + 3; ++z) {
                    if (event.getWorld().func_175623_d(new BlockPos(x, event.getPos().func_177956_o() + 1, z)) && event.getWorld().field_73012_v.nextInt(50) != 1) continue;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void blockHighlightEvent(DrawHighlightEvent event) {
        BlockPos pos;
        BlockState state;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        World world = player.field_70170_p;
        if (world == null) {
            return;
        }
        RayTraceResult mop = event.getTarget();
        if (mop instanceof BlockRayTraceResult && (state = world.func_180495_p(pos = ((BlockRayTraceResult)mop).func_216350_a())).func_177230_c() instanceof BlockBPMultipart) {
            BlockState partstate = MultipartUtils.getClosestState((Entity)player, pos);
            IVertexBuilder builder = event.getBuffers().getBuffer(RenderType.func_228659_m_());
            if (partstate != null) {
                VoxelShape shape = partstate.func_215700_a((IBlockReader)world, pos, ISelectionContext.func_216374_a((Entity)player));
                Vector3d projectedView = event.getInfo().func_216785_c();
                double d0 = (double)pos.func_177958_n() - projectedView.func_82615_a();
                double d1 = (double)pos.func_177956_o() - projectedView.func_82617_b();
                double d2 = (double)pos.func_177952_p() - projectedView.func_82616_c();
                Matrix4f matrix4f = event.getMatrix().func_227866_c_().func_227870_a_();
                shape.func_197754_a((startX, startY, startZ, endX, endY, endZ) -> {
                    builder.func_227888_a_(matrix4f, (float)(startX + d0), (float)(startY + d1), (float)(startZ + d2)).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                    builder.func_227888_a_(matrix4f, (float)(endX + d0), (float)(endY + d1), (float)(endZ + d2)).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
                });
                event.setCanceled(true);
            }
        }
    }
}

