/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.client.gui.IGuiButtonSensitive;
import com.bluepowermod.container.ContainerFilter;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.helper.ItemStackHelper;
import com.bluepowermod.tile.tier1.TileTransposer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TileFilter
extends TileTransposer
implements ISidedInventory,
IGuiButtonSensitive,
INamedContainerProvider {
    public static final int SLOTS = 9;
    protected final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    public IPneumaticTube.TubeColor filterColor = IPneumaticTube.TubeColor.NONE;
    public int fuzzySetting;

    @Override
    protected boolean isItemAccepted(ItemStack item) {
        boolean everythingNull = true;
        for (ItemStack invStack : this.inventory) {
            if (invStack.func_190926_b()) continue;
            if (ItemStackHelper.areStacksEqual(invStack, item, this.fuzzySetting)) {
                return true;
            }
            everythingNull = false;
        }
        return everythingNull;
    }

    @Override
    protected IPneumaticTube.TubeColor getAcceptedItemColor(ItemStack item) {
        return this.filterColor;
    }

    @Override
    protected void pullItem() {
        ItemStack extractedStack;
        Direction dir = this.getOutputDirection().func_176734_d();
        TileEntity tile = this.getTileCache(dir);
        Direction direction = dir.func_176734_d();
        boolean everythingNull = true;
        for (ItemStack filterStack : this.inventory) {
            if (filterStack.func_190926_b()) continue;
            everythingNull = false;
            ItemStack extractedStack2 = IOHelper.extract(tile, direction, filterStack, true, false, this.fuzzySetting);
            if (extractedStack2.func_190926_b()) continue;
            this.addItemToOutputBuffer(extractedStack2, this.filterColor);
            break;
        }
        if (everythingNull && !(extractedStack = IOHelper.extract(tile, direction, false)).func_190926_b()) {
            this.addItemToOutputBuffer(extractedStack, this.filterColor);
        }
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT tCompound) {
        super.func_230337_a_(blockState, tCompound);
        for (int i = 0; i < 9; ++i) {
            CompoundNBT tc = tCompound.func_74775_l("inventory" + i);
            this.inventory.set(i, (Object)new ItemStack((IItemProvider)tc));
        }
        this.filterColor = IPneumaticTube.TubeColor.values()[tCompound.func_74771_c("filterColor")];
        this.fuzzySetting = tCompound.func_74771_c("fuzzySetting");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tCompound) {
        super.func_189515_b(tCompound);
        for (int i = 0; i < 9; ++i) {
            CompoundNBT tc = new CompoundNBT();
            ((ItemStack)this.inventory.get(i)).func_77955_b(tc);
            tCompound.func_218657_a("inventory" + i, (INBT)tc);
        }
        tCompound.func_74774_a("filterColor", (byte)this.filterColor.ordinal());
        tCompound.func_74774_a("fuzzySetting", (byte)this.fuzzySetting);
        return tCompound;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (!itemStack.func_190926_b()) {
            if (itemStack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            } else if ((itemStack = itemStack.func_77979_a(amount)).func_190916_E() == 0) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack itemStack = this.func_70301_a(i);
        if (!itemStack.func_190926_b()) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
        return itemStack;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return player.func_233580_cy_().func_218141_a((Vector3i)this.field_174879_c, 64.0);
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList<ItemStack> drops = super.getDrops();
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            drops.add((Object)stack);
        }
        return drops;
    }

    public int[] func_180463_a(Direction side) {
        Direction direction = this.getFacingDirection();
        if (side == direction || side == direction.func_176734_d()) {
            return new int[0];
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    public boolean func_191420_l() {
        return this.inventory.size() == 0;
    }

    public void func_174888_l() {
    }

    @Override
    public void onButtonPress(PlayerEntity player, int messageId, int value) {
        if (messageId == 0) {
            this.filterColor = IPneumaticTube.TubeColor.values()[value];
        }
        if (messageId == 1) {
            this.fuzzySetting = value;
        }
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("filter");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity playerEntity) {
        return new ContainerFilter(id, inventory, (IInventory)this);
    }
}

