/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier2;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.client.gui.IGuiButtonSensitive;
import com.bluepowermod.container.ContainerRegulator;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.helper.ItemStackHelper;
import com.bluepowermod.tile.BPTileEntityType;
import com.bluepowermod.tile.TileMachineBase;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TileRegulator
extends TileMachineBase
implements ISidedInventory,
IGuiButtonSensitive,
INamedContainerProvider {
    public static final int SLOTS = 27;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    public IPneumaticTube.TubeColor color = IPneumaticTube.TubeColor.NONE;
    public int mode;
    public int fuzzySetting;

    public TileRegulator() {
        super(BPTileEntityType.REGULATOR);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("regulator");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity playerEntity) {
        return new ContainerRegulator(id, inventory, (IInventory)this);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            boolean shouldEmitRedstone;
            IInventory inv;
            boolean ratiosMatch = true;
            for (int i = 0; i < 9; ++i) {
                if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                int inputFilterItems = this.getItemsInSection((ItemStack)this.inventory.get(i), EnumSection.INPUT_FILTER);
                int bufferItems = this.getItemsInSection((ItemStack)this.inventory.get(i), EnumSection.BUFFER);
                if (bufferItems >= inputFilterItems) continue;
                ratiosMatch = false;
                break;
            }
            if (ratiosMatch && !this.isEjecting()) {
                this.checkIndividualOutputFilterAndEject();
            }
            if (this.mode == 1 && !this.isEjecting() && (inv = IOHelper.getInventoryForTE(this.getTileCache(this.getOutputDirection()))) != null) {
                int i;
                int[] accessibleSlots;
                if (inv instanceof ISidedInventory) {
                    accessibleSlots = ((ISidedInventory)inv).func_180463_a(this.getFacingDirection());
                } else {
                    accessibleSlots = new int[inv.func_70302_i_()];
                    for (i = 0; i < accessibleSlots.length; ++i) {
                        accessibleSlots[i] = i;
                    }
                }
                for (i = 18; i < 27; ++i) {
                    ItemStack remainder;
                    if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                    int outputFilterItems = this.getItemsInSection((ItemStack)this.inventory.get(i), EnumSection.OUTPUT_FILTER);
                    int supplyingInvCount = 0;
                    for (int slot : accessibleSlots) {
                        ItemStack stackInSlot = inv.func_70301_a(slot);
                        if (stackInSlot.func_190926_b() || !ItemStackHelper.areStacksEqual(stackInSlot, (ItemStack)this.inventory.get(i), this.fuzzySetting) || !IOHelper.canInsertItemToInventory(inv, (ItemStack)this.inventory.get(i), slot, this.getFacingDirection().ordinal())) continue;
                        supplyingInvCount += stackInSlot.func_190916_E();
                    }
                    if (supplyingInvCount >= outputFilterItems) continue;
                    ItemStack requestedStack = ((ItemStack)this.inventory.get(i)).func_77946_l();
                    requestedStack.func_190920_e(outputFilterItems - supplyingInvCount);
                    ItemStack bufferItems = IOHelper.extract(this, null, requestedStack, true, false, this.fuzzySetting);
                    if (bufferItems.func_190926_b() || (remainder = IOHelper.insert(inv, bufferItems, this.getFacingDirection().ordinal(), false)).func_190926_b()) continue;
                    IOHelper.insert(this, remainder, null, false);
                }
            }
            boolean bl = shouldEmitRedstone = this.isSatisfied() || this.animationTicker >= 0;
            if (this.isEjecting() != shouldEmitRedstone) {
                this.setOutputtingRedstone(shouldEmitRedstone);
                this.sendUpdatePacket();
            }
        }
    }

    @Override
    public void onButtonPress(PlayerEntity player, int messageId, int value) {
        if (messageId == 1) {
            this.mode = value;
        } else if (messageId == 0) {
            this.color = IPneumaticTube.TubeColor.values()[value];
        } else if (messageId == 2) {
            this.fuzzySetting = value;
        }
    }

    @Override
    public boolean isEjecting() {
        return super.isEjecting() || this.getOutputtingRedstone() > 0;
    }

    private boolean isSatisfied() {
        IInventory inv = IOHelper.getInventoryForTE(this.getTileCache(this.getOutputDirection()));
        if (inv != null) {
            int[] accessibleSlots;
            if (inv instanceof ISidedInventory) {
                accessibleSlots = ((ISidedInventory)inv).func_180463_a(this.getFacingDirection());
            } else {
                accessibleSlots = new int[inv.func_70302_i_()];
                for (int i = 0; i < accessibleSlots.length; ++i) {
                    accessibleSlots[i] = i;
                }
            }
            boolean everythingNull = true;
            for (int i = 18; i < 27; ++i) {
                if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                everythingNull = false;
                int outputFilterItems = this.getItemsInSection((ItemStack)this.inventory.get(i), EnumSection.OUTPUT_FILTER);
                int supplyingInvCount = 0;
                for (int slot : accessibleSlots) {
                    ItemStack stackInSlot = inv.func_70301_a(slot);
                    if (stackInSlot.func_190926_b() || !ItemStackHelper.areStacksEqual(stackInSlot, (ItemStack)this.inventory.get(i), this.fuzzySetting) || !IOHelper.canInsertItemToInventory(inv, (ItemStack)this.inventory.get(i), slot, this.getFacingDirection().ordinal())) continue;
                    supplyingInvCount += stackInSlot.func_190916_E();
                }
                if (supplyingInvCount >= outputFilterItems) continue;
                return false;
            }
            return !everythingNull;
        }
        return false;
    }

    private void checkIndividualOutputFilterAndEject() {
        for (int i = 0; i < 9; ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            int inputFilterItems = this.getItemsInSection((ItemStack)this.inventory.get(i), EnumSection.INPUT_FILTER);
            int bufferItems = this.getItemsInSection((ItemStack)this.inventory.get(i), EnumSection.BUFFER);
            if (bufferItems < inputFilterItems) continue;
            ItemStack stackFromBuffer = IOHelper.extract(this, null, (ItemStack)this.inventory.get(i), true, false, this.fuzzySetting);
            this.addItemToOutputBuffer(stackFromBuffer, this.color);
        }
    }

    private int getItemsInSection(ItemStack type, EnumSection section) {
        int count = 0;
        for (int i = section.ordinal() * 9; i < section.ordinal() * 9 + 9; ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b() || !ItemStackHelper.areStacksEqual(type, (ItemStack)this.inventory.get(i), this.fuzzySetting)) continue;
            count += ((ItemStack)this.inventory.get(i)).func_190916_E();
        }
        return count;
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList<ItemStack> drops = super.getDrops();
        for (int i = 9; i < 18; ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            drops.add(this.inventory.get(i));
        }
        return drops;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("filterColor", (byte)this.color.ordinal());
        tag.func_74774_a("mode", (byte)this.mode);
        tag.func_74774_a("fuzzySetting", (byte)this.fuzzySetting);
        ListNBT tagList = new ListNBT();
        for (int currentIndex = 0; currentIndex < this.inventory.size(); ++currentIndex) {
            CompoundNBT tagCompound = new CompoundNBT();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            ((ItemStack)this.inventory.get(currentIndex)).func_77955_b(tagCompound);
            tagList.add((Object)tagCompound);
        }
        tag.func_218657_a("Items", (INBT)tagList);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.color = IPneumaticTube.TubeColor.values()[tag.func_74771_c("filterColor")];
        this.mode = tag.func_74771_c("mode");
        this.fuzzySetting = tag.func_74771_c("fuzzySetting");
        ListNBT tagList = tag.func_150295_c("Items", 10);
        this.inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.size()) continue;
            this.inventory.set((int)slot, (Object)ItemStack.func_199557_a((CompoundNBT)tagCompound));
        }
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (!itemStack.func_190926_b()) {
            if (itemStack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            } else if ((itemStack = itemStack.func_77979_a(amount)).func_190916_E() == 0) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack itemStack = this.func_70301_a(i);
        if (!itemStack.func_190926_b()) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
        return itemStack;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    public int[] func_180463_a(Direction side) {
        if (side == this.getFacingDirection() || side == this.getOutputDirection()) {
            return new int[0];
        }
        int[] slots = new int[9];
        for (int i = 9; i < 18; ++i) {
            slots[i - 9] = i;
        }
        return slots;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public boolean func_191420_l() {
        return this.inventory.size() == 0;
    }

    public void func_174888_l() {
    }

    private static enum EnumSection {
        INPUT_FILTER,
        BUFFER,
        OUTPUT_FILTER;

    }
}

