/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier2;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.client.gui.IGuiButtonSensitive;
import com.bluepowermod.container.ContainerSortingMachine;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.helper.ItemStackHelper;
import com.bluepowermod.tile.BPTileEntityType;
import com.bluepowermod.tile.TileMachineBase;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TileSortingMachine
extends TileMachineBase
implements ISidedInventory,
IGuiButtonSensitive,
INamedContainerProvider {
    public int curColumn = 0;
    public PullMode pullMode = PullMode.SINGLE_STEP;
    public SortMode sortMode = SortMode.ANYSTACK_SEQUENTIAL;
    private boolean sweepTriggered;
    private int savedPulses;
    public static final int SLOTS = 40;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)40, (Object)ItemStack.field_190927_a);
    public final IPneumaticTube.TubeColor[] colors = new IPneumaticTube.TubeColor[9];
    public int[] fuzzySettings = new int[8];
    private ItemStack nonAcceptedStack;

    public TileSortingMachine() {
        super(BPTileEntityType.SORTING_MACHINE);
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = IPneumaticTube.TubeColor.NONE;
        }
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("sorting_machine");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity playerEntity) {
        return new ContainerSortingMachine(id, inventory, (IInventory)this);
    }

    @Override
    public void func_73660_a() {
        this.nonAcceptedStack = ItemStack.field_190927_a;
        super.func_73660_a();
        if (!this.sweepTriggered && this.savedPulses > 0) {
            --this.savedPulses;
            this.sweepTriggered = true;
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 10L == 0L && (this.pullMode == PullMode.SINGLE_SWEEP && this.sweepTriggered || this.pullMode == PullMode.AUTOMATIC)) {
            this.triggerSorting();
        }
    }

    @Override
    protected void redstoneChanged(boolean newValue) {
        super.redstoneChanged(newValue);
        if (newValue) {
            if (this.pullMode == PullMode.SINGLE_STEP) {
                this.triggerSorting();
            }
            if (this.pullMode == PullMode.SINGLE_SWEEP) {
                ++this.savedPulses;
            }
        }
    }

    private void triggerSorting() {
        block8: {
            int[] accessibleSlots;
            IInventory inputInv;
            block10: {
                block9: {
                    Direction dir = this.getOutputDirection().func_176734_d();
                    TileEntity inputTE = this.getTileCache(dir);
                    if (!(inputTE instanceof IInventory)) break block8;
                    inputInv = (IInventory)inputTE;
                    if (inputInv instanceof ISidedInventory) {
                        accessibleSlots = ((ISidedInventory)inputInv).func_180463_a(dir.func_176734_d());
                    } else {
                        accessibleSlots = new int[inputInv.func_70302_i_()];
                        for (int i = 0; i < accessibleSlots.length; ++i) {
                            accessibleSlots[i] = i;
                        }
                    }
                    for (int slot : accessibleSlots) {
                        ItemStack stack = inputInv.func_70301_a(slot);
                        if (stack.func_190926_b() || !IOHelper.canExtractItemFromInventory(inputInv, stack, slot, dir.func_176734_d().ordinal()) || !this.tryProcessItem(stack, false)) continue;
                        if (stack.func_190916_E() == 0) {
                            inputInv.func_70299_a(slot, ItemStack.field_190927_a);
                        }
                        return;
                    }
                    if (this.sortMode != SortMode.ANYSTACK_SEQUENTIAL) break block9;
                    for (int i = this.curColumn; i < this.inventory.size(); i += 8) {
                        ItemStack extractedStack;
                        ItemStack filterStack = (ItemStack)this.inventory.get(i);
                        if (filterStack.func_190926_b() || (extractedStack = IOHelper.extract(inputTE, dir.func_176734_d(), filterStack, true, false)).func_190926_b()) continue;
                        this.addItemToOutputBuffer(extractedStack.func_77946_l(), this.colors[this.curColumn]);
                        this.gotoNextNonEmptyColumn();
                        break block8;
                    }
                    break block8;
                }
                if (this.sortMode != SortMode.ALLSTACK_SEQUENTIAL) break block10;
                if (!this.matchAndProcessColumn(inputInv, accessibleSlots, this.curColumn)) break block8;
                this.gotoNextNonEmptyColumn();
                break block8;
            }
            if (this.sortMode == SortMode.RANDOM_ALLSTACKS) {
                for (int i = 0; i < 8 && !this.matchAndProcessColumn(inputInv, accessibleSlots, i); ++i) {
                }
            }
        }
    }

    @Override
    public void onButtonPress(PlayerEntity player, int messageId, int value) {
        if (messageId < 0) {
            return;
        }
        if (messageId < 9) {
            this.colors[messageId] = IPneumaticTube.TubeColor.values()[value];
        } else if (messageId == 9) {
            this.pullMode = PullMode.values()[value];
        } else if (messageId == 10) {
            this.sortMode = SortMode.values()[value];
        } else {
            this.fuzzySettings[messageId - 11] = value;
        }
    }

    private boolean matchAndProcessColumn(IInventory inputInventory, int[] accessibleSlots, int column) {
        ArrayList<ItemStack> requirements = new ArrayList<ItemStack>();
        for (int i = 0; i < 5; ++i) {
            ItemStack filterStack = (ItemStack)this.inventory.get(column + 8 * i);
            if (filterStack.func_190926_b()) continue;
            boolean duplicate = false;
            for (ItemStack requirement : requirements) {
                if (!ItemStackHelper.areStacksEqual(requirement, filterStack, this.fuzzySettings[column])) continue;
                requirement.func_190920_e(requirement.func_190916_E() + filterStack.func_190916_E());
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            requirements.add(filterStack.func_77946_l());
        }
        if (requirements.size() == 0) {
            return false;
        }
        ItemStack[] copy = new ItemStack[requirements.size()];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = ((ItemStack)requirements.get(i)).func_77946_l();
        }
        Iterator iterator = requirements.iterator();
        block3: while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            for (Object slot : (Object)accessibleSlots) {
                ItemStack invStack = inputInventory.func_70301_a((int)slot);
                if (invStack.func_190926_b() || !ItemStackHelper.areStacksEqual(invStack, stack, this.fuzzySettings[column])) continue;
                stack.func_190920_e(stack.func_190916_E() - invStack.func_190916_E());
                if (stack.func_190916_E() > 0) continue;
                iterator.remove();
                continue block3;
            }
        }
        if (requirements.isEmpty()) {
            for (ItemStack stack : copy) {
                for (int slot : accessibleSlots) {
                    ItemStack invStack;
                    if (stack.func_190916_E() <= 0 || (invStack = inputInventory.func_70301_a(slot)) == ItemStack.field_190927_a || !ItemStackHelper.areStacksEqual(invStack, stack, this.fuzzySettings[column])) continue;
                    int substracted = Math.min(stack.func_190916_E(), invStack.func_190916_E());
                    stack.func_190920_e(stack.func_190916_E() - substracted);
                    invStack.func_190920_e(invStack.func_190916_E() - substracted);
                    if (invStack.func_190916_E() <= 0) {
                        inputInventory.func_70299_a(slot, ItemStack.field_190927_a);
                    }
                    ItemStack bufferStack = invStack.func_77946_l();
                    bufferStack.func_190920_e(substracted);
                    this.addItemToOutputBuffer(bufferStack, this.colors[column]);
                }
            }
            inputInventory.func_70296_d();
            return true;
        }
        return false;
    }

    private boolean tryProcessItem(ItemStack stack, boolean simulate) {
        switch (this.sortMode) {
            case ANYSTACK_SEQUENTIAL: {
                break;
            }
            case ALLSTACK_SEQUENTIAL: {
                break;
            }
            case RANDOM_ALLSTACKS: {
                break;
            }
            case ANY_ITEM: 
            case ANY_ITEM_DEFAULT: {
                for (int i = 0; i < this.inventory.size(); ++i) {
                    ItemStack filter = (ItemStack)this.inventory.get(i);
                    if (filter.func_190926_b() || !ItemStackHelper.areStacksEqual(filter, stack, this.fuzzySettings[i % 8]) || stack.func_190916_E() < filter.func_190916_E()) continue;
                    if (!simulate) {
                        ItemStack itemStack = stack.func_77946_l();
                        itemStack.func_190920_e(filter.func_190916_E());
                        this.addItemToOutputBuffer(itemStack, this.colors[i % 8]);
                    }
                    stack.func_190920_e(stack.func_190916_E() - filter.func_190916_E());
                    return true;
                }
                if (this.sortMode != SortMode.ANY_ITEM_DEFAULT) break;
                if (!simulate) {
                    this.addItemToOutputBuffer(stack.func_77946_l(), this.colors[8]);
                }
                stack.func_190920_e(0);
                return true;
            }
            case ANY_STACK: 
            case ANY_STACK_DEFAULT: {
                for (int i = 0; i < this.inventory.size(); ++i) {
                    ItemStack filter = (ItemStack)this.inventory.get(i);
                    if (filter.func_190926_b() || !ItemStackHelper.areStacksEqual(filter, stack, this.fuzzySettings[i % 8])) continue;
                    if (!simulate) {
                        this.addItemToOutputBuffer(stack.func_77946_l(), this.colors[i % 8]);
                    }
                    stack.func_190920_e(0);
                    return true;
                }
                if (this.sortMode != SortMode.ANY_STACK_DEFAULT) break;
                if (!simulate) {
                    this.addItemToOutputBuffer(stack.func_77946_l(), this.colors[8]);
                }
                stack.func_190920_e(0);
                return true;
            }
        }
        return false;
    }

    private void gotoNextNonEmptyColumn() {
        int oldColumn = this.curColumn++;
        if (this.curColumn > 7) {
            this.curColumn = 0;
            this.sweepTriggered = false;
        }
        while (oldColumn != this.curColumn) {
            for (int i = this.curColumn; i < this.inventory.size(); i += 8) {
                if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                return;
            }
            if (++this.curColumn <= 7) continue;
            this.curColumn = 0;
            this.sweepTriggered = false;
        }
        this.curColumn = 0;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("pullMode", (byte)this.pullMode.ordinal());
        tag.func_74774_a("sortMode", (byte)this.sortMode.ordinal());
        tag.func_74768_a("savedPulses", this.savedPulses);
        int[] colorArray = new int[this.colors.length];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = this.colors[i].ordinal();
        }
        tag.func_74783_a("colors", colorArray);
        tag.func_74783_a("fuzzySettings", this.fuzzySettings);
        ListNBT tagList = new ListNBT();
        for (int currentIndex = 0; currentIndex < this.inventory.size(); ++currentIndex) {
            if (((ItemStack)this.inventory.get(currentIndex)).func_190926_b()) continue;
            CompoundNBT tagCompound = new CompoundNBT();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            ((ItemStack)this.inventory.get(currentIndex)).func_77955_b(tagCompound);
            tagList.add((Object)tagCompound);
        }
        tag.func_218657_a("Items", (INBT)tagList);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.pullMode = PullMode.values()[tag.func_74771_c("pullMode")];
        this.sortMode = SortMode.values()[tag.func_74771_c("sortMode")];
        this.savedPulses = tag.func_74762_e("savedPulses");
        int[] colorArray = tag.func_74759_k("colors");
        for (int i = 0; i < colorArray.length; ++i) {
            this.colors[i] = IPneumaticTube.TubeColor.values()[colorArray[i]];
        }
        if (tag.func_74764_b("fuzzySettings")) {
            this.fuzzySettings = tag.func_74759_k("fuzzySettings");
        }
        ListNBT tagList = tag.func_150295_c("Items", 10);
        this.inventory = NonNullList.func_191197_a((int)40, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.size()) continue;
            this.inventory.set((int)slot, (Object)ItemStack.func_199557_a((CompoundNBT)tagCompound));
        }
    }

    public int func_70302_i_() {
        return this.inventory.size() + 1;
    }

    public boolean func_191420_l() {
        return this.inventory.size() == 0;
    }

    public ItemStack func_70301_a(int slot) {
        return slot < this.inventory.size() ? (ItemStack)this.inventory.get(slot) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (!itemStack.func_190926_b()) {
            if (itemStack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            } else if ((itemStack = itemStack.func_77979_a(amount)).func_190916_E() == 0) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (!itemStack.func_190926_b()) {
            this.func_70299_a(slot, ItemStack.field_190927_a);
        }
        return itemStack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (slot < this.inventory.size()) {
            this.inventory.set(slot, (Object)itemStack);
            if (!itemStack.func_190926_b() && itemStack.func_190916_E() > this.func_70297_j_()) {
                itemStack.func_190920_e(this.func_70297_j_());
            }
        } else if (!itemStack.func_190926_b()) {
            this.tryProcessItem(itemStack, false);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return player.func_233580_cy_().func_218141_a((Vector3i)this.field_174879_c, 64.0);
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return var1 < this.inventory.size() ? true : !var2.func_190926_b() && this.tryProcessItem(var2, true);
    }

    public void func_174888_l() {
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{this.inventory.size()};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return this.getOutputDirection().func_176734_d() == direction && this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    public static enum SortMode {
        ANYSTACK_SEQUENTIAL("any_stack_sequential"),
        ALLSTACK_SEQUENTIAL("all_stacks_sequential"),
        RANDOM_ALLSTACKS("all_stacks_random"),
        ANY_ITEM("any_item"),
        ANY_ITEM_DEFAULT("any_item_default"),
        ANY_STACK("any_stack"),
        ANY_STACK_DEFAULT("any_stack_default");

        private final String name;

        private SortMode(String name) {
            this.name = name;
        }

        public String toString() {
            return "gui.bluepower:sortingMachine.sortMode." + this.name;
        }
    }

    public static enum PullMode {
        SINGLE_STEP("single_step"),
        AUTOMATIC("automatic"),
        SINGLE_SWEEP("single_sweep");

        private final String name;

        private PullMode(String name) {
            this.name = name;
        }

        public String toString() {
            return "gui.bluepower:sortingMachine.pullMode." + this.name;
        }
    }
}

