/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.util;

import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class AABBUtils {
    public static AxisAlignedBB expand(AxisAlignedBB aabb, double amt) {
        return aabb.func_72321_a(amt, amt, amt);
    }

    public static AxisAlignedBB translate(AxisAlignedBB aabb, double x, double y, double z) {
        return aabb.func_72317_d(x, y, z);
    }

    public static AxisAlignedBB rotate(AxisAlignedBB aabb, Direction facing) {
        switch (facing) {
            case UP: {
                return aabb;
            }
            case DOWN: {
                return new AxisAlignedBB(aabb.field_72340_a, 1.0 - aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, 1.0 - aabb.field_72337_e, aabb.field_72334_f);
            }
            case EAST: {
                return new AxisAlignedBB(aabb.field_72338_b, 1.0 - aabb.field_72339_c, 1.0 - aabb.field_72340_a, aabb.field_72337_e, 1.0 - aabb.field_72334_f, 1.0 - aabb.field_72336_d);
            }
            case WEST: {
                return new AxisAlignedBB(1.0 - aabb.field_72338_b, 1.0 - aabb.field_72339_c, aabb.field_72340_a, 1.0 - aabb.field_72337_e, 1.0 - aabb.field_72334_f, aabb.field_72336_d);
            }
            case NORTH: {
                return new AxisAlignedBB(1.0 - aabb.field_72340_a, 1.0 - aabb.field_72339_c, 1.0 - aabb.field_72338_b, 1.0 - aabb.field_72336_d, 1.0 - aabb.field_72334_f, 1.0 - aabb.field_72337_e);
            }
            case SOUTH: {
                return new AxisAlignedBB(aabb.field_72340_a, 1.0 - aabb.field_72339_c, aabb.field_72338_b, aabb.field_72336_d, 1.0 - aabb.field_72334_f, aabb.field_72337_e);
            }
        }
        return aabb;
    }

    public static Boolean testOcclusion(VoxelShape shape1, VoxelShape shape2) {
        return shape1.func_197756_d().stream().anyMatch(s -> shape2.func_197756_d().stream().anyMatch(arg_0 -> ((AxisAlignedBB)s).func_72326_a(arg_0)));
    }

    public static VoxelShape rotate(VoxelShape shape, Direction facing) {
        VoxelShape out = VoxelShapes.func_197880_a();
        for (AxisAlignedBB aabb : shape.func_197756_d()) {
            aabb = AABBUtils.rotate(aabb, facing);
            out = VoxelShapes.func_197872_a((VoxelShape)out, (VoxelShape)Block.func_208617_a((double)(aabb.field_72340_a * 16.0), (double)(aabb.field_72338_b * 16.0), (double)(aabb.field_72339_c * 16.0), (double)(aabb.field_72336_d * 16.0), (double)(aabb.field_72337_e * 16.0), (double)(aabb.field_72334_f * 16.0)));
        }
        return out;
    }
}

