/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.util;

import com.bluepowermod.tile.TileBPMultipart;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.Pair;

public class MultipartUtils {
    public static Pair<Vector3d, Vector3d> getRayTraceVectors(Entity entity) {
        float pitch = entity.field_70125_A;
        float yaw = entity.field_70177_z;
        Vector3d start = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
        float f1 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = f2 * f3;
        float f6 = f1 * f3;
        double d3 = 5.0;
        if (entity instanceof ServerPlayerEntity) {
            d3 = ((ServerPlayerEntity)entity).func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        }
        Vector3d end = start.func_72441_c((double)f5 * d3, (double)f4 * d3, (double)f6 * d3);
        return Pair.of((Object)start, (Object)end);
    }

    @Nullable
    public static BlockState getClosestState(Entity entity, BlockPos pos) {
        Pair<Vector3d, Vector3d> lookVec = MultipartUtils.getRayTraceVectors(entity);
        return MultipartUtils.getClosestState(entity.field_70170_p, (Vector3d)lookVec.getLeft(), (Vector3d)lookVec.getRight(), pos);
    }

    @Nullable
    public static BlockState getClosestState(World world, Vector3d start, Vector3d end, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        BlockState state = null;
        double distance = Double.POSITIVE_INFINITY;
        if (te instanceof TileBPMultipart) {
            for (BlockState part : ((TileBPMultipart)te).getStates()) {
                double partDistance;
                BlockRayTraceResult res = part.func_199611_f((IBlockReader)world, pos, ISelectionContext.func_216377_a()).func_212433_a(start, end, pos);
                if (res == null || !(distance > (partDistance = start.func_72436_e(res.func_216347_e())))) continue;
                distance = partDistance;
                state = part;
            }
        }
        return state;
    }
}

