/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.world;

import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPConfig;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldGenFlowers {
    public static void initFlowers() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            int n = WorldGenFlowers.getConfigAmount(biome.getRegistryName());
            if (n <= 0) continue;
            BlockClusterFeatureConfig featureConfig = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(BPBlocks.indigo_flower.func_176223_P(), 2), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
            Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)("bluepower:indigo_flower" + n), (Object)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)featureConfig).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242729_a(n));
        }
    }

    @SubscribeEvent
    public void onBiomeLoad(BiomeLoadingEvent event) {
        int n = WorldGenFlowers.getConfigAmount(event.getName());
        if (n > 0) {
            BiomeGenerationSettingsBuilder generation = event.getGeneration();
            ConfiguredFeature feature = (ConfiguredFeature)WorldGenRegistries.field_243653_e.func_82594_a(new ResourceLocation("bluepower:indigo_flower" + n));
            if (feature != null) {
                generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, feature);
            }
        }
    }

    static int getConfigAmount(ResourceLocation biome) {
        int n = 0;
        if (biome.equals((Object)Biomes.field_150583_P.func_240901_a_())) {
            n = (Integer)BPConfig.CONFIG.flowerSpawnChance.get();
        } else if (biome.equals((Object)Biomes.field_150582_Q.func_240901_a_())) {
            n = (Integer)BPConfig.CONFIG.flowerSpawnChance.get();
        } else if (biome.equals((Object)Biomes.field_76772_c.func_240901_a_())) {
            n = (Integer)BPConfig.CONFIG.flowerSpawnChance.get();
        } else if (biome.equals((Object)Biomes.field_76767_f.func_240901_a_())) {
            n = 2 * (Integer)BPConfig.CONFIG.flowerSpawnChance.get();
        } else if (biome.equals((Object)Biomes.field_150585_R.func_240901_a_())) {
            n = 2 * (Integer)BPConfig.CONFIG.flowerSpawnChance.get();
        }
        return n;
    }
}

