/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo;

import java.util.Random;
import java.util.Vector;
import net.minecraft.block.AbstractGlassBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import net.nicguzzo.SendBlockPlaced;
import net.nicguzzo.WandItemForge;
import net.nicguzzo.WandsMod;
import net.nicguzzo.WandsPacketHandler;
import net.nicguzzo.common.ICompatMod;
import net.nicguzzo.common.MyDir;
import net.nicguzzo.common.WandItem;

public class ICompatModImpl
implements ICompatMod {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public PlayerEntity get_player() {
        assert (Minecraft.func_71410_x().field_71439_g != null);
        Minecraft instance = Minecraft.func_71410_x();
        return instance.field_71439_g;
    }

    @Override
    public boolean is_fluid(BlockState state, WandItem wand) {
        if (wand != null) {
            if (wand.removes_water && wand.removes_lava) {
                return state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a) || state.func_204520_s().func_206884_a((ITag)FluidTags.field_206960_b);
            }
            if (wand.removes_water) {
                return state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
            }
        }
        return false;
    }

    @Override
    public boolean is_double_slab(BlockState state) {
        if (state.func_177230_c() instanceof SlabBlock) {
            return state.func_177229_b((Property)SlabBlock.field_196505_a) != SlabType.DOUBLE;
        }
        return false;
    }

    @Override
    public BlockPos pos_offset(BlockPos pos, MyDir dir, int o) {
        Direction dir1 = Direction.values()[dir.ordinal()];
        return new BlockPos(pos.func_177958_n() + dir1.func_82601_c() * o, pos.func_177956_o() + dir1.func_96559_d() * o, pos.func_177952_p() + dir1.func_82599_e() * o);
    }

    @Override
    public int get_next_int_random(PlayerEntity player, int b) {
        return player.field_70170_p.field_73012_v.nextInt(b);
    }

    @Override
    public BlockState random_rotate(BlockState state, World world) {
        return state.rotate((IWorld)world, null, Rotation.func_222466_a((Random)world.field_73012_v));
    }

    @Override
    public int get_main_inventory_size(PlayerEntity player) {
        return player.field_71071_by.field_70462_a.size();
    }

    @Override
    public ItemStack get_player_main_stack(PlayerEntity player, int i) {
        return (ItemStack)player.field_71071_by.field_70462_a.get(i);
    }

    @Override
    public ItemStack get_player_offhand_stack(PlayerEntity player) {
        return (ItemStack)player.field_71071_by.field_184439_c.get(0);
    }

    @Override
    public void player_offhand_stack_inc(PlayerEntity player, int i) {
        ((ItemStack)player.field_71071_by.field_184439_c.get(0)).func_190917_f(i);
    }

    @Override
    public void player_offhand_stack_dec(PlayerEntity player, int i) {
        ((ItemStack)player.field_71071_by.field_184439_c.get(0)).func_190918_g(i);
    }

    @Override
    public void player_stack_inc(PlayerEntity player, int slot, int i) {
        ((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_190917_f(i);
    }

    @Override
    public void player_stack_dec(PlayerEntity player, int slot, int i) {
        ((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_190918_g(i);
    }

    @Override
    public void set_player_xp(PlayerEntity player, float xp) {
        player.field_71106_cc = xp;
    }

    @Override
    public boolean item_stacks_equal(ItemStack i1, ItemStack i2) {
        return ItemStack.func_77970_a((ItemStack)i1, (ItemStack)i2);
    }

    @Override
    public boolean is_player_holding_wand(PlayerEntity player) {
        if (player.field_71071_by.func_70448_g() != null) {
            return player.field_71071_by.func_70448_g().func_77973_b() instanceof WandItemForge;
        }
        return false;
    }

    @Override
    public WandItem get_player_wand(PlayerEntity player) {
        if (this.is_player_holding_wand(player)) {
            return ((WandItemForge)player.field_71071_by.func_70448_g().func_77973_b()).wand;
        }
        return null;
    }

    @Override
    public void inc_wand_damage(PlayerEntity player, ItemStack stack, int damage) {
        stack.func_222118_a(damage, (LivingEntity)player, p -> p.func_213334_d(Hand.MAIN_HAND));
    }

    @Override
    public boolean interescts_player_bb(PlayerEntity player, double x1, double y1, double z1, double x2, double y2, double z2) {
        AxisAlignedBB bb = player.func_174813_aQ();
        return bb.func_186668_a(x1, y1, z1, x2, y2, z2);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void send_message_to_player(String msg) {
        assert (Minecraft.func_71410_x().field_71439_g != null);
        Minecraft instance = Minecraft.func_71410_x();
        instance.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent(msg), true);
    }

    @Override
    public boolean is_plant(BlockState state) {
        return state.func_177230_c() instanceof BushBlock;
    }

    @Override
    public boolean is_shulker(PlayerEntity player, ItemStack item_stack) {
        ItemStack offhand = this.get_player_offhand_stack(player);
        Block blk = this.block_from_item(offhand.func_77973_b());
        return offhand != null && blk instanceof ShulkerBoxBlock;
    }

    @Override
    public int in_shulker(PlayerEntity player, ItemStack item_stack) {
        ItemStack shulker;
        CompoundNBT entity_tag;
        ListNBT shulker_items = null;
        int in_shulker = 0;
        if (this.is_shulker(player, item_stack) && (entity_tag = (shulker = WandsMod.compat.get_player_offhand_stack(player)).func_179543_a("BlockEntityTag")) != null && (shulker_items = entity_tag.func_150295_c("Items", 10)) != null) {
            int len = shulker_items.size();
            for (int i = 0; i < len; ++i) {
                CompoundNBT itemTag = shulker_items.func_150305_b(i);
                ItemStack s = ItemStack.func_199557_a((CompoundNBT)itemTag);
                if (WandItem.fill_pos1 != null) {
                    Item it = Item.field_179220_a.getOrDefault(WandItem.fill_pos1, Items.field_190931_a);
                    if (s.func_77973_b() != it) continue;
                    in_shulker += s.func_190916_E();
                    continue;
                }
                if (s.func_77973_b() != item_stack.func_77973_b()) continue;
                in_shulker += s.func_190916_E();
            }
        }
        return in_shulker;
    }

    @Override
    public int in_shulker_slot(PlayerEntity player, ItemStack item_stack, BlockState state) {
        CompoundNBT entity_tag = item_stack.func_179543_a("BlockEntityTag");
        ListNBT shulker_items = entity_tag.func_150295_c("Items", 10);
        if (shulker_items != null) {
            int len = shulker_items.size();
            for (int i = 0; i < len; ++i) {
                CompoundNBT itemTag = shulker_items.func_150305_b(i);
                ItemStack s = ItemStack.func_199557_a((CompoundNBT)itemTag);
                Block b = Block.func_149634_a((Item)s.func_77973_b());
                if (b == null || b != state.func_177230_c()) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Vector<Integer> shulker_slots(PlayerEntity player, ItemStack item_stack) {
        Vector<Integer> slots = new Vector<Integer>();
        CompoundNBT entity_tag = item_stack.func_179543_a("BlockEntityTag");
        ListNBT shulker_items = entity_tag.func_150295_c("Items", 10);
        int len = shulker_items.size();
        for (int i = 0; i < len; ++i) {
            CompoundNBT itemTag = shulker_items.func_150305_b(i);
            ItemStack s = ItemStack.func_199557_a((CompoundNBT)itemTag);
            if (Block.func_149634_a((Item)s.func_77973_b()) == null) continue;
            slots.add(i);
        }
        return slots;
    }

    @Override
    public ItemStack item_from_shulker(ItemStack shulker, int slot) {
        ItemStack stack_item = null;
        CompoundNBT entity_tag = shulker.func_179543_a("BlockEntityTag");
        ListNBT shulker_items = entity_tag.func_150295_c("Items", 10);
        CompoundNBT itemTag = shulker_items.func_150305_b(slot);
        stack_item = ItemStack.func_199557_a((CompoundNBT)itemTag);
        return stack_item;
    }

    @Override
    public void remove_item_from_shulker(ItemStack shulker, int slot, int n) {
        ItemStack stack_item = null;
        CompoundNBT entity_tag = shulker.func_179543_a("BlockEntityTag");
        ListNBT shulker_items = entity_tag.func_150295_c("Items", 10);
        CompoundNBT itemTag = shulker_items.func_150305_b(slot);
        stack_item = ItemStack.func_199557_a((CompoundNBT)itemTag);
        if (stack_item != null && stack_item.func_190916_E() > 0) {
            stack_item.func_190920_e(stack_item.func_190916_E() - n);
            shulker_items.func_218659_a(slot, (INBT)stack_item.func_77955_b(itemTag));
        }
    }

    @Override
    public void send_xp_to_player(PlayerEntity player) {
    }

    @Override
    public Block block_from_item(Item it) {
        return Block.func_149634_a((Item)it);
    }

    @Override
    public World world(PlayerEntity player) {
        return player.field_70170_p;
    }

    @Override
    public BlockState getDefaultBlockState(Block b) {
        return b.func_176223_P();
    }

    @Override
    public boolean setBlockState(World w, BlockPos p, BlockState s) {
        return w.func_175656_a(p, s);
    }

    @Override
    public BlockState with_snow_layers(Block block, int n) {
        return (BlockState)WandsMod.compat.getDefaultBlockState(block).func_206870_a((Property)SnowBlock.field_176315_a, (Comparable)Integer.valueOf(n));
    }

    @Override
    public int in_inventory(PlayerEntity player, ItemStack item_stack) {
        return player.field_71071_by.func_213901_a(item_stack.func_77973_b());
    }

    @Override
    public boolean has_tag(ItemStack item_stack) {
        return item_stack.func_77978_p() != null;
    }

    @Override
    public boolean can_destroy(BlockState block_state, ItemStack offhand, boolean isCreative) {
        boolean destroy = false;
        boolean is_glass = block_state.func_177230_c() instanceof AbstractGlassBlock;
        if (offhand.func_77973_b() instanceof ToolItem) {
            ToolItem mt = (ToolItem)offhand.func_77973_b();
            destroy = isCreative || mt.func_150893_a(null, block_state) > 1.0f | is_glass;
        }
        return destroy;
    }

    @Override
    public String get_player_uuid(PlayerEntity player) {
        return player.func_189512_bd();
    }

    @Override
    public boolean destroy_block(World world, BlockPos pos, boolean drop) {
        return world.func_175655_b(pos, drop);
    }

    @Override
    public int get_silk_touch_level(ItemStack item) {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)item);
    }

    @Override
    public int get_fortune_level(ItemStack item) {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)item);
    }

    @Override
    public void dropStacks(BlockState state, World world, BlockPos pos) {
        Block.func_220075_c((BlockState)state, (World)world, (BlockPos)pos);
    }

    @Override
    public void dropStack(World world, BlockPos pos, ItemStack item_stack) {
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)item_stack);
    }

    @Override
    public void playBlockSound(PlayerEntity player, BlockState block_state, BlockPos pos, boolean destroy) {
        player = this.get_player();
        SoundType soundtype = block_state.func_215695_r();
        SoundEvent sound = null;
        sound = destroy ? soundtype.func_185845_c() : soundtype.func_185841_e();
        player.field_70170_p.func_184133_a(player, pos, sound, SoundCategory.BLOCKS, soundtype.func_185843_a(), soundtype.func_185847_b());
    }

    @Override
    public Block block_from_id(String id) {
        return (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.func_208304_a((String)id));
    }

    @Override
    public void send_block_placed(PlayerEntity player, BlockPos pos, boolean destroy) {
        WandsPacketHandler.INSTANCE.sendTo((Object)new SendBlockPlaced(pos, destroy), ((ServerPlayerEntity)player).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
    }
}

