/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.common;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.nicguzzo.WandsMod;
import net.nicguzzo.common.MyDir;

public abstract class WandItem {
    private int limit = 0;
    public int limit2 = 0;
    public int x0 = 0;
    public static BlockState fill1_state = null;
    public static BlockState last_state = null;
    private static int mode = 0;
    private static PaletteMode palette_mode = PaletteMode.SAME;
    private static boolean invert = false;
    public boolean removes_water;
    public boolean removes_lava;
    private static Orientation orientation = Orientation.HORIZONTAL;
    private static Plane plane = Plane.XZ;
    public static int x1;
    public static int y1;
    public static int z1;
    public static int x2;
    public static int y2;
    public static int z2;
    public static BlockPos fill_pos1;
    public static boolean valid;
    public static MyDir side;

    public WandItem(int lim, boolean removes_water, boolean removes_lava) {
        this.limit = lim;
        this.limit2 = (int)Math.floor(Math.sqrt(lim));
        this.x0 = this.limit2 / 2;
        this.removes_water = removes_water;
        this.removes_lava = removes_lava;
    }

    public static int getMode() {
        return mode;
    }

    public static PaletteMode getPaletteMode() {
        return palette_mode;
    }

    public static boolean getInvert() {
        return invert;
    }

    public static void toggleInvert() {
        String state = "off";
        boolean bl = invert = !invert;
        if (invert) {
            state = "on";
        }
        WandsMod.compat.send_message_to_player("Wand inverted " + state);
    }

    public static void cyclePalleteMode() {
        String state = "";
        switch (palette_mode) {
            case SAME: {
                palette_mode = PaletteMode.RANDOM;
                state = "random";
                break;
            }
            case RANDOM: {
                palette_mode = PaletteMode.ROUND_ROBIN;
                state = "round robin";
                break;
            }
            case ROUND_ROBIN: {
                palette_mode = PaletteMode.SAME;
                state = "same";
            }
        }
        WandsMod.compat.send_message_to_player("Wand palette mode " + state);
    }

    public int getLimit() {
        return this.limit;
    }

    public static Orientation getOrientation() {
        return orientation;
    }

    public static Plane getPlane() {
        return plane;
    }

    public static void cycleOrientation() {
        if (mode == 5) {
            int p = (plane.ordinal() + 1) % 3;
            plane = Plane.values()[p];
            WandsMod.compat.send_message_to_player("Wand circle plane: " + (Object)((Object)plane));
        } else {
            int o = (orientation.ordinal() + 1) % 2;
            orientation = Orientation.values()[o];
            WandsMod.compat.send_message_to_player("Wand orientation: " + (Object)((Object)orientation));
        }
    }

    public static void cycleMode() {
        mode = (mode + 1) % 6;
        switch (mode) {
            case 0: {
                WandsMod.compat.send_message_to_player("Wand mode 0 - Direccion from block");
                break;
            }
            case 1: {
                WandsMod.compat.send_message_to_player("Wand mode 1 - Row/Column");
                break;
            }
            case 2: {
                WandsMod.compat.send_message_to_player("Wand mode 2 - Fill between corners");
                break;
            }
            case 3: {
                WandsMod.compat.send_message_to_player("Wand mode 3 - Fill Area");
                break;
            }
            case 4: {
                WandsMod.compat.send_message_to_player("Wand mode 4 - Line");
                break;
            }
            case 5: {
                WandsMod.compat.send_message_to_player("Wand mode 5 - Circle");
            }
        }
    }

    public abstract boolean placeBlock(BlockPos var1, BlockPos var2, BlockPos var3);

    public abstract boolean isCreative(PlayerEntity var1);

    public abstract boolean isClient(World var1);

    public abstract boolean playerInvContains(PlayerEntity var1, ItemStack var2);

    public void right_click_use(World world) {
        if (this.isClient(world)) {
            fill_pos1 = null;
            fill1_state = null;
            WandsMod.compat.send_message_to_player("wand reset, mode: " + mode + " palette_mode: " + (Object)((Object)palette_mode));
        }
    }

    public boolean right_click_use_on_block(PlayerEntity player, World world, BlockPos pos_state) {
        if (!this.isClient(world)) {
            return false;
        }
        if (!valid) {
            fill_pos1 = null;
            fill1_state = null;
            return false;
        }
        BlockState block_state = world.func_180495_p(pos_state);
        ItemStack item_stack = null;
        item_stack = (mode == 4 || mode == 5) && fill1_state != null ? new ItemStack((IItemProvider)fill1_state.func_177230_c()) : new ItemStack((IItemProvider)block_state.func_177230_c());
        ItemStack offhand = WandsMod.compat.get_player_offhand_stack(player);
        boolean destroy = WandsMod.compat.can_destroy(block_state, offhand, this.isCreative(player));
        boolean mm = palette_mode != PaletteMode.SAME && (mode == 2 || mode == 4 || mode == 5);
        int in_shulker = WandsMod.compat.in_shulker(player, item_stack);
        if (this.playerInvContains(player, item_stack) || this.isCreative(player) || mm || in_shulker > 0 || fill_pos1 != null || destroy) {
            BlockPos pos0 = new BlockPos(x1, y1, z1);
            BlockPos pos1 = new BlockPos(x1, y1, z1);
            switch (mode) {
                case 0: {
                    fill_pos1 = null;
                    last_state = block_state;
                    this.placeBlock(pos_state, pos0, pos1);
                    break;
                }
                case 1: {
                    fill_pos1 = null;
                    last_state = block_state;
                    this.placeBlock(pos_state, new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2));
                    break;
                }
                case 2: {
                    if (fill_pos1 == null) {
                        last_state = block_state;
                        fill_pos1 = pos_state;
                        fill1_state = block_state;
                        x1 = pos_state.func_177958_n();
                        y1 = pos_state.func_177956_o();
                        z1 = pos_state.func_177952_p();
                        WandsMod.compat.send_message_to_player("from " + pos_state);
                        break;
                    }
                    if (fill_pos1 != pos_state) {
                        x2 = pos_state.func_177958_n();
                        y2 = pos_state.func_177956_o();
                        z2 = pos_state.func_177952_p();
                        x2 = x1 < x2 ? ++x2 : --x2;
                        y2 = y1 < y2 ? ++y2 : --y2;
                        z2 = z1 < z2 ? ++z2 : --z2;
                        BlockPos fill_pos2 = new BlockPos(x2, y2, z2);
                        this.placeBlock(fill_pos1, fill_pos1, fill_pos2);
                        WandsMod.compat.send_message_to_player("filled from " + fill_pos1 + " to " + fill_pos2);
                    }
                    fill_pos1 = null;
                    break;
                }
                case 3: {
                    last_state = block_state;
                    this.placeBlock(pos_state, pos0, pos0);
                    break;
                }
                case 4: {
                    if (fill_pos1 == null) {
                        fill_pos1 = pos_state;
                        fill1_state = block_state;
                        last_state = block_state;
                        WandsMod.compat.send_message_to_player("line from " + pos_state);
                        break;
                    }
                    this.placeBlock(fill_pos1, fill_pos1, pos_state);
                    WandsMod.compat.send_message_to_player("line from " + fill_pos1 + " to " + pos_state);
                    fill_pos1 = null;
                    break;
                }
                case 5: {
                    if (fill_pos1 == null) {
                        last_state = block_state;
                        fill_pos1 = pos_state;
                        fill1_state = block_state;
                        WandsMod.compat.send_message_to_player("circle from " + pos_state);
                        break;
                    }
                    this.placeBlock(fill_pos1, fill_pos1, pos_state);
                    WandsMod.compat.send_message_to_player("circle from " + fill_pos1 + " to " + pos_state);
                    fill_pos1 = null;
                }
            }
        }
        return true;
    }

    public static float calc_xp(int level, float prog) {
        float xp = WandItem.calc_xp_level(level);
        if (prog > 0.0f) {
            xp += prog * (WandItem.calc_xp_level(level + 1) - xp);
        }
        return xp;
    }

    public static float calc_xp_level(int level) {
        float xp_points = 0.0f;
        int level2 = level * level;
        xp_points = level >= 32 ? 4.5f * (float)level2 - 162.5f * (float)level + 2220.0f : (level >= 17 ? 2.5f * (float)level2 - 40.5f * (float)level + 360.0f : (float)(level2 + 6 * level));
        return xp_points;
    }

    public static int calc_xp_to_next_level(int level) {
        int xp = 0;
        xp = level >= 32 ? 9 * level - 158 : (level >= 17 ? 5 * level - 38 : 2 * level + 7);
        return xp;
    }

    static {
        valid = false;
    }

    public static enum PaletteMode {
        SAME,
        RANDOM,
        ROUND_ROBIN;

    }

    public static enum Plane {
        XZ,
        XY,
        YZ;

    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

