/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.common;

import java.util.HashMap;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.nicguzzo.WandsMod;
import net.nicguzzo.common.CircularBuffer;
import net.nicguzzo.common.MyDir;
import net.nicguzzo.common.WandItem;
import net.nicguzzo.common.WandsBaseRenderer;

public class WandServerSide {
    private static final int MAX_UNDO = 2048;
    public static HashMap<String, CircularBuffer> player_undo = new HashMap();
    public int slt;
    public PlayerEntity player;
    public Vector<Integer> slots;
    public BlockState state;
    public BlockPos pos_state;
    public BlockPos pos0;
    public BlockPos pos1;
    public WandItem.PaletteMode palatte_mode;
    public boolean isCreative;
    public float experienceProgress;
    public ItemStack wand_stack;
    public ItemStack shulker = null;
    public boolean destroy = false;
    public int mode;
    public int plane;
    public World world;
    public MyDir side;
    ItemStack offhand;
    float BLOCKS_PER_XP;

    public WandServerSide(World world, PlayerEntity player, BlockPos pos_state, BlockPos pos0, BlockPos pos1, int palatte_mode, boolean isCreative, float experienceProgress, ItemStack wand_stack, int mode, int plane, MyDir side) {
        this.BLOCKS_PER_XP = WandsMod.config.blocks_per_xp;
        this.slots = new Vector();
        this.player = player;
        this.world = world;
        this.pos0 = pos0;
        this.pos1 = pos1;
        this.palatte_mode = WandItem.PaletteMode.values()[palatte_mode];
        this.state = world.func_180495_p(pos_state);
        this.isCreative = isCreative;
        this.experienceProgress = experienceProgress;
        this.wand_stack = wand_stack;
        this.mode = mode;
        this.plane = plane;
        this.side = side;
        this.pos_state = pos_state;
        System.out.println("state " + this.state);
        this.offhand = WandsMod.compat.get_player_offhand_stack(player);
        this.destroy = WandsMod.compat.can_destroy(this.state, this.offhand, isCreative);
        if (!this.destroy) {
            if (WandsMod.compat.is_shulker(player, this.offhand)) {
                this.shulker = this.offhand;
            }
            if (this.mode < 2 || this.palatte_mode == WandItem.PaletteMode.SAME) {
                int sl;
                if (this.shulker != null && (sl = WandsMod.compat.in_shulker_slot(player, this.shulker, this.state)) != -1) {
                    this.slots.add(sl);
                }
            } else if (this.palatte_mode == WandItem.PaletteMode.RANDOM || this.palatte_mode == WandItem.PaletteMode.ROUND_ROBIN) {
                if (this.shulker != null) {
                    this.slots = WandsMod.compat.shulker_slots(player, this.shulker);
                } else {
                    for (int i = 0; i < WandsMod.compat.get_main_inventory_size(player); ++i) {
                        ItemStack stack2 = WandsMod.compat.get_player_main_stack(player, i);
                        Block blk = WandsMod.compat.block_from_item(stack2.func_77973_b());
                        if (blk == null || blk == Blocks.field_150350_a || blk instanceof ShulkerBoxBlock || WandsMod.compat.has_tag(stack2)) continue;
                        this.slots.add(i);
                    }
                }
            }
        }
    }

    public void placeBlock() {
        System.out.println("placeBlock");
        System.out.println("pos_state " + this.pos_state);
        System.out.println("pos0 " + this.pos0);
        System.out.println("pos1 " + this.pos1);
        boolean placed = false;
        if (this.mode == 0 && this.pos0.equals((Object)this.pos1)) {
            placed = this.place(this.pos0);
        } else if (this.mode == 3) {
            WandItem wand = WandsMod.compat.get_player_wand(this.player);
            WandsBaseRenderer.BlockBuffer bb = new WandsBaseRenderer.BlockBuffer(wand.getLimit());
            WandsBaseRenderer.mode3(bb, wand, this.pos_state, this.state, this.world, this.side, this.destroy);
            System.out.println("length " + bb.length);
            for (int a = 0; a < bb.length; ++a) {
                BlockPos p = bb.buffer[a];
                placed = this.place(p) || placed;
            }
        } else {
            int ze;
            int zs;
            int ye;
            int ys;
            int xe;
            int xs;
            if (this.pos0.func_177958_n() >= this.pos1.func_177958_n()) {
                xs = this.pos1.func_177958_n() + 1;
                xe = this.pos0.func_177958_n() + 1;
            } else {
                xs = this.pos0.func_177958_n();
                xe = this.pos1.func_177958_n();
            }
            if (this.pos0.func_177956_o() >= this.pos1.func_177956_o()) {
                ys = this.pos1.func_177956_o() + 1;
                ye = this.pos0.func_177956_o() + 1;
            } else {
                ys = this.pos0.func_177956_o();
                ye = this.pos1.func_177956_o();
            }
            if (this.pos0.func_177952_p() >= this.pos1.func_177952_p()) {
                zs = this.pos1.func_177952_p() + 1;
                ze = this.pos0.func_177952_p() + 1;
            } else {
                zs = this.pos0.func_177952_p();
                ze = this.pos1.func_177952_p();
            }
            if (this.mode == 4) {
                placed = this.line();
            } else if (this.mode == 5) {
                placed = this.circle();
            } else {
                for (int z = zs; z < ze; ++z) {
                    for (int y = ys; y < ye; ++y) {
                        for (int x = xs; x < xe; ++x) {
                            placed = this.place(new BlockPos(x, y, z));
                        }
                    }
                }
            }
        }
        this.slots = null;
        if (placed) {
            WandsMod.compat.send_block_placed(this.player, this.pos_state, this.destroy);
        }
    }

    int nextSlot() {
        if (this.palatte_mode == WandItem.PaletteMode.RANDOM) {
            this.slt = WandsMod.compat.get_next_int_random(this.player, this.slots.size());
        } else if (this.palatte_mode == WandItem.PaletteMode.ROUND_ROBIN) {
            this.slt = (this.slt + 1) % this.slots.size();
        }
        return this.slt;
    }

    public static void undo(PlayerEntity player, int n) {
        CircularBuffer u = player_undo.get(WandsMod.compat.get_player_uuid(player));
        if (u != null) {
            for (int i = 0; i < n && i < u.size(); ++i) {
                CircularBuffer.P p = u.pop();
                if (p == null) continue;
                if (!p.destroyed) {
                    WandsMod.compat.setBlockState(WandsMod.compat.world(player), p.pos, WandsMod.compat.getDefaultBlockState(Blocks.field_150350_a));
                    continue;
                }
                WandsMod.compat.setBlockState(WandsMod.compat.world(player), p.pos, p.state);
            }
        }
    }

    public static void redo(PlayerEntity player, int n) {
        CircularBuffer u = player_undo.get(WandsMod.compat.get_player_uuid(player));
        if (u != null) {
            for (int i = 0; i < n && u.can_go_forward(); ++i) {
                u.forward();
                CircularBuffer.P p = u.peek();
                if (p == null || p.pos == null || p.state == null) continue;
                if (!p.destroyed) {
                    WandsMod.compat.setBlockState(WandsMod.compat.world(player), p.pos, p.state);
                    continue;
                }
                WandsMod.compat.setBlockState(WandsMod.compat.world(player), p.pos, WandsMod.compat.getDefaultBlockState(Blocks.field_150350_a));
            }
        }
    }

    private boolean place(BlockPos pos) {
        boolean placed = false;
        ItemStack item_stack = null;
        Block blk = null;
        if (this.slots.size() > 0) {
            if (this.mode != 0) {
                this.nextSlot();
            }
            item_stack = this.shulker != null ? WandsMod.compat.item_from_shulker(this.shulker, this.slots.get(this.slt)) : WandsMod.compat.get_player_main_stack(this.player, this.slots.get(this.slt));
        }
        if (item_stack == null) {
            item_stack = new ItemStack((IItemProvider)this.state.func_177230_c());
        }
        if ((blk = WandsMod.compat.block_from_item(item_stack.func_77973_b())) != null && this.palatte_mode == WandItem.PaletteMode.RANDOM) {
            this.state = WandsMod.compat.random_rotate(WandsMod.compat.getDefaultBlockState(blk), this.world);
        }
        System.out.println("destroy " + this.destroy);
        Block block = this.state.func_177230_c();
        BlockState state2 = this.world.func_180495_p(pos);
        int d = 1;
        WandItem wand = WandsMod.compat.get_player_wand(this.player);
        if (this.destroy || WandsBaseRenderer.can_place(state2, wand, this.world, pos)) {
            int slot = -1;
            if (block instanceof PaneBlock || block instanceof FenceBlock) {
                this.state = WandsMod.compat.getDefaultBlockState(this.state.func_177230_c());
            } else if (block instanceof SlabBlock && WandsMod.compat.is_double_slab(this.state)) {
                d = 2;
            }
            if (this.palatte_mode == WandItem.PaletteMode.RANDOM && block instanceof SnowBlock) {
                d = WandsMod.compat.get_next_int_random(this.player, 7) + 1;
                this.state = WandsMod.compat.with_snow_layers(block, d);
            }
            if (this.isCreative) {
                if (player_undo.get(WandsMod.compat.get_player_uuid(this.player)) == null) {
                    player_undo.put(WandsMod.compat.get_player_uuid(this.player), new CircularBuffer(2048));
                }
                CircularBuffer u = player_undo.get(WandsMod.compat.get_player_uuid(this.player));
                u.put(pos, this.state, this.destroy);
                placed = this.destroy ? WandsMod.compat.destroy_block(this.world, pos, false) : WandsMod.compat.setBlockState(this.world, pos, this.state);
            } else {
                float xp = WandItem.calc_xp(this.player.field_71068_ca, this.experienceProgress);
                float dec = 0.0f;
                if (this.BLOCKS_PER_XP != 0.0f) {
                    dec = 1.0f / this.BLOCKS_PER_XP;
                }
                if (this.BLOCKS_PER_XP == 0.0f || xp - dec > 0.0f) {
                    if (this.destroy) {
                        placed = WandsMod.compat.destroy_block(this.world, pos, false);
                        if (placed && WandsMod.config.destroy_in_survival_drop) {
                            int silk_touch = WandsMod.compat.get_silk_touch_level(this.offhand);
                            int fortune = WandsMod.compat.get_fortune_level(this.offhand);
                            if (fortune == 3) {
                                WandsMod.compat.dropStacks(this.state, this.world, pos);
                            }
                            if (silk_touch > 0) {
                                WandsMod.compat.dropStack(this.world, pos, item_stack);
                            }
                        }
                    } else if (this.shulker != null && this.slots.size() > 0) {
                        placed = WandsMod.compat.setBlockState(this.world, pos, this.state);
                        if (placed) {
                            WandsMod.compat.remove_item_from_shulker(this.shulker, this.slots.get(this.slt), d);
                        }
                    } else {
                        ItemStack off_hand_stack = WandsMod.compat.get_player_offhand_stack(this.player);
                        if (!off_hand_stack.func_190926_b() && item_stack.func_77973_b() == off_hand_stack.func_77973_b() && off_hand_stack.func_190916_E() >= d) {
                            placed = WandsMod.compat.setBlockState(this.world, pos, this.state);
                            if (placed) {
                                WandsMod.compat.player_offhand_stack_dec(this.player, d);
                            }
                        } else {
                            for (int i = 0; i < WandsMod.compat.get_main_inventory_size(this.player); ++i) {
                                ItemStack stack2 = WandsMod.compat.get_player_main_stack(this.player, i);
                                if (stack2 == null || item_stack == null || stack2.func_190926_b() || item_stack.func_77973_b() != stack2.func_77973_b() || stack2.func_190916_E() < d) continue;
                                slot = i;
                            }
                            if (slot > -1 && (placed = WandsMod.compat.setBlockState(this.world, pos, this.state))) {
                                WandsMod.compat.player_stack_dec(this.player, slot, d);
                            }
                        }
                    }
                    if (placed) {
                        if (this.destroy) {
                            WandsMod.compat.inc_wand_damage(this.player, this.offhand, 1);
                        }
                        WandsMod.compat.inc_wand_damage(this.player, this.wand_stack, 1);
                        if (this.BLOCKS_PER_XP != 0.0f) {
                            float diff = WandItem.calc_xp_to_next_level(this.player.field_71068_ca);
                            float prog = this.experienceProgress;
                            if (diff > 0.0f && this.BLOCKS_PER_XP != 0.0f) {
                                float a = 1.0f / diff / this.BLOCKS_PER_XP;
                                if (prog - a > 0.0f) {
                                    prog -= a;
                                } else {
                                    prog = prog > 0.0f ? 1.0f + (a - prog) : 1.0f;
                                    if (this.player.field_71068_ca > 0) {
                                        --this.player.field_71068_ca;
                                        diff = WandItem.calc_xp_to_next_level(this.player.field_71068_ca);
                                        a = 1.0f / diff / this.BLOCKS_PER_XP;
                                        if (prog - a > 0.0f) {
                                            prog -= a;
                                        }
                                    }
                                    WandsMod.compat.send_xp_to_player(this.player);
                                }
                            }
                        }
                    }
                }
            }
        }
        return placed;
    }

    private boolean line() {
        boolean placed = false;
        int x1 = this.pos0.func_177958_n();
        int y1 = this.pos0.func_177956_o();
        int z1 = this.pos0.func_177952_p();
        int x2 = this.pos1.func_177958_n();
        int y2 = this.pos1.func_177956_o();
        int z2 = this.pos1.func_177952_p();
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int dz = Math.abs(z2 - z1);
        int xs = x2 > x1 ? 1 : -1;
        int ys = y2 > y1 ? 1 : -1;
        int zs = z2 > z1 ? 1 : -1;
        placed = this.place(new BlockPos(x1, y1, z1));
        if (dx >= dy && dx >= dz) {
            int p1 = 2 * dy - dx;
            int p2 = 2 * dz - dx;
            while (x1 != x2) {
                x1 += xs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dx;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dx;
                }
                p1 += 2 * dy;
                p2 += 2 * dz;
                placed = this.place(new BlockPos(x1, y1, z1)) || placed;
            }
        } else if (dy >= dx && dy >= dz) {
            int p1 = 2 * dx - dy;
            int p2 = 2 * dz - dy;
            while (y1 != y2) {
                y1 += ys;
                if (p1 >= 0) {
                    x1 += xs;
                    p1 -= 2 * dy;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dy;
                }
                p1 += 2 * dx;
                p2 += 2 * dz;
                placed = this.place(new BlockPos(x1, y1, z1)) || placed;
            }
        } else {
            int p1 = 2 * dy - dz;
            int p2 = 2 * dx - dz;
            while (z1 != z2) {
                z1 += zs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dz;
                }
                if (p2 >= 0) {
                    x1 += xs;
                    p2 -= 2 * dz;
                }
                p1 += 2 * dy;
                p2 += 2 * dx;
                placed = this.place(new BlockPos(x1, y1, z1)) || placed;
            }
        }
        return placed;
    }

    private boolean drawCircle(int xc, int yc, int zc, int x, int y, int z) {
        boolean placed = false;
        switch (this.plane) {
            case 0: {
                placed = this.place(new BlockPos(xc + x, yc, zc + z)) || placed;
                placed = this.place(new BlockPos(xc - x, yc, zc + z)) || placed;
                placed = this.place(new BlockPos(xc + x, yc, zc - z)) || placed;
                placed = this.place(new BlockPos(xc - x, yc, zc - z)) || placed;
                placed = this.place(new BlockPos(xc + z, yc, zc + x)) || placed;
                placed = this.place(new BlockPos(xc - z, yc, zc + x)) || placed;
                placed = this.place(new BlockPos(xc + z, yc, zc - x)) || placed;
                placed = this.place(new BlockPos(xc - z, yc, zc - x)) || placed;
                break;
            }
            case 1: {
                placed = this.place(new BlockPos(xc + x, yc + y, zc)) || placed;
                placed = this.place(new BlockPos(xc - x, yc + y, zc)) || placed;
                placed = this.place(new BlockPos(xc + x, yc - y, zc)) || placed;
                placed = this.place(new BlockPos(xc - x, yc - y, zc)) || placed;
                placed = this.place(new BlockPos(xc + y, yc + x, zc)) || placed;
                placed = this.place(new BlockPos(xc - y, yc + x, zc)) || placed;
                placed = this.place(new BlockPos(xc + y, yc - x, zc)) || placed;
                placed = this.place(new BlockPos(xc - y, yc - x, zc)) || placed;
                break;
            }
            case 2: {
                placed = this.place(new BlockPos(xc, yc - y, zc + z)) || placed;
                placed = this.place(new BlockPos(xc, yc + y, zc + z)) || placed;
                placed = this.place(new BlockPos(xc, yc + y, zc - z)) || placed;
                placed = this.place(new BlockPos(xc, yc - y, zc - z)) || placed;
                placed = this.place(new BlockPos(xc, yc + z, zc + y)) || placed;
                placed = this.place(new BlockPos(xc, yc - z, zc + y)) || placed;
                placed = this.place(new BlockPos(xc, yc + z, zc - y)) || placed;
                placed = this.place(new BlockPos(xc, yc - z, zc - y)) || placed;
            }
        }
        return placed;
    }

    boolean circle() {
        boolean placed;
        block4: {
            int zc;
            int yc;
            int xc;
            int r;
            block5: {
                block3: {
                    placed = false;
                    r = 1;
                    xc = this.pos0.func_177958_n();
                    yc = this.pos0.func_177956_o();
                    zc = this.pos0.func_177952_p();
                    int px = this.pos1.func_177958_n() - this.pos0.func_177958_n();
                    int py = this.pos1.func_177956_o() - this.pos0.func_177956_o();
                    int pz = this.pos1.func_177952_p() - this.pos0.func_177952_p();
                    r = (int)Math.sqrt(px * px + py * py + pz * pz);
                    if (this.plane != 0) break block3;
                    int x = 0;
                    int y = 0;
                    int z = r;
                    int d = 3 - 2 * r;
                    boolean bl = placed = this.drawCircle(xc, yc, zc, x, y, z) || placed;
                    while (z >= x) {
                        d = d > 0 ? d + 4 * (x - --z) + 10 : d + 4 * ++x + 6;
                        placed = this.drawCircle(xc, yc, zc, x, y, z) || placed;
                    }
                    break block4;
                }
                if (this.plane != 1) break block5;
                int x = 0;
                int y = r;
                int z = 0;
                int d = 3 - 2 * r;
                boolean bl = placed = this.drawCircle(xc, yc, zc, x, y, z) || placed;
                while (y >= x) {
                    d = d > 0 ? d + 4 * (x - --y) + 10 : d + 4 * ++x + 6;
                    placed = this.drawCircle(xc, yc, zc, x, y, z) || placed;
                }
                break block4;
            }
            if (this.plane != 2) break block4;
            int x = 0;
            int y = 0;
            int z = r;
            int d = 3 - 2 * r;
            boolean bl = placed = this.drawCircle(xc, yc, zc, x, y, z) || placed;
            while (z >= y) {
                d = d > 0 ? d + 4 * (y - --z) + 10 : d + 4 * ++y + 6;
                placed = this.drawCircle(xc, yc, zc, x, y, z) || placed;
            }
        }
        return placed;
    }
}

