/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.common;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.nicguzzo.WandsMod;
import net.nicguzzo.common.MyDir;
import net.nicguzzo.common.WandItem;
import net.nicguzzo.common.WandsConfig;
import org.lwjgl.opengl.GL11;

public class WandsBaseRenderer {
    public static final float p_o = -0.001f;
    public static float BLOCKS_PER_XP = 0.0f;
    private static long t0 = 0L;
    private static long t1 = 0L;
    private static boolean prnt = false;
    static BlockBuffer r_block_buffer = null;

    public static void render(World world, PlayerEntity player, BlockPos pos, BlockState block_state, double camX, double camY, double camZ, int lim, boolean isCreative, boolean isDoubleSlab, boolean isSlabTop, float experienceProgress, MyDir side, boolean isFullCube, double hit_x, double hit_y, double hit_z) {
        boolean mm;
        WandItem wand = WandsMod.compat.get_player_wand(player);
        if (r_block_buffer == null) {
            r_block_buffer = new BlockBuffer(WandsMod.config.netherite_wand_limit);
        }
        if (wand == null) {
            return;
        }
        WandItem.side = side;
        prnt = false;
        t1 = System.currentTimeMillis();
        if (t1 - t0 > 1000L) {
            t0 = System.currentTimeMillis();
            prnt = true;
        }
        Block block = block_state.func_177230_c();
        int d = 1;
        boolean is_slab = false;
        SlabBlock slab = null;
        if (block instanceof SlabBlock) {
            is_slab = true;
            slab = (SlabBlock)block;
            if (isDoubleSlab) {
                d = 2;
            }
        }
        ItemStack item_stack = null;
        int it_count = 0;
        boolean line_circle = WandItem.getMode() == 4 || WandItem.getMode() == 5;
        item_stack = line_circle && WandItem.fill1_state != null ? new ItemStack((IItemProvider)WandItem.fill1_state.func_177230_c()) : new ItemStack((IItemProvider)block);
        ItemStack offhand = WandsMod.compat.get_player_offhand_stack(player);
        boolean destroy = WandsMod.compat.can_destroy(block_state, offhand, isCreative);
        if (prnt) {
            // empty if block
        }
        it_count = WandsMod.compat.in_inventory(player, item_stack);
        int in_shulker = 0;
        if (!destroy) {
            in_shulker = WandsMod.compat.in_shulker(player, item_stack);
        }
        boolean bl = mm = WandItem.getPaletteMode() != WandItem.PaletteMode.SAME && (WandItem.getMode() == 2 || WandItem.getMode() == 4 || WandItem.getMode() == 5);
        if (!destroy && !mm && !isCreative && it_count < d && in_shulker < d && WandItem.fill_pos1 == null && prnt) {
            WandsMod.compat.send_message_to_player("no blocks");
        }
        boolean notags = WandsMod.compat.has_tag(item_stack);
        if (it_count >= d || isCreative || mm || in_shulker >= d || WandItem.fill_pos1 != null || notags || destroy) {
            boolean is_pane = false;
            boolean is_fence = false;
            boolean is_fence_gate = false;
            boolean is_stairs = false;
            boolean is_leaves = false;
            if (!is_slab) {
                if (block instanceof PaneBlock) {
                    is_pane = true;
                } else if (block instanceof FenceBlock) {
                    is_fence = true;
                } else if (block instanceof FenceGateBlock) {
                    is_fence_gate = true;
                } else if (block instanceof StairsBlock) {
                    is_stairs = true;
                } else if (block instanceof LeavesBlock) {
                    is_leaves = true;
                }
            }
            float xp = 0.0f;
            int max_xp_blocks = 0;
            if (!isCreative && BLOCKS_PER_XP > 0.0f && (max_xp_blocks = (int)((xp = WandItem.calc_xp(player.field_71068_ca, experienceProgress)) * BLOCKS_PER_XP)) < it_count && prnt) {
                WandsMod.compat.send_message_to_player("not enough xp");
            }
            boolean allowed = false;
            boolean denied = false;
            if (WandsConfig.allowed.contains(block)) {
                allowed = true;
            }
            if (WandsConfig.denied.contains(block)) {
                denied = true;
            }
            if (!denied && (max_xp_blocks > 0 || BLOCKS_PER_XP == 0.0f || isCreative) && (isFullCube || is_slab || is_pane || is_fence || is_fence_gate || is_stairs || mm || allowed || destroy)) {
                float h = 1.0f;
                float y0 = 0.0f;
                if (slab != null) {
                    if (!isSlabTop) {
                        h = 0.5f;
                    } else {
                        y0 = 0.5f;
                        h = 0.5f;
                    }
                }
                RenderSystem.pushMatrix();
                RenderSystem.translated((double)(-camX), (double)(-camY), (double)(-camZ));
                RenderSystem.enableDepthTest();
                RenderSystem.disableTexture();
                GL11.glLineWidth((float)3.0f);
                GL11.glBegin((int)1);
                switch (WandItem.getMode()) {
                    case 0: {
                        if (is_pane || is_fence || is_fence_gate) {
                            WandItem.valid = false;
                            break;
                        }
                        WandsBaseRenderer.mode0(wand, pos, y0, h, side, world, block_state, player, lim, hit_x, hit_y, hit_z, destroy);
                        break;
                    }
                    case 1: {
                        WandsBaseRenderer.mode1(wand, pos, y0, h, side, hit_x, hit_y, hit_z, world, block_state, player, lim, max_xp_blocks, item_stack, is_pane || is_fence || is_fence_gate || is_stairs || is_leaves, isCreative, destroy);
                        break;
                    }
                    case 2: {
                        WandItem.valid = true;
                        if (WandItem.fill_pos1 == null) break;
                        float x1 = WandItem.fill_pos1.func_177958_n();
                        float y1 = WandItem.fill_pos1.func_177956_o();
                        float z1 = WandItem.fill_pos1.func_177952_p();
                        float x2 = pos.func_177958_n();
                        float y2 = pos.func_177956_o();
                        float z2 = pos.func_177952_p();
                        if (!WandItem.fill_pos1.equals((Object)pos)) {
                            if (x1 >= x2) {
                                x1 += 1.0f;
                            } else {
                                x2 += 1.0f;
                            }
                            if (y1 >= y2) {
                                y1 += 1.0f;
                            } else {
                                y2 += 1.0f;
                            }
                            if (z1 >= z2) {
                                z1 += 1.0f;
                            } else {
                                z2 += 1.0f;
                            }
                        } else {
                            x2 = x1 + 1.0f;
                            y2 = y1 + 1.0f;
                            z2 = z1 + 1.0f;
                        }
                        if (!(Math.abs(x2 - x1) <= (float)lim) || !(Math.abs(y2 - y1) <= (float)lim) || !(Math.abs(z2 - z1) <= (float)lim)) break;
                        WandsBaseRenderer.preview(x1, y1, z1, x2, y2, z2);
                        break;
                    }
                    case 3: {
                        WandsBaseRenderer.mode3(r_block_buffer, wand, pos, block_state, world, side, destroy);
                        for (int a = 0; a < WandsBaseRenderer.r_block_buffer.length; ++a) {
                            BlockPos p = WandsBaseRenderer.r_block_buffer.buffer[a];
                            int m3_x1 = p.func_177958_n();
                            int m3_y1 = p.func_177956_o();
                            int m3_z1 = p.func_177952_p();
                            WandsBaseRenderer.preview(m3_x1, m3_y1, m3_z1, m3_x1 + 1, m3_y1 + 1, m3_z1 + 1);
                        }
                        break;
                    }
                    case 4: {
                        WandItem.valid = true;
                        if (WandItem.fill_pos1 == null) break;
                        float x1 = WandItem.fill_pos1.func_177958_n();
                        float y1 = WandItem.fill_pos1.func_177956_o();
                        float z1 = WandItem.fill_pos1.func_177952_p();
                        float x2 = pos.func_177958_n();
                        float y2 = pos.func_177956_o();
                        float z2 = pos.func_177952_p();
                        float xx = x2 - x1;
                        float yy = y2 - y1;
                        float zz = z2 - z1;
                        int nbl = (int)Math.ceil(Math.PI * Math.sqrt(xx * xx + yy * yy + zz * zz));
                        if (!isCreative && nbl > lim) {
                            WandItem.valid = false;
                            if (!prnt) break;
                            WandsMod.compat.send_message_to_player("wand limit reached");
                            break;
                        }
                        RenderSystem.color4f((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
                        GL11.glVertex3d((double)((double)x1 + 0.5), (double)((double)y1 + 0.5), (double)((double)z1 + 0.5));
                        GL11.glVertex3d((double)((double)x2 + 0.5), (double)((double)y2 + 0.5), (double)((double)z2 + 0.5));
                        WandsBaseRenderer.line(WandItem.fill_pos1, pos);
                        break;
                    }
                    case 5: {
                        WandItem.valid = true;
                        if (WandItem.fill_pos1 == null) break;
                        float x1 = WandItem.fill_pos1.func_177958_n();
                        float y1 = WandItem.fill_pos1.func_177956_o();
                        float z1 = WandItem.fill_pos1.func_177952_p();
                        float x2 = pos.func_177958_n();
                        float y2 = y1;
                        float z2 = pos.func_177952_p();
                        float xx = x2 - x1;
                        float yy = y2 - y1;
                        float zz = z2 - z1;
                        int radius = (int)Math.sqrt(xx * xx + yy * yy + zz * zz);
                        int cir = (int)(Math.PI * (double)radius);
                        if (!isCreative && cir > lim) {
                            WandItem.valid = false;
                            if (!prnt) break;
                            WandsMod.compat.send_message_to_player("wand limit reached");
                            break;
                        }
                        if (prnt) {
                            WandsMod.compat.send_message_to_player("diam: " + (radius * 2 + 1));
                        }
                        RenderSystem.color4f((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
                        GL11.glVertex3d((double)((double)x1 + 0.5), (double)((double)y1 + 0.5), (double)((double)z1 + 0.5));
                        GL11.glVertex3d((double)((double)x2 + 0.5), (double)((double)y2 + 0.5), (double)((double)z2 + 0.5));
                        WandsBaseRenderer.circle(WandItem.fill_pos1, pos, WandItem.getPlane().ordinal());
                        break;
                    }
                    default: {
                        WandItem.valid = false;
                    }
                }
                GL11.glEnd();
                RenderSystem.enableBlend();
                RenderSystem.enableTexture();
                RenderSystem.popMatrix();
            }
        } else {
            WandItem.valid = false;
        }
    }

    private static void mode0(WandItem wand, BlockPos pos, float y0, float h, MyDir side, World world, BlockState block_state, PlayerEntity player, int lim, double hit_x, double hit_y, double hit_z, boolean destroy) {
        float x = pos.func_177958_n();
        float y = pos.func_177956_o();
        float z = pos.func_177952_p();
        float o = 0.01f;
        switch (side) {
            case UP: {
                y += h + o;
                break;
            }
            case DOWN: {
                y -= o;
                break;
            }
            case SOUTH: {
                z += 1.0f + o;
                break;
            }
            case NORTH: {
                z -= o;
                break;
            }
            case EAST: {
                x += 1.0f + o;
                break;
            }
            case WEST: {
                x -= o;
            }
        }
        WandsBaseRenderer.grid(side, x, y + y0, z, h);
        MyDir[] dirs = WandsBaseRenderer.getMyDirMode0(side, y0, h, hit_x, hit_y, hit_z);
        MyDir d1 = dirs[0];
        MyDir d2 = dirs[1];
        if (d1 != null) {
            BlockPos pv = null;
            pv = d2 != null ? WandsBaseRenderer.find_next_diag(world, block_state, d1, d2, pos, wand, destroy) : WandsBaseRenderer.find_next_pos(world, block_state, d1, pos, wand, destroy);
            if (pv != null) {
                int z2;
                int y2;
                int x2;
                int z1;
                int y1;
                int x1 = pv.func_177958_n();
                if (WandsMod.compat.interescts_player_bb(player, x1, y1 = pv.func_177956_o(), z1 = pv.func_177952_p(), x2 = x1 + 1, y2 = y1 + 1, z2 = z1 + 1)) {
                    WandItem.valid = false;
                } else {
                    WandItem.valid = true;
                    WandItem.x1 = x1;
                    WandItem.y1 = y1;
                    WandItem.z1 = z1;
                    WandItem.x2 = x2;
                    WandItem.y2 = y2;
                    WandItem.z2 = z2;
                    WandsBaseRenderer.preview(x1, y1, z1, x2, y2, z2);
                }
            } else {
                WandItem.valid = false;
            }
        }
    }

    private static void mode1(WandItem wand, BlockPos pos, float y0, float h, MyDir side, double hit_x, double hit_y, double hit_z, World world, BlockState block_state, PlayerEntity player, int lim, int max_xp_blocks, ItemStack item_stack, boolean dont_check_state, boolean isCreative, boolean destroy) {
        MyDir dir = MyDir.EAST;
        BlockPos pos_m = WandsMod.compat.pos_offset(pos, side, 1);
        BlockState state = world.func_180495_p(pos_m);
        if (state.func_196958_f() || WandsMod.compat.is_fluid(state, wand)) {
            BlockPos pos0 = pos;
            BlockPos pos1 = pos_m;
            BlockPos pos2 = pos;
            BlockPos pos3 = pos_m;
            int offx = 0;
            int offy = 0;
            int offz = 0;
            block0 : switch (side) {
                case UP: 
                case DOWN: {
                    switch (WandItem.getOrientation()) {
                        case HORIZONTAL: {
                            dir = MyDir.SOUTH;
                            offz = -1;
                            break;
                        }
                        case VERTICAL: {
                            dir = MyDir.EAST;
                            offx = -1;
                        }
                    }
                    break;
                }
                case SOUTH: 
                case NORTH: {
                    switch (WandItem.getOrientation()) {
                        case HORIZONTAL: {
                            dir = MyDir.EAST;
                            offx = -1;
                            break;
                        }
                        case VERTICAL: {
                            dir = MyDir.UP;
                            offy = -1;
                        }
                    }
                    break;
                }
                case EAST: 
                case WEST: {
                    switch (WandItem.getOrientation()) {
                        case HORIZONTAL: {
                            dir = MyDir.SOUTH;
                            offz = -1;
                            break block0;
                        }
                        case VERTICAL: {
                            dir = MyDir.UP;
                            offy = -1;
                        }
                    }
                }
            }
            MyDir op = dir.getOpposite();
            int i = lim - 1;
            int k = 0;
            boolean stop1 = false;
            boolean stop2 = false;
            boolean intersects = false;
            if (!isCreative) {
                int n = WandsMod.compat.in_inventory(player, item_stack);
                if (n < i) {
                    i = n - 1;
                }
                if (BLOCKS_PER_XP != 0.0f && max_xp_blocks < i) {
                    i = max_xp_blocks - 1;
                }
            }
            boolean eq = false;
            while (k < 81 && i > 0) {
                if (!stop1 && i > 0) {
                    BlockState bs0 = world.func_180495_p(WandsMod.compat.pos_offset(pos0, dir, 1));
                    BlockState bs1 = world.func_180495_p(WandsMod.compat.pos_offset(pos1, dir, 1));
                    eq = dont_check_state ? bs0.func_177230_c().equals(block_state.func_177230_c()) : bs0.equals(block_state);
                    if (eq && (bs1.func_196958_f() || WandsMod.compat.is_fluid(bs1, wand))) {
                        pos0 = WandsMod.compat.pos_offset(pos0, dir, 1);
                        pos1 = WandsMod.compat.pos_offset(pos1, dir, 1);
                        --i;
                    } else {
                        stop1 = true;
                    }
                }
                if (!stop2 && i > 0) {
                    BlockState bs2 = world.func_180495_p(WandsMod.compat.pos_offset(pos2, op, 1));
                    BlockState bs3 = world.func_180495_p(WandsMod.compat.pos_offset(pos3, op, 1));
                    eq = dont_check_state ? bs2.func_177230_c().equals(block_state.func_177230_c()) : bs2.equals(block_state);
                    if (eq && (bs3.func_196958_f() || WandsMod.compat.is_fluid(bs3, wand))) {
                        pos2 = WandsMod.compat.pos_offset(pos2, op, 1);
                        pos3 = WandsMod.compat.pos_offset(pos3, op, 1);
                        --i;
                    } else {
                        stop2 = true;
                    }
                }
                if (!destroy) {
                    if (WandsMod.compat.interescts_player_bb(player, pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p(), pos1.func_177958_n() + 1, pos1.func_177956_o() + 1, pos1.func_177952_p() + 1)) {
                        intersects = true;
                        break;
                    }
                    if (WandsMod.compat.interescts_player_bb(player, pos3.func_177958_n(), pos3.func_177956_o(), pos3.func_177952_p(), pos3.func_177958_n() + 1, pos3.func_177956_o() + 1, pos3.func_177952_p() + 1)) {
                        intersects = true;
                        break;
                    }
                }
                ++k;
                if (!stop1 || !stop2) continue;
                k = 1000;
            }
            if (destroy) {
                pos1 = WandsMod.compat.pos_offset(pos1, side.getOpposite(), 1);
                pos3 = WandsMod.compat.pos_offset(pos3, side.getOpposite(), 1);
            }
            int x1 = pos1.func_177958_n() - offx;
            int y1 = pos1.func_177956_o() - offy;
            int z1 = pos1.func_177952_p() - offz;
            int x2 = pos3.func_177958_n() + 1 + offx;
            int y2 = pos3.func_177956_o() + 1 + offy;
            int z2 = pos3.func_177952_p() + 1 + offz;
            if (intersects) {
                WandItem.valid = false;
            } else {
                WandItem.valid = true;
                WandItem.x1 = x1 + offx;
                WandItem.y1 = y1 + offy;
                WandItem.z1 = z1 + offz;
                WandItem.x2 = x2 + offx;
                WandItem.y2 = y2 + offy;
                WandItem.z2 = z2 + offz;
                WandsBaseRenderer.preview(x1, y1, z1, x2, y2, z2);
            }
        } else {
            WandItem.valid = false;
        }
    }

    public static void mode3(BlockBuffer block_buffer, WandItem wand, BlockPos pos, BlockState block_state, World world, MyDir side, boolean destroy) {
        block_buffer.length = 0;
        WandsBaseRenderer.add_neighbour(block_buffer, wand, pos, block_state, world, side);
        for (int i = 0; i < wand.getLimit(); ++i) {
            if (i >= block_buffer.length) continue;
            BlockPos p = WandsMod.compat.pos_offset(block_buffer.buffer[i], side, -1);
            WandsBaseRenderer.find_neighbours(block_buffer, wand, p, block_state, world, side);
        }
        if (destroy) {
            for (int a = 0; a < block_buffer.length; ++a) {
                block_buffer.buffer[a] = WandsMod.compat.pos_offset(block_buffer.buffer[a], side, -1);
            }
        }
        WandItem.valid = block_buffer.length > 0;
    }

    private static void find_neighbours(BlockBuffer block_buffer, WandItem wand, BlockPos pos, BlockState block_state, World world, MyDir side) {
        if (side == MyDir.UP || side == MyDir.DOWN) {
            BlockPos p0 = WandsMod.compat.pos_offset(pos, MyDir.EAST, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p0, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.EAST, 1);
            BlockPos p1 = WandsMod.compat.pos_offset(p0, MyDir.NORTH, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p1, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.NORTH, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p0, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.NORTH, 1);
            p1 = WandsMod.compat.pos_offset(p0, MyDir.WEST, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p1, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.WEST, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p0, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.SOUTH, 1);
            p1 = WandsMod.compat.pos_offset(p0, MyDir.WEST, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p1, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.SOUTH, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p0, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.SOUTH, 1);
            p1 = WandsMod.compat.pos_offset(p0, MyDir.EAST, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p1, block_state, world, side);
        } else if (side == MyDir.EAST || side == MyDir.WEST) {
            BlockPos p0 = WandsMod.compat.pos_offset(pos, MyDir.UP, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p0, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.UP, 1);
            BlockPos p1 = WandsMod.compat.pos_offset(p0, MyDir.NORTH, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p1, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.NORTH, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p0, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.NORTH, 1);
            p1 = WandsMod.compat.pos_offset(p0, MyDir.DOWN, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p1, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.DOWN, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p0, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.SOUTH, 1);
            p1 = WandsMod.compat.pos_offset(p0, MyDir.DOWN, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p1, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.SOUTH, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p0, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.SOUTH, 1);
            p1 = WandsMod.compat.pos_offset(p0, MyDir.UP, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p1, block_state, world, side);
        } else if (side == MyDir.NORTH || side == MyDir.SOUTH) {
            BlockPos p0 = WandsMod.compat.pos_offset(pos, MyDir.EAST, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p0, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.EAST, 1);
            BlockPos p1 = WandsMod.compat.pos_offset(p0, MyDir.UP, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p1, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.UP, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p0, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.UP, 1);
            p1 = WandsMod.compat.pos_offset(p0, MyDir.WEST, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p1, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.WEST, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p0, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.DOWN, 1);
            p1 = WandsMod.compat.pos_offset(p0, MyDir.WEST, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p1, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.DOWN, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p0, block_state, world, side);
            p0 = WandsMod.compat.pos_offset(pos, MyDir.DOWN, 1);
            p1 = WandsMod.compat.pos_offset(p0, MyDir.EAST, 1);
            WandsBaseRenderer.add_neighbour(block_buffer, wand, p1, block_state, world, side);
        }
    }

    public static boolean can_place(BlockState state, WandItem wand, World world, BlockPos pos) {
        return state.func_196958_f() || WandsMod.compat.is_fluid(state, wand) || WandsMod.compat.is_plant(state);
    }

    private static void add_neighbour(BlockBuffer block_buffer, WandItem wand, BlockPos pos, BlockState block_state, World world, MyDir side) {
        BlockPos pos2 = WandsMod.compat.pos_offset(pos, side, 1);
        if (!block_buffer.in_buffer(pos2)) {
            BlockState bs1 = world.func_180495_p(pos);
            BlockState bs2 = world.func_180495_p(pos2);
            if (bs1.equals(block_state) && WandsBaseRenderer.can_place(bs2, wand, world, pos2)) {
                block_buffer.add_buffer(pos2);
            }
        }
    }

    public static BlockPos find_next_diag(World world, BlockState block_state, MyDir dir1, MyDir dir2, BlockPos pos, WandItem wand, boolean destroy) {
        BlockPos p0 = pos;
        for (int i = 0; i < wand.getLimit(); ++i) {
            BlockPos p1 = WandsMod.compat.pos_offset(pos, dir1, 1);
            BlockState bs = world.func_180495_p(pos = WandsMod.compat.pos_offset(p1, dir2, 1));
            if (bs != null) {
                if (destroy) {
                    if (!bs.equals(block_state) && p0 != null) {
                        return p0;
                    }
                } else {
                    if (WandsBaseRenderer.can_place(bs, wand, world, pos)) {
                        return pos;
                    }
                    if (!bs.equals(block_state)) {
                        return null;
                    }
                }
            }
            p0 = pos;
        }
        return null;
    }

    public static BlockPos find_next_pos(World world, BlockState block_state, MyDir dir, BlockPos pos, WandItem wand, boolean destroy) {
        for (int i = 0; i < wand.getLimit(); ++i) {
            BlockPos pos2 = WandsMod.compat.pos_offset(pos, dir, i + 1);
            BlockState bs = world.func_180495_p(pos2);
            if (bs == null || bs.equals(block_state)) continue;
            if (destroy) {
                return WandsMod.compat.pos_offset(pos, dir, i);
            }
            if (WandsBaseRenderer.can_place(bs, wand, world, pos2)) {
                return pos2;
            }
            return null;
        }
        return null;
    }

    public static float unitCoord(float x) {
        float y = x - (float)((int)x);
        if (y < 0.0f) {
            y = 1.0f + y;
        }
        return y;
    }

    public static MyDir[] getMyDirMode0(MyDir side, float y0, float h, double hit_x, double hit_y, double hit_z) {
        MyDir[] ret = new MyDir[]{null, null};
        float x = WandsBaseRenderer.unitCoord((float)hit_x);
        float y = WandsBaseRenderer.unitCoord((float)hit_y);
        float z = WandsBaseRenderer.unitCoord((float)hit_z);
        float a = 0.25f;
        float b = 0.75f;
        float a2 = y0 + a * h;
        float b2 = y0 + b * h;
        switch (side) {
            case UP: 
            case DOWN: {
                if (x >= a && x <= b) {
                    if (z <= a) {
                        ret[0] = MyDir.NORTH;
                        break;
                    }
                    if (z >= b) {
                        ret[0] = MyDir.SOUTH;
                        break;
                    }
                    ret[0] = side.getOpposite();
                    break;
                }
                if (z >= a && z <= b) {
                    if (x <= a) {
                        ret[0] = MyDir.WEST;
                        break;
                    }
                    if (!(x >= b)) break;
                    ret[0] = MyDir.EAST;
                    break;
                }
                if (x <= a && z <= a) {
                    ret[0] = MyDir.WEST;
                    ret[1] = MyDir.NORTH;
                }
                if (x >= b && z <= a) {
                    ret[0] = MyDir.EAST;
                    ret[1] = MyDir.NORTH;
                }
                if (x >= b && z >= b) {
                    ret[0] = MyDir.EAST;
                    ret[1] = MyDir.SOUTH;
                }
                if (!(x <= a) || !(z >= b)) break;
                ret[0] = MyDir.WEST;
                ret[1] = MyDir.SOUTH;
                break;
            }
            case EAST: 
            case WEST: {
                if (z >= a && z <= b) {
                    if (y <= a2) {
                        ret[0] = MyDir.DOWN;
                        break;
                    }
                    if (y >= b2) {
                        ret[0] = MyDir.UP;
                        break;
                    }
                    ret[0] = side.getOpposite();
                    break;
                }
                if (y >= a2 && y <= b2) {
                    if (z <= a) {
                        ret[0] = MyDir.NORTH;
                        return ret;
                    }
                    if (!(z >= b)) break;
                    ret[0] = MyDir.SOUTH;
                    return ret;
                }
                if (y <= a2 && z <= a) {
                    ret[0] = MyDir.DOWN;
                    ret[1] = MyDir.NORTH;
                }
                if (y >= b2 && z <= a) {
                    ret[0] = MyDir.UP;
                    ret[1] = MyDir.NORTH;
                }
                if (y >= b2 && z >= b) {
                    ret[0] = MyDir.UP;
                    ret[1] = MyDir.SOUTH;
                }
                if (!(y <= a2) || !(z >= b)) break;
                ret[0] = MyDir.DOWN;
                ret[1] = MyDir.SOUTH;
                break;
            }
            case SOUTH: 
            case NORTH: {
                if (x >= a && x <= b) {
                    if (y <= a2) {
                        ret[0] = MyDir.DOWN;
                        break;
                    }
                    if (y >= b2) {
                        ret[0] = MyDir.UP;
                        break;
                    }
                    ret[0] = side.getOpposite();
                    break;
                }
                if (y >= a2 && y <= b2) {
                    if (x <= a) {
                        ret[0] = MyDir.WEST;
                        break;
                    }
                    if (!(x >= b2)) break;
                    ret[0] = MyDir.EAST;
                    break;
                }
                if (y <= a2 && x <= a) {
                    ret[0] = MyDir.DOWN;
                    ret[1] = MyDir.WEST;
                }
                if (y >= b2 && x <= a) {
                    ret[0] = MyDir.UP;
                    ret[1] = MyDir.WEST;
                }
                if (y >= b2 && x >= b) {
                    ret[0] = MyDir.UP;
                    ret[1] = MyDir.EAST;
                }
                if (!(y <= a2) || !(x >= b)) break;
                ret[0] = MyDir.DOWN;
                ret[1] = MyDir.EAST;
            }
        }
        if (WandItem.getInvert()) {
            if (ret[0] != null) {
                ret[0] = ret[0].getOpposite();
            }
            if (ret[1] != null) {
                ret[1] = ret[1].getOpposite();
            }
        }
        return ret;
    }

    private static void preview(float fx1, float fy1, float fz1, float fx2, float fy2, float fz2) {
        fy2 -= -0.001f;
        RenderSystem.color4f((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
        GL11.glVertex3d((double)(fx1 += -0.001f), (double)(fy1 += -0.001f), (double)(fz1 += -0.001f));
        GL11.glVertex3d((double)(fx2 -= -0.001f), (double)fy1, (double)fz1);
        GL11.glVertex3d((double)fx1, (double)fy1, (double)fz1);
        GL11.glVertex3d((double)fx1, (double)fy1, (double)(fz2 -= -0.001f));
        GL11.glVertex3d((double)fx1, (double)fy1, (double)fz2);
        GL11.glVertex3d((double)fx2, (double)fy1, (double)fz2);
        GL11.glVertex3d((double)fx2, (double)fy1, (double)fz1);
        GL11.glVertex3d((double)fx2, (double)fy1, (double)fz2);
        GL11.glVertex3d((double)fx1, (double)fy2, (double)fz1);
        GL11.glVertex3d((double)fx2, (double)fy2, (double)fz1);
        GL11.glVertex3d((double)fx1, (double)fy2, (double)fz1);
        GL11.glVertex3d((double)fx1, (double)fy2, (double)fz2);
        GL11.glVertex3d((double)fx1, (double)fy2, (double)fz2);
        GL11.glVertex3d((double)fx2, (double)fy2, (double)fz2);
        GL11.glVertex3d((double)fx2, (double)fy2, (double)fz1);
        GL11.glVertex3d((double)fx2, (double)fy2, (double)fz2);
        GL11.glVertex3d((double)fx1, (double)fy1, (double)fz1);
        GL11.glVertex3d((double)fx1, (double)fy2, (double)fz1);
        GL11.glVertex3d((double)fx2, (double)fy1, (double)fz1);
        GL11.glVertex3d((double)fx2, (double)fy2, (double)fz1);
        GL11.glVertex3d((double)fx1, (double)fy1, (double)fz2);
        GL11.glVertex3d((double)fx1, (double)fy2, (double)fz2);
        GL11.glVertex3d((double)fx2, (double)fy1, (double)fz2);
        GL11.glVertex3d((double)fx2, (double)fy2, (double)fz2);
    }

    private static void grid(MyDir side, float x, float y, float z, float h) {
        switch (side) {
            case UP: 
            case DOWN: {
                RenderSystem.color4f((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
                GL11.glVertex3d((double)x, (double)y, (double)z);
                GL11.glVertex3d((double)(x + 1.0f), (double)y, (double)z);
                GL11.glVertex3d((double)x, (double)y, (double)z);
                GL11.glVertex3d((double)x, (double)y, (double)(z + 1.0f));
                GL11.glVertex3d((double)(x + 1.0f), (double)y, (double)z);
                GL11.glVertex3d((double)(x + 1.0f), (double)y, (double)(z + 1.0f));
                GL11.glVertex3d((double)x, (double)y, (double)(z + 1.0f));
                GL11.glVertex3d((double)(x + 1.0f), (double)y, (double)(z + 1.0f));
                GL11.glVertex3d((double)x, (double)y, (double)(z + 0.25f));
                GL11.glVertex3d((double)(x + 1.0f), (double)y, (double)(z + 0.25f));
                GL11.glVertex3d((double)x, (double)y, (double)(z + 0.75f));
                GL11.glVertex3d((double)(x + 1.0f), (double)y, (double)(z + 0.75f));
                GL11.glVertex3d((double)(x + 0.25f), (double)y, (double)z);
                GL11.glVertex3d((double)(x + 0.25f), (double)y, (double)(z + 1.0f));
                GL11.glVertex3d((double)(x + 0.75f), (double)y, (double)z);
                GL11.glVertex3d((double)(x + 0.75f), (double)y, (double)(z + 1.0f));
                RenderSystem.color4f((float)178.0f, (float)0.0f, (float)0.0f, (float)255.0f);
                GL11.glVertex3d((double)(x + 0.4f), (double)y, (double)(z + 0.2f));
                GL11.glVertex3d((double)(x + 0.5f), (double)y, (double)(z + 0.05f));
                GL11.glVertex3d((double)(x + 0.6f), (double)y, (double)(z + 0.2f));
                GL11.glVertex3d((double)(x + 0.5f), (double)y, (double)(z + 0.05f));
                GL11.glVertex3d((double)(x + 0.4f), (double)y, (double)(z + 0.8f));
                GL11.glVertex3d((double)(x + 0.5f), (double)y, (double)(z + 0.95f));
                GL11.glVertex3d((double)(x + 0.6f), (double)y, (double)(z + 0.8f));
                GL11.glVertex3d((double)(x + 0.5f), (double)y, (double)(z + 0.95f));
                GL11.glVertex3d((double)(x + 0.2f), (double)y, (double)(z + 0.4f));
                GL11.glVertex3d((double)(x + 0.05f), (double)y, (double)(z + 0.5f));
                GL11.glVertex3d((double)(x + 0.2f), (double)y, (double)(z + 0.6f));
                GL11.glVertex3d((double)(x + 0.05f), (double)y, (double)(z + 0.5f));
                GL11.glVertex3d((double)(x + 0.8f), (double)y, (double)(z + 0.4f));
                GL11.glVertex3d((double)(x + 0.95f), (double)y, (double)(z + 0.5f));
                GL11.glVertex3d((double)(x + 0.8f), (double)y, (double)(z + 0.6f));
                GL11.glVertex3d((double)(x + 0.95f), (double)y, (double)(z + 0.5f));
                RenderSystem.color4f((float)0.0f, (float)178.0f, (float)0.0f, (float)255.0f);
                GL11.glVertex3d((double)(x + 0.4f), (double)y, (double)(z + 0.5f));
                GL11.glVertex3d((double)(x + 0.5f), (double)y, (double)(z + 0.4f));
                GL11.glVertex3d((double)(x + 0.4f), (double)y, (double)(z + 0.5f));
                GL11.glVertex3d((double)(x + 0.5f), (double)y, (double)(z + 0.6f));
                GL11.glVertex3d((double)(x + 0.6f), (double)y, (double)(z + 0.5f));
                GL11.glVertex3d((double)(x + 0.5f), (double)y, (double)(z + 0.6f));
                GL11.glVertex3d((double)(x + 0.5f), (double)y, (double)(z + 0.4f));
                GL11.glVertex3d((double)(x + 0.6f), (double)y, (double)(z + 0.5f));
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)178.0f, (float)255.0f);
                GL11.glVertex3d((double)(x + 0.1f), (double)y, (double)(z + 0.1f));
                GL11.glVertex3d((double)(x + 0.2f), (double)y, (double)(z + 0.14f));
                GL11.glVertex3d((double)(x + 0.1f), (double)y, (double)(z + 0.1f));
                GL11.glVertex3d((double)(x + 0.14f), (double)y, (double)(z + 0.2f));
                GL11.glVertex3d((double)(x + 0.9f), (double)y, (double)(z + 0.9f));
                GL11.glVertex3d((double)(x + 0.8f), (double)y, (double)(z + 0.86f));
                GL11.glVertex3d((double)(x + 0.9f), (double)y, (double)(z + 0.9f));
                GL11.glVertex3d((double)(x + 0.86f), (double)y, (double)(z + 0.8f));
                GL11.glVertex3d((double)(x + 0.9f), (double)y, (double)(z + 0.1f));
                GL11.glVertex3d((double)(x + 0.8f), (double)y, (double)(z + 0.14f));
                GL11.glVertex3d((double)(x + 0.9f), (double)y, (double)(z + 0.1f));
                GL11.glVertex3d((double)(x + 0.86f), (double)y, (double)(z + 0.2f));
                GL11.glVertex3d((double)(x + 0.1f), (double)y, (double)(z + 0.9f));
                GL11.glVertex3d((double)(x + 0.2f), (double)y, (double)(z + 0.86f));
                GL11.glVertex3d((double)(x + 0.1f), (double)y, (double)(z + 0.9f));
                GL11.glVertex3d((double)(x + 0.14f), (double)y, (double)(z + 0.8f));
                break;
            }
            case SOUTH: 
            case NORTH: {
                RenderSystem.color4f((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
                GL11.glVertex3d((double)x, (double)y, (double)z);
                GL11.glVertex3d((double)(x + 1.0f), (double)y, (double)z);
                GL11.glVertex3d((double)x, (double)y, (double)z);
                GL11.glVertex3d((double)x, (double)(y + 1.0f * h), (double)z);
                GL11.glVertex3d((double)(x + 1.0f), (double)y, (double)z);
                GL11.glVertex3d((double)(x + 1.0f), (double)(y + 1.0f * h), (double)z);
                GL11.glVertex3d((double)x, (double)(y + 1.0f * h), (double)z);
                GL11.glVertex3d((double)(x + 1.0f), (double)(y + 1.0f * h), (double)z);
                GL11.glVertex3d((double)x, (double)(y + 0.25f * h), (double)z);
                GL11.glVertex3d((double)(x + 1.0f), (double)(y + 0.25f * h), (double)z);
                GL11.glVertex3d((double)x, (double)(y + 0.75f * h), (double)z);
                GL11.glVertex3d((double)(x + 1.0f), (double)(y + 0.75f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.25f), (double)y, (double)z);
                GL11.glVertex3d((double)(x + 0.25f), (double)(y + 1.0f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.75f), (double)y, (double)z);
                GL11.glVertex3d((double)(x + 0.75f), (double)(y + 1.0f * h), (double)z);
                RenderSystem.color4f((float)178.0f, (float)0.0f, (float)0.0f, (float)255.0f);
                GL11.glVertex3d((double)(x + 0.4f), (double)(y + 0.2f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.5f), (double)(y + 0.05f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.6f), (double)(y + 0.2f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.5f), (double)(y + 0.05f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.4f), (double)(y + 0.8f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.5f), (double)(y + 0.95f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.6f), (double)(y + 0.8f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.5f), (double)(y + 0.95f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.2f), (double)(y + 0.4f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.05f), (double)(y + 0.5f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.2f), (double)(y + 0.6f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.05f), (double)(y + 0.5f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.8f), (double)(y + 0.4f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.95f), (double)(y + 0.5f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.8f), (double)(y + 0.6f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.95f), (double)(y + 0.5f * h), (double)z);
                RenderSystem.color4f((float)0.0f, (float)178.0f, (float)0.0f, (float)255.0f);
                GL11.glVertex3d((double)(x + 0.4f), (double)(y + 0.5f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.5f), (double)(y + 0.4f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.4f), (double)(y + 0.5f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.5f), (double)(y + 0.6f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.6f), (double)(y + 0.5f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.5f), (double)(y + 0.6f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.5f), (double)(y + 0.4f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.6f), (double)(y + 0.5f * h), (double)z);
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
                GL11.glVertex3d((double)(x + 0.1f), (double)(y + 0.1f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.2f), (double)(y + 0.14f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.1f), (double)(y + 0.1f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.14f), (double)(y + 0.2f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.9f), (double)(y + 0.9f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.8f), (double)(y + 0.86f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.9f), (double)(y + 0.9f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.86f), (double)(y + 0.8f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.9f), (double)(y + 0.1f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.8f), (double)(y + 0.14f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.9f), (double)(y + 0.1f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.86f), (double)(y + 0.2f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.1f), (double)(y + 0.9f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.2f), (double)(y + 0.86f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.1f), (double)(y + 0.9f * h), (double)z);
                GL11.glVertex3d((double)(x + 0.14f), (double)(y + 0.8f * h), (double)z);
                break;
            }
            case EAST: 
            case WEST: {
                RenderSystem.color4f((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
                GL11.glVertex3d((double)x, (double)y, (double)z);
                GL11.glVertex3d((double)x, (double)(y + 1.0f * h), (double)z);
                GL11.glVertex3d((double)x, (double)y, (double)z);
                GL11.glVertex3d((double)x, (double)y, (double)(z + 1.0f));
                GL11.glVertex3d((double)x, (double)(y + 1.0f * h), (double)z);
                GL11.glVertex3d((double)x, (double)(y + 1.0f * h), (double)(z + 1.0f));
                GL11.glVertex3d((double)x, (double)y, (double)(z + 1.0f));
                GL11.glVertex3d((double)x, (double)(y + 1.0f * h), (double)(z + 1.0f));
                GL11.glVertex3d((double)x, (double)y, (double)(z + 0.25f));
                GL11.glVertex3d((double)x, (double)(y + 1.0f * h), (double)(z + 0.25f));
                GL11.glVertex3d((double)x, (double)y, (double)(z + 0.75f));
                GL11.glVertex3d((double)x, (double)(y + 1.0f * h), (double)(z + 0.75f));
                GL11.glVertex3d((double)x, (double)(y + 0.25f * h), (double)z);
                GL11.glVertex3d((double)x, (double)(y + 0.25f * h), (double)(z + 1.0f));
                GL11.glVertex3d((double)x, (double)(y + 0.75f * h), (double)z);
                GL11.glVertex3d((double)x, (double)(y + 0.75f * h), (double)(z + 1.0f));
                RenderSystem.color4f((float)178.0f, (float)0.0f, (float)0.0f, (float)255.0f);
                GL11.glVertex3d((double)x, (double)(y + 0.4f * h), (double)(z + 0.2f));
                GL11.glVertex3d((double)x, (double)(y + 0.5f * h), (double)(z + 0.05f));
                GL11.glVertex3d((double)x, (double)(y + 0.6f * h), (double)(z + 0.2f));
                GL11.glVertex3d((double)x, (double)(y + 0.5f * h), (double)(z + 0.05f));
                GL11.glVertex3d((double)x, (double)(y + 0.4f * h), (double)(z + 0.8f));
                GL11.glVertex3d((double)x, (double)(y + 0.5f * h), (double)(z + 0.95f));
                GL11.glVertex3d((double)x, (double)(y + 0.6f * h), (double)(z + 0.8f));
                GL11.glVertex3d((double)x, (double)(y + 0.5f * h), (double)(z + 0.95f));
                GL11.glVertex3d((double)x, (double)(y + 0.2f * h), (double)(z + 0.4f));
                GL11.glVertex3d((double)x, (double)(y + 0.05f * h), (double)(z + 0.5f));
                GL11.glVertex3d((double)x, (double)(y + 0.2f * h), (double)(z + 0.6f));
                GL11.glVertex3d((double)x, (double)(y + 0.05f * h), (double)(z + 0.5f));
                GL11.glVertex3d((double)x, (double)(y + 0.8f * h), (double)(z + 0.4f));
                GL11.glVertex3d((double)x, (double)(y + 0.95f * h), (double)(z + 0.5f));
                GL11.glVertex3d((double)x, (double)(y + 0.8f * h), (double)(z + 0.6f));
                GL11.glVertex3d((double)x, (double)(y + 0.95f * h), (double)(z + 0.5f));
                RenderSystem.color4f((float)178.0f, (float)255.0f, (float)255.0f, (float)255.0f);
                GL11.glVertex3d((double)x, (double)(y + 0.4f * h), (double)(z + 0.5f));
                GL11.glVertex3d((double)x, (double)(y + 0.5f * h), (double)(z + 0.4f));
                GL11.glVertex3d((double)x, (double)(y + 0.4f * h), (double)(z + 0.5f));
                GL11.glVertex3d((double)x, (double)(y + 0.5f * h), (double)(z + 0.6f));
                GL11.glVertex3d((double)x, (double)(y + 0.6f * h), (double)(z + 0.5f));
                GL11.glVertex3d((double)x, (double)(y + 0.5f * h), (double)(z + 0.6f));
                GL11.glVertex3d((double)x, (double)(y + 0.5f * h), (double)(z + 0.4f));
                GL11.glVertex3d((double)x, (double)(y + 0.6f * h), (double)(z + 0.5f));
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
                GL11.glVertex3d((double)x, (double)(y + 0.1f * h), (double)(z + 0.1f));
                GL11.glVertex3d((double)x, (double)(y + 0.2f * h), (double)(z + 0.14f));
                GL11.glVertex3d((double)x, (double)(y + 0.1f * h), (double)(z + 0.1f));
                GL11.glVertex3d((double)x, (double)(y + 0.14f * h), (double)(z + 0.2f));
                GL11.glVertex3d((double)x, (double)(y + 0.9f * h), (double)(z + 0.9f));
                GL11.glVertex3d((double)x, (double)(y + 0.8f * h), (double)(z + 0.86f));
                GL11.glVertex3d((double)x, (double)(y + 0.9f * h), (double)(z + 0.9f));
                GL11.glVertex3d((double)x, (double)(y + 0.86f * h), (double)(z + 0.8f));
                GL11.glVertex3d((double)x, (double)(y + 0.9f * h), (double)(z + 0.1f));
                GL11.glVertex3d((double)x, (double)(y + 0.8f * h), (double)(z + 0.14f));
                GL11.glVertex3d((double)x, (double)(y + 0.9f * h), (double)(z + 0.1f));
                GL11.glVertex3d((double)x, (double)(y + 0.86f * h), (double)(z + 0.2f));
                GL11.glVertex3d((double)x, (double)(y + 0.1f * h), (double)(z + 0.9f));
                GL11.glVertex3d((double)x, (double)(y + 0.2f * h), (double)(z + 0.86f));
                GL11.glVertex3d((double)x, (double)(y + 0.1f * h), (double)(z + 0.9f));
                GL11.glVertex3d((double)x, (double)(y + 0.14f * h), (double)(z + 0.8f));
            }
        }
    }

    private static void prev_drawCircle(int xc, int yc, int zc, int x, int y, int z, int plane) {
        switch (plane) {
            case 0: {
                WandsBaseRenderer.preview(xc + x, yc, zc + z, xc + x + 1, yc + 1, zc + z + 1);
                WandsBaseRenderer.preview(xc - x, yc, zc + z, xc - x + 1, yc + 1, zc + z + 1);
                WandsBaseRenderer.preview(xc + x, yc, zc - z, xc + x + 1, yc + 1, zc - z + 1);
                WandsBaseRenderer.preview(xc - x, yc, zc - z, xc - x + 1, yc + 1, zc - z + 1);
                WandsBaseRenderer.preview(xc + z, yc, zc + x, xc + z + 1, yc + 1, zc + x + 1);
                WandsBaseRenderer.preview(xc - z, yc, zc + x, xc - z + 1, yc + 1, zc + x + 1);
                WandsBaseRenderer.preview(xc + z, yc, zc - x, xc + z + 1, yc + 1, zc - x + 1);
                WandsBaseRenderer.preview(xc - z, yc, zc - x, xc - z + 1, yc + 1, zc - x + 1);
                break;
            }
            case 1: {
                WandsBaseRenderer.preview(xc + x, yc + y, zc, xc + x + 1, yc + y + 1, zc + 1);
                WandsBaseRenderer.preview(xc - x, yc + y, zc, xc - x + 1, yc + y + 1, zc + 1);
                WandsBaseRenderer.preview(xc + x, yc - y, zc, xc + x + 1, yc - y + 1, zc + 1);
                WandsBaseRenderer.preview(xc - x, yc - y, zc, xc - x + 1, yc - y + 1, zc + 1);
                WandsBaseRenderer.preview(xc + y, yc + x, zc, xc + y + 1, yc + x + 1, zc + 1);
                WandsBaseRenderer.preview(xc - y, yc + x, zc, xc - y + 1, yc + x + 1, zc + 1);
                WandsBaseRenderer.preview(xc + y, yc - x, zc, xc + y + 1, yc - x + 1, zc + 1);
                WandsBaseRenderer.preview(xc - y, yc - x, zc, xc - y + 1, yc - x + 1, zc + 1);
                break;
            }
            case 2: {
                WandsBaseRenderer.preview(xc, yc + y, zc + z, xc + 1, yc + y + 1, zc + z + 1);
                WandsBaseRenderer.preview(xc, yc - y, zc + z, xc + 1, yc - y + 1, zc + z + 1);
                WandsBaseRenderer.preview(xc, yc + y, zc - z, xc + 1, yc + y + 1, zc - z + 1);
                WandsBaseRenderer.preview(xc, yc - y, zc - z, xc + 1, yc - y + 1, zc - z + 1);
                WandsBaseRenderer.preview(xc, yc + z, zc + y, xc + 1, yc + z + 1, zc + y + 1);
                WandsBaseRenderer.preview(xc, yc - z, zc + y, xc + 1, yc - z + 1, zc + y + 1);
                WandsBaseRenderer.preview(xc, yc + z, zc - y, xc + 1, yc + z + 1, zc - y + 1);
                WandsBaseRenderer.preview(xc, yc - z, zc - y, xc + 1, yc - z + 1, zc - y + 1);
            }
        }
    }

    private static void circle(BlockPos pos0, BlockPos pos1, int plane) {
        block4: {
            int zc;
            int yc;
            int xc;
            int r;
            block5: {
                block3: {
                    r = 1;
                    xc = pos0.func_177958_n();
                    yc = pos0.func_177956_o();
                    zc = pos0.func_177952_p();
                    int px = pos1.func_177958_n() - pos0.func_177958_n();
                    int py = pos1.func_177956_o() - pos0.func_177956_o();
                    int pz = pos1.func_177952_p() - pos0.func_177952_p();
                    r = (int)Math.sqrt(px * px + py * py + pz * pz);
                    if (plane != 0) break block3;
                    int x = 0;
                    int y = 0;
                    int z = r;
                    int d = 3 - 2 * r;
                    WandsBaseRenderer.prev_drawCircle(xc, yc, zc, x, y, z, plane);
                    while (z >= x) {
                        d = d > 0 ? d + 4 * (x - --z) + 10 : d + 4 * ++x + 6;
                        WandsBaseRenderer.prev_drawCircle(xc, yc, zc, x, y, z, plane);
                    }
                    break block4;
                }
                if (plane != 1) break block5;
                int x = 0;
                int y = r;
                int z = 0;
                int d = 3 - 2 * r;
                WandsBaseRenderer.prev_drawCircle(xc, yc, zc, x, y, z, plane);
                while (y >= x) {
                    d = d > 0 ? d + 4 * (x - --y) + 10 : d + 4 * ++x + 6;
                    WandsBaseRenderer.prev_drawCircle(xc, yc, zc, x, y, z, plane);
                }
                break block4;
            }
            if (plane != 2) break block4;
            int x = 0;
            int y = 0;
            int z = r;
            int d = 3 - 2 * r;
            WandsBaseRenderer.prev_drawCircle(xc, yc, zc, x, y, z, plane);
            while (z >= y) {
                d = d > 0 ? d + 4 * (y - --z) + 10 : d + 4 * ++y + 6;
                WandsBaseRenderer.prev_drawCircle(xc, yc, zc, x, y, z, plane);
            }
        }
    }

    private static void line(BlockPos pos0, BlockPos pos1) {
        int x1 = pos0.func_177958_n();
        int y1 = pos0.func_177956_o();
        int z1 = pos0.func_177952_p();
        int x2 = pos1.func_177958_n();
        int y2 = pos1.func_177956_o();
        int z2 = pos1.func_177952_p();
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int dz = Math.abs(z2 - z1);
        int xs = x2 > x1 ? 1 : -1;
        int ys = y2 > y1 ? 1 : -1;
        int zs = z2 > z1 ? 1 : -1;
        WandsBaseRenderer.preview(x1, y1, z1, x1 + 1, y1 + 1, z1 + 1);
        if (dx >= dy && dx >= dz) {
            int p1 = 2 * dy - dx;
            int p2 = 2 * dz - dx;
            while (x1 != x2) {
                x1 += xs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dx;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dx;
                }
                p1 += 2 * dy;
                p2 += 2 * dz;
                WandsBaseRenderer.preview(x1, y1, z1, x1 + 1, y1 + 1, z1 + 1);
            }
        } else if (dy >= dx && dy >= dz) {
            int p1 = 2 * dx - dy;
            int p2 = 2 * dz - dy;
            while (y1 != y2) {
                y1 += ys;
                if (p1 >= 0) {
                    x1 += xs;
                    p1 -= 2 * dy;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dy;
                }
                p1 += 2 * dx;
                p2 += 2 * dz;
                WandsBaseRenderer.preview(x1, y1, z1, x1 + 1, y1 + 1, z1 + 1);
            }
        } else {
            int p1 = 2 * dy - dz;
            int p2 = 2 * dx - dz;
            while (z1 != z2) {
                z1 += zs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dz;
                }
                if (p2 >= 0) {
                    x1 += xs;
                    p2 -= 2 * dz;
                }
                p1 += 2 * dy;
                p2 += 2 * dx;
                WandsBaseRenderer.preview(x1, y1, z1, x1 + 1, y1 + 1, z1 + 1);
            }
        }
    }

    public static class BlockBuffer {
        public BlockPos[] buffer = null;
        public int max = 0;
        public int length = 0;

        public BlockBuffer(int n) {
            this.max = n;
            this.buffer = new BlockPos[this.max];
        }

        boolean in_buffer(BlockPos p) {
            for (int i = 0; i < this.length && i < this.max; ++i) {
                if (!p.equals((Object)this.buffer[i])) continue;
                return true;
            }
            return false;
        }

        void add_buffer(BlockPos p) {
            if (this.length < this.max) {
                this.buffer[this.length] = p;
                ++this.length;
            }
        }
    }
}

