/*
 * Decompiled with CFR 0.152.
 */
package net.nicguzzo.common;

import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.nicguzzo.WandsMod;

public class WandsConfig {
    public static final String[] default_allowed = new String[]{"minecraft:soul_sand"};
    public static final String[] default_denied = new String[0];
    public float blocks_per_xp = 0.0f;
    public int stone_wand_limit = 9;
    public int iron_wand_limit = 25;
    public int diamond_wand_limit = 49;
    public int netherite_wand_limit = 81;
    public int stone_wand_durability = 131;
    public int iron_wand_durability = 250;
    public int diamond_wand_durability = 1561;
    public int netherite_wand_durability = 2031;
    public boolean destroy_in_survival_drop = true;
    public String[] str_allowed;
    public String[] str_denied;
    public static List<Block> allowed = new ArrayList<Block>();
    public static List<Block> denied = new ArrayList<Block>();

    public WandsConfig(float bpxp, int s_l, int i_l, int d_l, int n_l, int s_d, int i_d, int d_d, int n_d, String[] a, String[] d, boolean disd) {
        if (bpxp >= 0.0f) {
            this.blocks_per_xp = bpxp;
        }
        this.stone_wand_limit = s_l;
        this.iron_wand_limit = i_l;
        this.diamond_wand_limit = d_l;
        this.netherite_wand_limit = n_l;
        this.stone_wand_durability = s_d;
        this.iron_wand_durability = i_d;
        this.diamond_wand_durability = d_d;
        this.netherite_wand_durability = n_d;
        this.str_allowed = a;
        this.str_denied = d;
        this.destroy_in_survival_drop = disd;
    }

    public WandsConfig() {
        this(0.0f, 9, 27, 49, 81, 131, 250, 1561, 2031, default_allowed, default_denied, true);
    }

    public void generate_lists() {
        Block blk;
        System.out.println("generating allow/deny lists");
        for (String id : this.str_allowed) {
            blk = WandsMod.compat.block_from_id(id);
            if (blk == null) continue;
            allowed.add(blk);
        }
        for (String id : this.str_denied) {
            blk = WandsMod.compat.block_from_id(id);
            if (blk == null) continue;
            denied.add(blk);
        }
    }

    public String toString() {
        return "blocks_per_xp: " + this.blocks_per_xp;
    }

    public boolean equals(WandsConfig config) {
        return config.blocks_per_xp == this.blocks_per_xp;
    }

    public static void save_conf(WandsConfig config, File configFile) {
        try (FileWriter writer = new FileWriter(configFile);){
            GsonBuilder gson = new GsonBuilder();
            writer.write(gson.setPrettyPrinting().create().toJson((Object)config));
        }
        catch (IOException e2) {
            System.out.println("Failed to generate config file!");
        }
    }

    public static WandsConfig load_config(Path confdir) {
        WandsConfig config = null;
        System.out.println("load_config dir: " + confdir);
        File configFile = new File(confdir.toString(), "wands.json");
        try (FileReader reader = new FileReader(configFile);){
            GsonBuilder gson = new GsonBuilder();
            config = (WandsConfig)gson.create().fromJson((Reader)reader, WandsConfig.class);
            WandsConfig.save_conf(config, configFile);
            System.out.println("Config loaded!");
        }
        catch (IOException e) {
            System.out.println("No config found, generating!");
            WandsConfig.save_conf(new WandsConfig(), configFile);
        }
        if (config == null) {
            config = new WandsConfig();
        }
        return config;
    }
}

