/*
 * Decompiled with CFR 0.152.
 */
package com.tsaky.camoucreepers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.command.arguments.BlockStateArgument;

public class RenderSettingsList {
    private static final ArrayList<Block> ignoreBlocks = new ArrayList();
    private static final Map<Block, Block> overrideBlocks = new HashMap<Block, Block>();
    private static final ArrayList<Block> doNoReplaceSideWithTopList = new ArrayList();

    static void initializeBlockLists() {
        try {
            InputStream is = RenderSettingsList.class.getResourceAsStream("/assets/camoucreepers/json/render_settings.json");
            JsonObject rootElement = new JsonParser().parse((Reader)new BufferedReader(new InputStreamReader(is))).getAsJsonObject();
            JsonArray ignoreArray = rootElement.get("ignore_list").getAsJsonArray();
            JsonArray overrideArray = rootElement.get("override_list").getAsJsonArray();
            JsonArray doNotReplaceSideWithTopArray = rootElement.get("do_not_replace_side_with_top_list").getAsJsonArray();
            int i = 0;
            for (JsonElement element : ignoreArray) {
                ++i;
                ignoreBlocks.add(new BlockStateArgument().parse(new StringReader(element.getAsString())).func_197231_a().func_177230_c());
            }
            System.out.println("Will ignore " + i + " blocks");
            i = 0;
            for (JsonElement element : overrideArray) {
                ++i;
                JsonArray array = element.getAsJsonArray();
                Block blockA = new BlockStateArgument().parse(new StringReader(array.get(0).getAsString())).func_197231_a().func_177230_c();
                Block blockB = new BlockStateArgument().parse(new StringReader(array.get(1).getAsString())).func_197231_a().func_177230_c();
                overrideBlocks.put(blockA, blockB);
            }
            System.out.println("Will override texture for " + i + " blocks");
            i = 0;
            for (JsonElement element : doNotReplaceSideWithTopArray) {
                ++i;
                doNoReplaceSideWithTopList.add(new BlockStateArgument().parse(new StringReader(element.getAsString())).func_197231_a().func_177230_c());
            }
            System.out.println("Will not replace side with top for " + i + " blocks");
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
    }

    public static boolean ignoreBlock(Block block) {
        return ignoreBlocks.contains(block);
    }

    public static Block getBlockOverrideSetting(Block block) {
        return overrideBlocks.get(block);
    }

    public static boolean shouldReplaceSideWithTop(Block block) {
        return !doNoReplaceSideWithTopList.contains(block);
    }
}

