/*
 * Decompiled with CFR 0.152.
 */
package com.tsaky.camoucreepers;

import com.tsaky.camoucreepers.TextureCreator;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;

public class TextureCache {
    private static final ArrayList<TextureCacheEntry> textureCacheEntries = new ArrayList();

    public static void addEntryForBlockState(ResourceLocation resourceLocation, BlockState blockState, Color intensity) {
        if (resourceLocation != TextureCreator.DEFAULT_TEXTURE) {
            textureCacheEntries.add(new TextureCacheEntry(resourceLocation, blockState, intensity));
        }
    }

    public static ResourceLocation getResourceLocationForBlockState(BlockState blockState, Color intensity) {
        for (TextureCacheEntry textureCacheEntry : textureCacheEntries) {
            if (textureCacheEntry.blockState != blockState || !textureCacheEntry.intensity.equals(intensity)) continue;
            return textureCacheEntry.resourceLocation;
        }
        return null;
    }

    private static class TextureCacheEntry {
        private final ResourceLocation resourceLocation;
        private final BlockState blockState;
        private final Color intensity;

        public TextureCacheEntry(ResourceLocation resourceLocation, BlockState blockState, Color intensity) {
            this.resourceLocation = resourceLocation;
            this.blockState = blockState;
            this.intensity = intensity;
        }
    }
}

