/*
 * Decompiled with CFR 0.152.
 */
package com.tsaky.camoucreepers;

import com.tsaky.camoucreepers.RenderSettingsList;
import com.tsaky.camoucreepers.TextureCache;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextureCreator {
    static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("textures/entity/creeper/creeper.png");
    private static final ResourceLocation CREEPER_OVERLAY_TEXTURE = new ResourceLocation("camoucreepers", "textures/creeper_overlay.png");
    private static final ResourceLocation GRASS_TOP_TEXTURE = new ResourceLocation("camoucreepers", "textures/grass_top.png");
    private static final ResourceLocation LGBTQ_TEXTURE = new ResourceLocation("camoucreepers", "textures/lgbtq.png");

    public static ResourceLocation getTextureFromCache(World world, BlockPos blockPos) throws IOException {
        ResourceLocation resourceLocation;
        BlockState blockState = world.func_180495_p(blockPos);
        Biome biome = world.func_226691_t_(blockPos);
        Color intensity = TextureCreator.calculateIntensity(world, biome, blockPos);
        Block replacement = RenderSettingsList.getBlockOverrideSetting(blockState.func_177230_c());
        if (replacement != null) {
            blockState = replacement.func_176223_P();
        }
        if ((resourceLocation = TextureCache.getResourceLocationForBlockState(blockState, intensity)) == null) {
            resourceLocation = TextureCreator.generateTexture(world, blockPos, blockState, intensity);
            TextureCache.addEntryForBlockState(resourceLocation, blockState, intensity);
        }
        return resourceLocation;
    }

    private static ResourceLocation generateTexture(World world, BlockPos pos, BlockState blockState, Color intensity) throws IOException {
        Block block = blockState.func_177230_c();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().getTexture(blockState, world, pos);
        ResourceLocation resourceLocation = RenderSettingsList.shouldReplaceSideWithTop(block) ? new ResourceLocation(sprite.func_195668_m().func_110624_b(), "textures/" + sprite.func_195668_m().func_110623_a().replace("side", "top") + ".png") : new ResourceLocation(sprite.func_195668_m().func_110624_b(), "textures/" + sprite.func_195668_m().func_110623_a() + ".png");
        if (resourceLocation.toString().equals("minecraft:textures/missingno.png")) {
            return DEFAULT_TEXTURE;
        }
        if (block == Blocks.field_196658_i) {
            resourceLocation = GRASS_TOP_TEXTURE;
        }
        BufferedImage blockImage = ImageIO.read(Minecraft.func_71410_x().func_195551_G().func_199002_a(resourceLocation).func_199027_b());
        BufferedImage overlayImage = ImageIO.read(Minecraft.func_71410_x().func_195551_G().func_199002_a(CREEPER_OVERLAY_TEXTURE).func_199027_b());
        if (blockImage == null || overlayImage == null) {
            return DEFAULT_TEXTURE;
        }
        NativeImage nativeImage = new NativeImage(NativeImage.PixelFormat.RGBA, 64, 32, false);
        nativeImage.func_195715_a(0, 0, 64, 32, new Color(0, 0, 0, 0).getRGB());
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 32; ++y) {
                Color a = new Color(blockImage.getRGB(x % 16, y % 16), true);
                Color b = new Color(overlayImage.getRGB(x, y), true);
                Color result = new Color(TextureCreator.addColors(a, b, intensity), true);
                nativeImage.func_195700_a(x, y, result.getRGB());
            }
        }
        return Minecraft.func_71410_x().func_110434_K().func_110578_a("camoucreepers", new DynamicTexture(nativeImage));
    }

    private static int addColors(Color base, Color overlay, Color intensity) {
        float ratio = (float)overlay.getAlpha() / 255.0f;
        int r = (int)(((float)base.getRed() * (1.0f - ratio) + (float)overlay.getRed() * ratio) * (float)intensity.getRed() / 255.0f);
        int g = (int)(((float)base.getGreen() * (1.0f - ratio) + (float)overlay.getGreen() * ratio) * (float)intensity.getGreen() / 255.0f);
        int b = (int)(((float)base.getBlue() * (1.0f - ratio) + (float)overlay.getBlue() * ratio) * (float)intensity.getBlue() / 255.0f);
        int a = base.getAlpha();
        return new Color(b, g, r, a).getRGB();
    }

    private static Color calculateIntensity(World world, Biome biome, BlockPos blockPos) {
        BlockState blockState = world.func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_196658_i || block == Blocks.field_150349_c || block == Blocks.field_196804_gh) {
            return new Color(biome.func_225528_a_((double)blockPos.func_177958_n(), (double)blockPos.func_177952_p()));
        }
        if (block == Blocks.field_150355_j) {
            return new Color(biome.func_185361_o());
        }
        if (blockState.func_185904_a() == Material.field_151584_j) {
            return new Color(biome.func_225527_a_());
        }
        return Color.WHITE;
    }
}

