/*
 * Decompiled with CFR 0.152.
 */
package georgetsak.camouflagecreepers;

import georgetsak.camouflagecreepers.AICCreeperSwell;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCCreeper
extends EntityMob {
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 3;
    private int field_175494_bm = 0;

    public EntityCCreeper(World worldIn) {
        super(worldIn);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AICCreeperSwell(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)-1);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.field_70180_af.func_75683_a(17) == 1) {
            tagCompound.func_74757_a("powered", true);
        }
        tagCompound.func_74777_a("Fuse", (short)this.fuseTime);
        tagCompound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        tagCompound.func_74757_a("ignited", this.hasIgnited());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.field_70180_af.func_75692_b(17, (Object)((byte)(tagCompund.func_74767_n("powered") ? 1 : 0)));
        if (tagCompund.func_150297_b("Fuse", 99)) {
            this.fuseTime = tagCompund.func_74765_d("Fuse");
        }
        if (tagCompund.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = tagCompund.func_74771_c("ExplosionRadius");
        }
        if (tagCompund.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_85030_a("creeper.primed", 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    protected String func_70621_aR() {
        return "mob.creeper.say";
    }

    protected String func_70673_aS() {
        return "mob.creeper.death";
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76346_g() instanceof EntitySkeleton) {
            int i = Item.func_150891_b((Item)Items.field_151096_cd);
            int j = Item.func_150891_b((Item)Items.field_151084_co);
            int k = i + this.field_70146_Z.nextInt(j - i + 1);
            this.func_145779_a(Item.func_150899_d((int)k), 1);
        } else if (cause.func_76346_g() instanceof EntityCCreeper && cause.func_76346_g() != this && ((EntityCCreeper)cause.func_76346_g()).getPowered() && ((EntityCCreeper)cause.func_76346_g()).isAIEnabled()) {
            ((EntityCCreeper)cause.func_76346_g()).func_175493_co();
            this.func_70099_a(new ItemStack(Items.field_151144_bL, 1, 4), 0.0f);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        return true;
    }

    public boolean getPowered() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    protected Item func_146068_u() {
        return Items.field_151016_H;
    }

    public int getCreeperState() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)state));
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.field_70180_af.func_75692_b(17, (Object)1);
    }

    protected boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "fire.ignite", 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_71038_i();
            if (!this.field_70170_p.field_72995_K) {
                this.ignite();
                itemstack.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        return super.func_70085_c(player);
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            float f = this.getPowered() ? 2.0f : 1.0f;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionRadius * f, flag);
            this.func_70106_y();
        }
    }

    public boolean hasIgnited() {
        return this.field_70180_af.func_75683_a(18) != 0;
    }

    public void ignite() {
        this.field_70180_af.func_75692_b(18, (Object)1);
    }

    public boolean isAIEnabled() {
        return this.field_175494_bm < 1 && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot");
    }

    public void func_175493_co() {
        ++this.field_175494_bm;
    }
}

