/*
 * Decompiled with CFR 0.152.
 */
package georgetsak.camoucreepers.CamouCreeper;

import georgetsak.camoucreepers.CamouCreeper.LayerCamouCreeperCharge;
import georgetsak.camoucreepers.CamouCreeper.LayerCreeperFace;
import georgetsak.camoucreepers.CamouCreeper.ModelCamouCreeper;
import georgetsak.camoucreepers.CamouflagedCreepers;
import georgetsak.camoucreepers.ClientProxy;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderCamouCreeper
extends RenderLiving<EntityCreeper> {
    private static ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("camoucreepers", "creeper_original.png");
    private static ResourceLocation FARMLAND_DRY = new ResourceLocation("camoucreepers", "blocks/farmland_dry.png");
    private static ResourceLocation FARMLAND_WET = new ResourceLocation("camoucreepers", "blocks/farmland_wet.png");
    private static ResourceLocation GRASS = new ResourceLocation("camoucreepers", "blocks/grass.png");
    private static ResourceLocation GRASS_PATH_TOP = new ResourceLocation("camoucreepers", "blocks/grass_path_top.png");
    private static ResourceLocation HAY = new ResourceLocation("camoucreepers", "blocks/hay_block.png");
    private static ResourceLocation LEAVES_ACACIA = new ResourceLocation("camoucreepers", "blocks/leaves_acacia.png");
    private static ResourceLocation LEAVES_BIG_OAK = new ResourceLocation("camoucreepers", "blocks/leaves_big_oak.png");
    private static ResourceLocation LEAVES_BIRCH = new ResourceLocation("camoucreepers", "blocks/leaves_birch.png");
    private static ResourceLocation LEAVES_JUNGLE = new ResourceLocation("camoucreepers", "blocks/leaves_jungle.png");
    private static ResourceLocation LEAVES_OAK = new ResourceLocation("camoucreepers", "blocks/leaves_oak.png");
    private static ResourceLocation LEAVES_SPRUCE = new ResourceLocation("camoucreepers", "blocks/leaves_spruce.png");
    private static ResourceLocation MELON = new ResourceLocation("camoucreepers", "blocks/melon.png");
    private static ResourceLocation NOTEBLOCK = new ResourceLocation("camoucreepers", "blocks/noteblock.png");
    private static ResourceLocation PUMKIN = new ResourceLocation("camoucreepers", "blocks/pumpkin.png");
    private static ResourceLocation WATER = new ResourceLocation("camoucreepers", "blocks/water_overlay.png");

    public RenderCamouCreeper(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelCamouCreeper(), 0.5f);
        this.func_177094_a(new LayerCreeperFace(this));
        this.func_177094_a(new LayerCamouCreeperCharge(this));
    }

    protected void preRenderCallback(EntityCreeper entitylivingbaseIn, float partialTickTime) {
        float f = entitylivingbaseIn.func_70831_j(partialTickTime);
        float f1 = 1.0f + MathHelper.func_76126_a((float)(f * 100.0f)) * f * 0.01f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        GlStateManager.func_179152_a((float)f2, (float)f3, (float)f2);
    }

    protected int getColorMultiplier(EntityCreeper entitylivingbaseIn, float lightBrightness, float partialTickTime) {
        float f = entitylivingbaseIn.func_70831_j(partialTickTime);
        if ((int)(f * 10.0f) % 2 == 0) {
            return 0;
        }
        int i = (int)(f * 0.2f * 255.0f);
        i = MathHelper.func_76125_a((int)i, (int)0, (int)255);
        return i << 24 | 0x30FFFFFF;
    }

    protected ResourceLocation getEntityTexture(EntityCreeper entity) {
        BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u - 0.1, entity.field_70161_v);
        IBlockState blockState = entity.field_70170_p.func_180495_p(pos);
        IBlockState blockState2 = entity.field_70170_p.func_180495_p(pos.func_177977_b());
        IBlockState blockState3 = entity.field_70170_p.func_180495_p(pos.func_177963_a(0.0, 0.1, 0.0));
        if (blockState.func_177230_c() == Blocks.field_150350_a && blockState2.func_177230_c() != Blocks.field_150350_a) {
            blockState = blockState2;
        }
        if (blockState3.func_177230_c() != Blocks.field_150350_a) {
            blockState = blockState3;
        }
        Block b = blockState.func_177230_c();
        for (Block block : CamouflagedCreepers.blocksToIgnore) {
            if (block != b) continue;
            return DEFAULT_TEXTURE;
        }
        if (entity.func_70090_H() || b == Blocks.field_150355_j || b == Blocks.field_150358_i) {
            return WATER;
        }
        if (b == Blocks.field_150460_al || b == Blocks.field_150470_am || b == Blocks.field_190976_dk || b == Blocks.field_150367_z || b == Blocks.field_150409_cd || b == Blocks.field_150331_J || b == Blocks.field_150320_F || b == Blocks.field_180384_M || b == Blocks.field_150332_K) {
            blockState = Blocks.field_150347_e.func_176223_P();
        } else {
            if (b == Blocks.field_185774_da) {
                return GRASS_PATH_TOP;
            }
            if (b == Blocks.field_150458_ak) {
                if ((Integer)blockState.func_177229_b((IProperty)BlockFarmland.field_176531_a) > 0) {
                    return FARMLAND_WET;
                }
                return FARMLAND_DRY;
            }
            if (b == Blocks.field_150462_ai) {
                blockState = Blocks.field_150344_f.func_176223_P();
            } else {
                if (b == Blocks.field_150440_ba) {
                    return MELON;
                }
                if (b == Blocks.field_150423_aK) {
                    return PUMKIN;
                }
                if (b == Blocks.field_150381_bn) {
                    blockState = Blocks.field_150343_Z.func_176223_P();
                } else if (b == Blocks.field_150378_br) {
                    blockState = Blocks.field_150377_bs.func_176223_P();
                } else if (b == Blocks.field_150362_t || b == Blocks.field_150361_u) {
                    BlockPlanks.EnumType m;
                    if (blockState.func_177228_b().containsKey((Object)BlockNewLeaf.field_176240_P)) {
                        m = (BlockPlanks.EnumType)blockState.func_177229_b((IProperty)BlockNewLeaf.field_176240_P);
                        if (m == BlockPlanks.EnumType.ACACIA) {
                            return LEAVES_ACACIA;
                        }
                        if (m == BlockPlanks.EnumType.DARK_OAK) {
                            return LEAVES_BIG_OAK;
                        }
                    } else if (blockState.func_177228_b().containsKey((Object)BlockOldLeaf.field_176239_P)) {
                        m = (BlockPlanks.EnumType)blockState.func_177229_b((IProperty)BlockOldLeaf.field_176239_P);
                        if (m == BlockPlanks.EnumType.OAK) {
                            return LEAVES_OAK;
                        }
                        if (m == BlockPlanks.EnumType.BIRCH) {
                            return LEAVES_BIRCH;
                        }
                        if (m == BlockPlanks.EnumType.SPRUCE) {
                            return LEAVES_SPRUCE;
                        }
                        if (m == BlockPlanks.EnumType.JUNGLE) {
                            return LEAVES_JUNGLE;
                        }
                    }
                } else {
                    if (b == Blocks.field_150349_c) {
                        return GRASS;
                    }
                    if (b == Blocks.field_150323_B) {
                        return NOTEBLOCK;
                    }
                    if (b == Blocks.field_150407_cf) {
                        return HAY;
                    }
                }
            }
        }
        return ClientProxy.getTexture(blockState);
    }

    private ResourceLocation getResourceForBlockState(IBlockState blockState) {
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175602_ab().func_184389_a(blockState).func_177554_e();
        if (blockState.func_177230_c() == Blocks.field_150350_a || sprite.func_94215_i().contains("missingno")) {
            return new ResourceLocation("textures/entity/creeper/creeper.png");
        }
        return new ResourceLocation("camoucreepers", new ResourceLocation(sprite.func_94215_i().replace("side", "top") + ".png").func_110623_a());
    }

    protected void renderModel(EntityCreeper entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        boolean flag1;
        boolean flag = this.func_193115_c((EntityLivingBase)entitylivingbaseIn);
        boolean bl = flag1 = !flag && !entitylivingbaseIn.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (flag || flag1) {
            BlockPos pos;
            IBlockState state;
            if (!this.func_180548_c((Entity)entitylivingbaseIn)) {
                return;
            }
            if (flag1) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            if ((state = entitylivingbaseIn.field_70170_p.func_180495_p(pos = entitylivingbaseIn.func_180425_c().func_177977_b())).func_177230_c() == Blocks.field_150349_c) {
                Color color = new Color(entitylivingbaseIn.field_70170_p.func_180494_b(pos).func_180627_b(pos));
                GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
            } else if (state.func_177230_c() == Blocks.field_150362_t || state.func_177230_c() == Blocks.field_150361_u) {
                Color color = new Color(entitylivingbaseIn.field_70170_p.func_180494_b(pos).func_180625_c(pos));
                GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
            }
            this.field_77045_g.func_78088_a((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (flag1) {
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }
}

