/*
 * Decompiled with CFR 0.152.
 */
package georgetsak.camoucreepers;

import georgetsak.camoucreepers.CamouCreeper.RenderCamouCreeper;
import georgetsak.camoucreepers.CommonProxy;
import georgetsak.camoucreepers.TextureEntry;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ClientProxy
extends CommonProxy {
    public static ArrayList<TextureEntry> texturesEntries = new ArrayList();
    private static ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("camoucreepers", "creeper_original.png");

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        RenderingRegistry.registerEntityRenderingHandler(EntityCreeper.class, RenderCamouCreeper::new);
    }

    public static ResourceLocation getTexture(IBlockState state) {
        for (TextureEntry textureEntry : texturesEntries) {
            if (textureEntry.state != state) continue;
            return textureEntry.resourceLocation;
        }
        TextureEntry newTextureEntry = new TextureEntry(ClientProxy.generateTextureForBlockState(state), state);
        texturesEntries.add(newTextureEntry);
        return newTextureEntry.resourceLocation;
    }

    private static ResourceLocation generateTextureForBlockState(IBlockState blockState) {
        try {
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(blockState);
            String name = sprite.func_94215_i();
            int indexOfDot = name.indexOf(58);
            ResourceLocation loc = new ResourceLocation(name.substring(0, indexOfDot), "textures/" + name.substring(indexOfDot + 1, name.length()) + ".png");
            IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(loc);
            InputStream stream = res.func_110527_b();
            BufferedImage image = ImageIO.read(stream);
            BufferedImage bufferedImage = new BufferedImage(64, 32, 2);
            for (int x = 0; x < 64; ++x) {
                for (int y = 0; y < 32; ++y) {
                    int pixelX = x < 16 ? x : (x < 32 ? x - 16 : (x < 48 ? x - 32 : x - 48));
                    int pixelY = y < 16 ? y : y - 16;
                    bufferedImage.setRGB(x, y, image.getRGB(pixelX, pixelY));
                }
            }
            return Minecraft.func_71410_x().func_110434_K().func_110578_a("camoucreepers", new DynamicTexture(bufferedImage));
        }
        catch (Exception exception) {
            return DEFAULT_TEXTURE;
        }
    }
}

