/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.car.corelib.block.VoxelUtils;
import de.maxhenkel.car.items.ModItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class BlockGuardRail
extends BlockBase
implements IWaterLoggable {
    public static final BooleanProperty NORTH = BlockStateProperties.field_208151_D;
    public static final BooleanProperty SOUTH = BlockStateProperties.field_208153_F;
    public static final BooleanProperty EAST = BlockStateProperties.field_208152_E;
    public static final BooleanProperty WEST = BlockStateProperties.field_208154_G;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)2.0, (double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)16.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE = Block.func_208617_a((double)7.5, (double)0.0, (double)7.5, (double)8.5, (double)16.0, (double)8.5);

    public BlockGuardRail() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151668_h).func_200943_b(2.0f).func_200947_a(SoundType.field_222475_v).func_226896_b_());
        this.setRegistryName(new ResourceLocation("car", "guard_rail"));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BooleanProperty getProperty(Direction direction) {
        switch (direction) {
            default: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: 
        }
        return WEST;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = VoxelShapes.func_197880_a();
        if (((Boolean)state.func_177229_b((Property)NORTH)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_NORTH);
        }
        if (((Boolean)state.func_177229_b((Property)SOUTH)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_SOUTH);
        }
        if (((Boolean)state.func_177229_b((Property)EAST)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_EAST);
        }
        if (((Boolean)state.func_177229_b((Property)WEST)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_WEST);
        }
        if (shape.func_197766_b()) {
            shape = VoxelUtils.combine(shape, SHAPE);
        }
        return shape;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8));
        return (BlockState)state.func_206870_a((Property)this.getProperty(context.func_195992_f()), (Comparable)Boolean.valueOf(true));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, SOUTH, EAST, WEST, WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        drops.stream().filter(itemStack -> itemStack.func_77973_b() == ModItems.GUARD_RAIL).forEach(itemStack -> {
            if (itemStack.func_190916_E() == 1) {
                int amount = 0;
                if (((Boolean)state.func_177229_b((Property)NORTH)).booleanValue()) {
                    ++amount;
                }
                if (((Boolean)state.func_177229_b((Property)SOUTH)).booleanValue()) {
                    ++amount;
                }
                if (((Boolean)state.func_177229_b((Property)EAST)).booleanValue()) {
                    ++amount;
                }
                if (((Boolean)state.func_177229_b((Property)WEST)).booleanValue()) {
                    ++amount;
                }
                itemStack.func_190920_e(amount);
            }
        });
        return drops;
    }
}

