/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.blocks.BlockGui;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.item.ItemUtils;
import de.maxhenkel.car.recipes.EnergyFluidProducerRecipe;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class TileEntityEnergyFluidProducer
extends TileEntityBase
implements IEnergyStorage,
ISidedInventory,
ITickableTileEntity,
IFluidHandler {
    protected IRecipeType<? extends EnergyFluidProducerRecipe> recipeType;
    protected Inventory inventory;
    protected int maxEnergy;
    protected int storedEnergy;
    protected int time;
    protected int fluidAmount;
    protected int currentMillibuckets;
    public final IIntArray FIELDS = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TileEntityEnergyFluidProducer.this.time;
                }
                case 1: {
                    return TileEntityEnergyFluidProducer.this.storedEnergy;
                }
                case 2: {
                    return TileEntityEnergyFluidProducer.this.currentMillibuckets;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityEnergyFluidProducer.this.time = value;
                    break;
                }
                case 1: {
                    TileEntityEnergyFluidProducer.this.storedEnergy = value;
                    break;
                }
                case 2: {
                    TileEntityEnergyFluidProducer.this.currentMillibuckets = value;
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };

    public TileEntityEnergyFluidProducer(TileEntityType<?> tileEntityTypeIn, IRecipeType<? extends EnergyFluidProducerRecipe> recipeType) {
        super(tileEntityTypeIn);
        this.recipeType = recipeType;
        this.inventory = new Inventory(2);
        this.maxEnergy = 10000;
        this.storedEnergy = 0;
        this.time = 0;
        this.fluidAmount = 3000;
        this.currentMillibuckets = 0;
    }

    public EnergyFluidProducerRecipe getRecipe() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).orElse(null);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack input = this.inventory.func_70301_a(0);
        ItemStack output = this.inventory.func_70301_a(1);
        EnergyFluidProducerRecipe recipe = this.getRecipe();
        if (recipe == null) {
            this.time = 0;
            this.func_70296_d();
            this.setBlockEnabled(false);
            return;
        }
        if (this.storedEnergy < recipe.getEnergy()) {
            this.setBlockEnabled(false);
            return;
        }
        if (input.func_190926_b()) {
            this.time = 0;
            this.func_70296_d();
            this.setBlockEnabled(false);
            return;
        }
        if (!(output.func_190926_b() || ItemStack.func_179545_c((ItemStack)output, (ItemStack)recipe.func_77571_b()) && output.func_190916_E() + recipe.func_77571_b().func_190916_E() <= output.func_77976_d())) {
            this.time = 0;
            this.func_70296_d();
            this.setBlockEnabled(false);
            return;
        }
        if (this.currentMillibuckets + recipe.getFluidAmount() > this.fluidAmount) {
            this.time = 0;
            this.func_70296_d();
            this.setBlockEnabled(false);
            return;
        }
        ++this.time;
        this.storedEnergy -= recipe.getEnergy();
        if (this.time > recipe.getDuration()) {
            this.time = 0;
            if (output.func_190926_b()) {
                this.inventory.func_70299_a(1, recipe.func_77571_b());
            } else if (output.func_190916_E() < output.func_77976_d()) {
                output.func_190917_f(recipe.func_77571_b().func_190916_E());
            }
            this.currentMillibuckets += recipe.getFluidAmount();
            input.func_190918_g(1);
        }
        this.func_70296_d();
        this.setBlockEnabled(true);
    }

    public abstract BlockGui<? extends TileEntityEnergyFluidProducer> getOwnBlock();

    public void setBlockEnabled(boolean enabled) {
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c().equals(this.getOwnBlock())) {
            this.getOwnBlock().setPowered(this.field_145850_b, this.field_174879_c, state, enabled);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("energy_stored", this.storedEnergy);
        compound.func_74768_a("time", this.time);
        compound.func_74768_a("fluid_stored", this.currentMillibuckets);
        ItemUtils.saveInventory(compound, "slots", (IInventory)this.inventory);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        this.storedEnergy = compound.func_74762_e("energy_stored");
        this.time = compound.func_74762_e("time");
        this.currentMillibuckets = compound.func_74762_e("fluid_stored");
        ItemUtils.readInventory(compound, "slots", (IInventory)this.inventory);
        super.func_230337_a_(blockState, compound);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inventory.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_174889_b(PlayerEntity player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(PlayerEntity player) {
        this.inventory.func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.inventory.func_94041_b(index, stack);
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return index == 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    public int getTimeToGenerate() {
        EnergyFluidProducerRecipe recipe = this.getRecipe();
        if (recipe == null) {
            return 0;
        }
        return recipe.getDuration();
    }

    public int getGeneratingTime() {
        return this.time;
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public int getCurrentMillibuckets() {
        return this.currentMillibuckets;
    }

    public abstract Fluid getProducingFluid();

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyNeeded = this.maxEnergy - this.storedEnergy;
        if (!simulate) {
            this.storedEnergy += Math.min(energyNeeded, maxReceive);
            this.func_70296_d();
        }
        return Math.min(energyNeeded, maxReceive);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxEnergy;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    @Override
    public IIntArray getFields() {
        return this.FIELDS;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return new FluidStack(this.getProducingFluid(), this.currentMillibuckets);
    }

    public int getTankCapacity(int tank) {
        return this.fluidAmount;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return stack.getFluid().equals(this.getProducingFluid());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        int amount = Math.min(resource.getAmount(), this.currentMillibuckets);
        if (action.execute()) {
            this.currentMillibuckets -= amount;
            this.func_70296_d();
        }
        return new FluidStack(this.getProducingFluid(), amount);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int amount = Math.min(maxDrain, this.currentMillibuckets);
        if (action.execute()) {
            this.currentMillibuckets -= amount;
            this.func_70296_d();
        }
        return new FluidStack(this.getProducingFluid(), amount);
    }
}

