/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.BlockGasStation;
import de.maxhenkel.car.blocks.BlockGasStationTop;
import de.maxhenkel.car.blocks.BlockOrientableHorizontal;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.CachedValue;
import de.maxhenkel.car.corelib.item.ItemUtils;
import de.maxhenkel.car.net.MessageStartFuel;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.car.sounds.SoundLoopTileentity;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityGasStation
extends TileEntityBase
implements ITickableTileEntity,
IFluidHandler,
SoundLoopTileentity.ISoundLoopable {
    private FluidStack storage;
    public int maxStorageAmount = 16000;
    private final int transferRate;
    private int fuelCounter;
    private boolean isFueling;
    private boolean wasFueling;
    private Inventory inventory;
    private Inventory trading;
    private int tradeAmount;
    private int freeAmountLeft;
    private UUID owner;
    public final IIntArray FIELDS = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TileEntityGasStation.this.fuelCounter;
                }
                case 1: {
                    if (!TileEntityGasStation.this.storage.isEmpty()) {
                        return TileEntityGasStation.this.storage.getAmount();
                    }
                    return 0;
                }
                case 2: {
                    return TileEntityGasStation.this.tradeAmount;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityGasStation.this.fuelCounter = value;
                    break;
                }
                case 1: {
                    if (TileEntityGasStation.this.storage.isEmpty()) break;
                    TileEntityGasStation.this.storage.setAmount(value);
                    break;
                }
                case 2: {
                    TileEntityGasStation.this.tradeAmount = value;
                    TileEntityGasStation.this.func_70296_d();
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };
    private CachedValue<Vector3d> center = new CachedValue<Vector3d>(() -> new Vector3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5));
    private CachedValue<AxisAlignedBB> detectionBox = new CachedValue<AxisAlignedBB>(this::createDetectionBox);

    public TileEntityGasStation() {
        super(Main.GAS_STATION_TILE_ENTITY_TYPE);
        this.transferRate = (Integer)Main.SERVER_CONFIG.gasStationTransferRate.get();
        this.fuelCounter = 0;
        this.inventory = new Inventory(27);
        this.trading = new Inventory(2);
        this.owner = new UUID(0L, 0L);
        this.storage = FluidStack.EMPTY;
    }

    @Override
    public ITextComponent getTranslatedName() {
        return new TranslationTextComponent("block.car.fuel_station");
    }

    private void fixTop() {
        BlockState top = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
        BlockState bottom = this.field_145850_b.func_180495_p(this.field_174879_c);
        Direction facing = (Direction)bottom.func_177229_b((Property)BlockOrientableHorizontal.FACING);
        if (top.func_177230_c().equals((Object)ModBlocks.FUEL_STATION_TOP)) {
            if (!((Direction)top.func_177229_b((Property)BlockGasStationTop.FACING)).equals((Object)facing)) {
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177984_a(), (BlockState)ModBlocks.FUEL_STATION_TOP.func_176223_P().func_206870_a((Property)BlockGasStationTop.FACING, (Comparable)facing));
            }
        } else if (this.field_145850_b.func_175623_d(this.field_174879_c.func_177984_a())) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177984_a(), (BlockState)ModBlocks.FUEL_STATION_TOP.func_176223_P().func_206870_a((Property)BlockGasStationTop.FACING, (Comparable)facing));
        }
    }

    public void func_73660_a() {
        FluidStack result;
        IFluidHandler handler;
        if (this.field_145850_b.func_82737_E() % 100L == 0L) {
            this.fixTop();
        }
        if ((handler = this.getFluidHandlerInFront()) == null) {
            if (this.fuelCounter > 0 || this.isFueling) {
                this.fuelCounter = 0;
                this.isFueling = false;
                this.synchronize();
                this.func_70296_d();
            }
            return;
        }
        if (!this.isFueling) {
            return;
        }
        if (this.storage.isEmpty()) {
            return;
        }
        FluidStack s = FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)this, (int)this.transferRate, (boolean)false);
        int amountCarCanTake = 0;
        if (!s.isEmpty()) {
            amountCarCanTake = s.getAmount();
        }
        if (amountCarCanTake <= 0) {
            return;
        }
        if (this.freeAmountLeft <= 0) {
            if (this.tradeAmount <= 0) {
                this.freeAmountLeft = this.transferRate;
                this.func_70296_d();
            } else if (this.removeTradeItem()) {
                this.freeAmountLeft = this.tradeAmount;
                this.func_70296_d();
            } else {
                this.isFueling = false;
                this.synchronize();
                return;
            }
        }
        if (!(result = FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)this, (int)Math.min(this.transferRate, this.freeAmountLeft), (boolean)true)).isEmpty()) {
            this.fuelCounter += result.getAmount();
            this.freeAmountLeft -= result.getAmount();
            this.synchronize(100);
            this.func_70296_d();
            if (!this.wasFueling) {
                this.synchronize();
            }
            this.wasFueling = true;
        } else {
            if (this.wasFueling) {
                this.synchronize();
            }
            this.wasFueling = false;
        }
    }

    public boolean removeTradeItem() {
        ItemStack tradeTemplate = this.trading.func_70301_a(0);
        ItemStack tradingStack = this.trading.func_70301_a(1);
        if (tradeTemplate.func_190926_b()) {
            return true;
        }
        if (tradingStack.func_190926_b()) {
            return false;
        }
        if (!tradeTemplate.func_77973_b().equals(tradingStack.func_77973_b())) {
            return false;
        }
        if (tradeTemplate.func_77952_i() != tradingStack.func_77952_i()) {
            return false;
        }
        if (tradingStack.func_190916_E() < tradeTemplate.func_190916_E()) {
            return false;
        }
        ItemStack addStack = tradingStack.func_77946_l();
        addStack.func_190920_e(tradeTemplate.func_190916_E());
        ItemStack add = this.inventory.func_174894_a(addStack);
        if (add.func_190916_E() > 0) {
            return false;
        }
        tradingStack.func_190920_e(tradingStack.func_190916_E() - tradeTemplate.func_190916_E());
        this.trading.func_70299_a(1, tradingStack);
        return true;
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public IInventory getTradingInventory() {
        return this.trading;
    }

    public boolean isValidFluid(Fluid f) {
        return Main.SERVER_CONFIG.gasStationValidFuelList.stream().anyMatch(arg_0 -> ((Fluid)f).func_207185_a(arg_0));
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.func_70296_d();
    }

    public void setOwner(PlayerEntity player) {
        this.owner = new UUID(player.func_110124_au().getMostSignificantBits(), player.func_110124_au().getLeastSignificantBits());
        this.func_70296_d();
    }

    public boolean isOwner(PlayerEntity player) {
        ServerPlayerEntity p;
        boolean isOp;
        if (player instanceof ServerPlayerEntity && (isOp = (p = (ServerPlayerEntity)player).func_211513_k(p.field_71133_b.func_110455_j()))) {
            return true;
        }
        return player.func_110124_au().equals(this.owner);
    }

    public boolean hasTrade() {
        return !this.trading.func_70301_a(0).func_190926_b();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("counter", this.fuelCounter);
        if (!this.storage.isEmpty()) {
            CompoundNBT comp = new CompoundNBT();
            this.storage.writeToNBT(comp);
            compound.func_218657_a("fluid", (INBT)comp);
        }
        ItemUtils.saveInventory(compound, "inventory", (IInventory)this.inventory);
        ItemUtils.saveInventory(compound, "trading", (IInventory)this.trading);
        compound.func_74768_a("trade_amount", this.tradeAmount);
        compound.func_74768_a("free_amount", this.freeAmountLeft);
        compound.func_186854_a("owner", this.owner);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        this.fuelCounter = compound.func_74762_e("counter");
        if (compound.func_74764_b("fluid")) {
            CompoundNBT comp = compound.func_74775_l("fluid");
            this.storage = FluidStack.loadFluidStackFromNBT((CompoundNBT)comp);
        }
        ItemUtils.readInventory(compound, "inventory", (IInventory)this.inventory);
        ItemUtils.readInventory(compound, "trading", (IInventory)this.trading);
        this.tradeAmount = compound.func_74762_e("trade_amount");
        this.freeAmountLeft = compound.func_74762_e("free_amount");
        this.owner = compound.func_74764_b("owner") ? compound.func_186857_a("owner") : new UUID(0L, 0L);
        super.func_230337_a_(blockState, compound);
    }

    public boolean isFueling() {
        return this.isFueling;
    }

    public int getFuelCounter() {
        return this.fuelCounter;
    }

    public void setStorage(FluidStack storage) {
        this.storage = storage;
        this.func_70296_d();
        this.synchronize();
    }

    public FluidStack getStorage() {
        return this.storage;
    }

    public void setFuelCounter(int fuelCounter) {
        this.fuelCounter = fuelCounter;
        this.func_70296_d();
        this.synchronize();
    }

    public void setFueling(boolean isFueling) {
        if (this.getFluidHandlerInFront() == null) {
            return;
        }
        if (isFueling && !this.isFueling && this.field_145850_b.field_72995_K) {
            this.playSound();
        }
        this.isFueling = isFueling;
        this.synchronize();
    }

    public String getRenderText() {
        IFluidHandler fluidHandler = this.getFluidHandlerInFront();
        if (fluidHandler == null) {
            return new TranslationTextComponent("gas_station.no_car").getString();
        }
        if (this.fuelCounter <= 0) {
            return new TranslationTextComponent("gas_station.ready").getString();
        }
        return new TranslationTextComponent("gas_station.fuel_amount", new Object[]{this.fuelCounter}).getString();
    }

    public IFluidHandler getFluidHandlerInFront() {
        return this.field_145850_b.func_217357_a(Entity.class, this.getDetectionBox()).stream().sorted(Comparator.comparingDouble(o -> o.func_195048_a(this.center.get()))).map(entity -> (IFluidHandler)entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private AxisAlignedBB createDetectionBox() {
        BlockState ownState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!ownState.func_177230_c().equals(ModBlocks.GAS_STATION)) {
            return null;
        }
        Direction facing = (Direction)ownState.func_177229_b((Property)BlockGasStation.FACING);
        BlockPos start = this.field_174879_c.func_177972_a(facing);
        return new AxisAlignedBB((double)start.func_177958_n(), (double)start.func_177956_o(), (double)start.func_177952_p(), (double)start.func_177958_n() + 1.0, (double)start.func_177956_o() + 2.5, (double)start.func_177952_p() + 1.0).func_72321_a((double)facing.func_82601_c(), 0.0, (double)facing.func_82599_e()).func_72314_b(facing.func_82601_c() == 0 ? 0.5 : 0.0, 0.0, facing.func_82599_e() == 0 ? 0.5 : 0.0);
    }

    public AxisAlignedBB getDetectionBox() {
        return this.detectionBox.get();
    }

    public boolean canEntityBeFueled() {
        IFluidHandler handler = this.getFluidHandlerInFront();
        if (handler == null) {
            return false;
        }
        FluidStack result = FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)this, (int)this.transferRate, (boolean)false);
        return !result.isEmpty();
    }

    public BlockState func_195044_w() {
        BlockState ownState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!ownState.func_177230_c().equals(ModBlocks.GAS_STATION)) {
            return null;
        }
        return ownState;
    }

    public Direction getDirection() {
        BlockState state = this.func_195044_w();
        if (state == null) {
            return Direction.NORTH;
        }
        return (Direction)state.func_177229_b((Property)BlockGasStation.FACING);
    }

    public void sendStartFuelPacket(boolean start) {
        if (this.field_145850_b.field_72995_K) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageStartFuel(this.field_174879_c, start));
        }
    }

    @Override
    public boolean shouldSoundBePlayed() {
        if (!this.isFueling) {
            return false;
        }
        return this.canEntityBeFueled();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playSound() {
        ModSounds.playSoundLoop(new SoundLoopTileentity(ModSounds.GAS_STATION, SoundCategory.BLOCKS, this), this.field_145850_b);
    }

    @Override
    public void play() {
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
    }

    public int getTradeAmount() {
        return this.tradeAmount;
    }

    public void setTradeAmount(int tradeAmount) {
        this.tradeAmount = tradeAmount;
    }

    public int getFuelAmount() {
        if (!this.storage.isEmpty()) {
            return this.storage.getAmount();
        }
        return 0;
    }

    @Override
    public IIntArray getFields() {
        return this.FIELDS;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.storage;
    }

    public int getTankCapacity(int tank) {
        return this.maxStorageAmount;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isValidFluid(stack.getFluid());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isValidFluid(resource.getFluid())) {
            return 0;
        }
        if (this.storage.isEmpty()) {
            int amount = Math.min(resource.getAmount(), this.maxStorageAmount);
            if (action.execute()) {
                this.storage = new FluidStack(resource.getFluid(), amount);
                this.synchronize();
                this.func_70296_d();
            }
            return amount;
        }
        if (resource.getFluid().equals(this.storage.getFluid())) {
            int amount = Math.min(resource.getAmount(), this.maxStorageAmount - this.storage.getAmount());
            if (action.execute()) {
                this.storage.setAmount(this.storage.getAmount() + amount);
                this.func_70296_d();
            }
            return amount;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.storage.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (this.storage.getFluid().equals(resource.getFluid())) {
            int amount = Math.min(resource.getAmount(), this.storage.getAmount());
            Fluid f = this.storage.getFluid();
            if (action.execute()) {
                this.storage.setAmount(this.storage.getAmount() - amount);
                if (this.storage.getAmount() <= 0) {
                    this.storage = FluidStack.EMPTY;
                    this.synchronize();
                }
                this.func_70296_d();
            }
            return new FluidStack(f, amount);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.storage.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int amount = Math.min(maxDrain, this.storage.getAmount());
        Fluid f = this.storage.getFluid();
        if (action.execute()) {
            this.storage.setAmount(this.storage.getAmount() - amount);
            if (this.storage.getAmount() <= 0) {
                this.storage = FluidStack.EMPTY;
                this.synchronize();
            }
            this.func_70296_d();
        }
        return new FluidStack(f, amount);
    }
}

