/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.corelib.inventory;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class ScreenBase<T extends Container>
extends ContainerScreen<T> {
    public static final int FONT_COLOR = 0x404040;
    protected ResourceLocation texture;
    protected List<HoverArea> hoverAreas;

    public ScreenBase(ResourceLocation texture, T container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.texture = texture;
        this.hoverAreas = new ArrayList<HoverArea>();
    }

    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, x, y, partialTicks);
        this.func_230459_a_(matrixStack, x, y);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.texture);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
    }

    public void drawHoverAreas(MatrixStack matrixStack, int mouseX, int mouseY) {
        for (HoverArea hoverArea : this.hoverAreas) {
            if (hoverArea.tooltip == null || !hoverArea.isHovered(this.field_147003_i, this.field_147009_r, mouseX, mouseY)) continue;
            this.func_238654_b_(matrixStack, (List)hoverArea.tooltip.get(), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    public int getBlitSize(int amount, int max, int size) {
        return size - (int)((float)amount / (float)max * (float)size);
    }

    public void drawCentered(MatrixStack matrixStack, ITextComponent text, int y, int color) {
        this.drawCentered(matrixStack, text, this.field_146999_f / 2, y, color);
    }

    public void drawCentered(MatrixStack matrixStack, ITextComponent text, int x, int y, int color) {
        ScreenBase.drawCentered(this.field_230712_o_, matrixStack, text, x, y, color);
    }

    public static void drawCentered(FontRenderer font, MatrixStack matrixStack, ITextComponent text, int x, int y, int color) {
        int width = font.func_238414_a_((ITextProperties)text);
        font.func_243248_b(matrixStack, text, (float)(x - width / 2), (float)y, color);
    }

    public static class HoverArea {
        private final int posX;
        private final int posY;
        private final int width;
        private final int height;
        @Nullable
        private final Supplier<List<IReorderingProcessor>> tooltip;

        public HoverArea(int posX, int posY, int width, int height) {
            this(posX, posY, width, height, null);
        }

        public HoverArea(int posX, int posY, int width, int height, Supplier<List<IReorderingProcessor>> tooltip) {
            this.posX = posX;
            this.posY = posY;
            this.width = width;
            this.height = height;
            this.tooltip = tooltip;
        }

        public int getPosX() {
            return this.posX;
        }

        public int getPosY() {
            return this.posY;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        @Nullable
        public Supplier<List<IReorderingProcessor>> getTooltip() {
            return this.tooltip;
        }

        public boolean isHovered(int guiLeft, int guiTop, int mouseX, int mouseY) {
            return mouseX >= guiLeft + this.posX && mouseX < guiLeft + this.posX + this.width && mouseY >= guiTop + this.posY && mouseY < guiTop + this.posY + this.height;
        }
    }
}

