/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.Main;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class EntityVehicleBase
extends Entity {
    public static float SCALE_FACTOR = 0.7f;
    private int steps;
    private double clientX;
    private double clientY;
    private double clientZ;
    private double clientYaw;
    private double clientPitch;
    protected float deltaRotation;
    protected AxisAlignedBB boundingBox;

    public EntityVehicleBase(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70156_m = true;
        this.field_70138_W = 0.6f;
        this.recalculateBoundingBox();
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70169_q = this.func_226277_ct_();
            this.field_70167_r = this.func_226278_cu_();
            this.field_70166_s = this.func_226281_cx_();
        }
        this.func_233577_ch_();
        super.func_70071_h_();
        this.tickLerp();
        this.recalculateBoundingBox();
    }

    public void recalculateBoundingBox() {
        double width = this.getCarWidth();
        double height = this.getCarHeight();
        this.boundingBox = new AxisAlignedBB(this.func_226277_ct_() - width / 2.0, this.func_226278_cu_(), this.func_226281_cx_() - width / 2.0, this.func_226277_ct_() + width / 2.0, this.func_226278_cu_() + height, this.func_226281_cx_() + width / 2.0);
    }

    public double getCarWidth() {
        return 1.3;
    }

    public double getCarHeight() {
        return 1.6;
    }

    public PlayerEntity getDriver() {
        List passengers = this.func_184188_bt();
        if (passengers.size() <= 0) {
            return null;
        }
        if (passengers.get(0) instanceof PlayerEntity) {
            return (PlayerEntity)passengers.get(0);
        }
        return null;
    }

    public abstract int getPassengerSize();

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < this.getPassengerSize();
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-130.0f, (float)130.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public abstract Vector3d[] getPlayerOffsets();

    public void func_184232_k(Entity passenger) {
        if (!this.func_184196_w(passenger)) {
            return;
        }
        double front = 0.0;
        double side = 0.0;
        double height = 0.0;
        List passengers = this.func_184188_bt();
        if (passengers.size() > 0) {
            int i = passengers.indexOf(passenger);
            Vector3d offset = this.getPlayerOffsets()[i];
            front = offset.field_72450_a;
            side = offset.field_72449_c;
            height = offset.field_72448_b;
        }
        Vector3d vec3d = new Vector3d(front, height, side).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
        passenger.func_70107_b(this.func_226277_ct_() + vec3d.field_72450_a, this.func_226278_cu_() + vec3d.field_72448_b, this.func_226281_cx_() + vec3d.field_72449_c);
        passenger.field_70177_z += this.deltaRotation;
        passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
        this.applyYawToEntity(passenger);
    }

    public Entity func_184179_bs() {
        return this.getDriver();
    }

    public boolean func_241849_j(Entity entity) {
        if (!((Boolean)Main.SERVER_CONFIG.collideWithEntities.get()).booleanValue() && !(entity instanceof EntityVehicleBase)) {
            return false;
        }
        return (entity.func_241845_aY() || entity.func_70104_M()) && !this.func_184223_x(entity);
    }

    public boolean func_241845_aY() {
        return true;
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.boundingBox;
    }

    public void func_174826_a(AxisAlignedBB boundingBox) {
        this.boundingBox = boundingBox;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    private void tickLerp() {
        if (this.func_184186_bw()) {
            this.steps = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.steps > 0) {
            double d0 = this.func_226277_ct_() + (this.clientX - this.func_226277_ct_()) / (double)this.steps;
            double d1 = this.func_226278_cu_() + (this.clientY - this.func_226278_cu_()) / (double)this.steps;
            double d2 = this.func_226281_cx_() + (this.clientZ - this.func_226281_cx_()) / (double)this.steps;
            double d3 = MathHelper.func_76138_g((double)(this.clientYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.steps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.clientPitch - (double)this.field_70125_A) / (double)this.steps);
            --this.steps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.clientX = x;
        this.clientY = y;
        this.clientZ = z;
        this.clientYaw = yaw;
        this.clientPitch = pitch;
        this.steps = 10;
    }

    public static double calculateMotionX(float speed, float rotationYaw) {
        return MathHelper.func_76126_a((float)(-rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    public static double calculateMotionZ(float speed, float rotationYaw) {
        return MathHelper.func_76134_b((float)(rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!player.func_225608_bj_()) {
            if (player.func_184187_bx() != this && !this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public abstract boolean doesEnterThirdPerson();

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

