/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.integration.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.integration.jei.CarRecipe;
import de.maxhenkel.car.integration.jei.JEIPlugin;
import de.maxhenkel.tools.EntityTools;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class CarRecipeCategory
implements IRecipeCategory<CarRecipe> {
    private IGuiHelper helper;
    private static final int RECIPE_WIDTH = 175;
    private static final int RECIPE_HEIGHT = 54;
    private EntityTools.SimulatedCarRenderer renderer = new EntityTools.SimulatedCarRenderer();

    public CarRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
    }

    public IDrawable getBackground() {
        return this.helper.createDrawable(new ResourceLocation("car", "textures/gui/jei_car_workshop_crafting.png"), 0, 0, 175, 54);
    }

    public IDrawable getIcon() {
        return this.helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.CAR_WORKSHOP));
    }

    public void setIngredients(CarRecipe recipe, IIngredients iIngredients) {
        iIngredients.setInputs(VanillaTypes.ITEM, recipe.getInputs());
    }

    public String getTitle() {
        return ModBlocks.CAR_WORKSHOP.func_235333_g_().getString();
    }

    public ResourceLocation getUid() {
        return JEIPlugin.CATEGORY_CAR_WORKSHOP;
    }

    public Class<? extends CarRecipe> getRecipeClass() {
        return CarRecipe.class;
    }

    public void setRecipe(IRecipeLayout layout, CarRecipe wrapper, IIngredients ingredients) {
        IGuiItemStackGroup group = layout.getItemStacks();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 5; ++x) {
                ItemStack stack;
                group.init(x + y * 5, true, x * 18, y * 18);
                int index = x + y * 5;
                if (index >= wrapper.getInputs().size() || (stack = wrapper.getInputs().get(index)).func_190926_b()) continue;
                group.set(index, stack);
            }
        }
    }

    public void draw(CarRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.renderer.render(matrixStack, recipe.getCar(), 145, 41, 18);
    }
}

